/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.rx;

import com.netflix.hystrix.util.HystrixTimer;
import com.netflix.ribbon.examples.rx.common.Movie;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import rx.Notification;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public abstract class AbstractRxMovieClient {
    protected static final String TEST_USER = "user1";
    protected static final Pattern NEW_LINE_SPLIT_RE = Pattern.compile("\n");

    protected abstract Observable<ByteBuf>[] triggerMoviesRegistration();

    protected abstract Observable<ByteBuf>[] triggerRecommendationsUpdate();

    protected abstract Observable<ByteBuf>[] triggerRecommendationsSearch();

    protected Observable<ByteBuf> registerMovies() {
        return Observable.concat((Observable)Observable.from((Object[])this.triggerMoviesRegistration()));
    }

    protected Observable<ByteBuf> updateRecommendations() {
        return Observable.concat((Observable)Observable.from((Object[])this.triggerRecommendationsUpdate()));
    }

    protected Observable<Void> searchCatalog() {
        ArrayList searches = new ArrayList(2);
        Collections.addAll(searches, "findById", "findRawMovieById", "findMovie(name, category)");
        return Observable.concat((Observable)Observable.from((Object[])this.triggerRecommendationsSearch())).flatMap((Func1)new Func1<ByteBuf, Observable<List<Movie>>>(){

            public Observable<List<Movie>> call(ByteBuf byteBuf) {
                ArrayList<Movie> movies = new ArrayList<Movie>();
                String lines = byteBuf.toString(Charset.defaultCharset());
                for (String line : NEW_LINE_SPLIT_RE.split(lines)) {
                    movies.add(Movie.from(line));
                }
                return Observable.just(movies);
            }
        }).zipWith(searches, (Func2)new Func2<List<Movie>, String, Void>(){

            public Void call(List<Movie> movies, String query) {
                System.out.println(String.format("    %s=%s", query, movies));
                return null;
            }
        });
    }

    public boolean runExample() {
        boolean allGood = true;
        try {
            System.out.println("Registering movies...");
            Notification<Void> result = this.executeServerCalls();
            boolean bl = allGood = !result.isOnError();
            if (allGood) {
                System.out.println("Application finished");
            } else {
                System.err.println("ERROR: execution failure");
                result.getThrowable().printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            allGood = false;
        }
        finally {
            this.shutdown();
        }
        return allGood;
    }

    Notification<Void> executeServerCalls() {
        Observable resultObservable = this.registerMovies().materialize().flatMap((Func1)new Func1<Notification<ByteBuf>, Observable<Void>>(){

            public Observable<Void> call(Notification<ByteBuf> notif) {
                if (!AbstractRxMovieClient.verifyStatus((Notification<ByteBuf>)notif)) {
                    return Observable.error((Throwable)notif.getThrowable());
                }
                System.out.print("Updating user recommendations...");
                return AbstractRxMovieClient.this.updateRecommendations().materialize().flatMap((Func1)new Func1<Notification<ByteBuf>, Observable<Void>>(){

                    public Observable<Void> call(Notification<ByteBuf> notif) {
                        if (!AbstractRxMovieClient.verifyStatus((Notification<ByteBuf>)notif)) {
                            return Observable.error((Throwable)notif.getThrowable());
                        }
                        System.out.println("Searching through the movie catalog...");
                        return AbstractRxMovieClient.this.searchCatalog();
                    }
                });
            }
        });
        return (Notification)resultObservable.materialize().toBlocking().last();
    }

    protected void shutdown() {
        HystrixTimer.reset();
    }

    private static boolean verifyStatus(Notification<ByteBuf> notif) {
        if (notif.isOnError()) {
            System.out.println("ERROR");
            return false;
        }
        System.out.println("DONE");
        return true;
    }
}

