/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.restclient;

import com.netflix.client.ClientFactory;
import com.netflix.client.ClientRequest;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.config.ConfigurationManager;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import com.netflix.niws.client.http.RestClient;
import java.net.URI;

public class SampleApp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ConfigurationManager.loadPropertiesFromResources((String)"sample-client.properties");
        System.out.println(ConfigurationManager.getConfigInstance().getProperty("sample-client.ribbon.listOfServers"));
        RestClient client = (RestClient)ClientFactory.getNamedClient((String)"sample-client");
        HttpRequest request = HttpRequest.newBuilder().uri(new URI("/")).build();
        for (int i = 0; i < 20; ++i) {
            HttpResponse response = (HttpResponse)client.executeWithLoadBalancer((ClientRequest)request);
            System.out.println("Status code for " + response.getRequestedURI() + "  :" + response.getStatus());
        }
        ZoneAwareLoadBalancer lb = (ZoneAwareLoadBalancer)client.getLoadBalancer();
        System.out.println(lb.getLoadBalancerStats());
        ConfigurationManager.getConfigInstance().setProperty("sample-client.ribbon.listOfServers", (Object)"www.linkedin.com:80,www.google.com:80");
        System.out.println("changing servers ...");
        Thread.sleep(3000L);
        for (int i = 0; i < 20; ++i) {
            try (HttpResponse response = null;){
                response = (HttpResponse)client.executeWithLoadBalancer((ClientRequest)request);
                System.out.println("Status code for " + response.getRequestedURI() + "  : " + response.getStatus());
                continue;
            }
        }
        System.out.println(lb.getLoadBalancerStats());
    }
}

