/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples;

import com.sun.jersey.api.container.httpserver.HttpServerFactory;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.net.httpserver.HttpServer;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class ExampleAppWithLocalResource {
    public int port = new Random().nextInt(1000) + 4000;
    public String SERVICE_URI = "http://localhost:" + this.port + "/";
    HttpServer server = null;

    public abstract void run() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings
    public final void runApp() throws Exception {
        PackagesResourceConfig resourceConfig = new PackagesResourceConfig(new String[]{"com.netflix.ribbon.examples.server"});
        ExecutorService service = Executors.newFixedThreadPool(50);
        try {
            this.server = HttpServerFactory.create((String)this.SERVICE_URI, (ResourceConfig)resourceConfig);
            this.server.setExecutor(service);
            this.server.start();
            this.run();
        }
        finally {
            System.err.println("Shut down server ...");
            if (this.server != null) {
                this.server.stop(1);
            }
            service.shutdownNow();
        }
        System.exit(0);
    }
}

