/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.rx;

import com.netflix.ribbon.examples.rx.common.Movie;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ConcurrentSet;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerBuilder;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rx.Observable;
import rx.functions.Func1;

public class RxMovieServer {
    public static final int DEFAULT_PORT = 8080;
    private static final Pattern USER_RECOMMENDATIONS_PATH_RE = Pattern.compile(".*/users/([^/]*)/recommendations");
    private final int port;
    final Map<String, Movie> movies = new ConcurrentHashMap<String, Movie>();
    final Map<String, Set<String>> userRecommendations = new ConcurrentHashMap<String, Set<String>>();

    public RxMovieServer(int port) {
        this.port = port;
    }

    public HttpServer<ByteBuf, ByteBuf> createServer() {
        HttpServer server = ((HttpServerBuilder)((HttpServerBuilder)RxNetty.newHttpServerBuilder((int)this.port, (RequestHandler)new RequestHandler<ByteBuf, ByteBuf>(){

            public Observable<Void> handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
                if (request.getPath().contains("/users")) {
                    if (request.getHttpMethod().equals((Object)HttpMethod.GET)) {
                        return RxMovieServer.this.handleRecommendationsByUserId((HttpServerRequest<ByteBuf>)request, (HttpServerResponse<ByteBuf>)response);
                    }
                    return RxMovieServer.this.handleUpdateRecommendationsForUser((HttpServerRequest<ByteBuf>)request, (HttpServerResponse<ByteBuf>)response);
                }
                if (request.getPath().contains("/recommendations")) {
                    return RxMovieServer.this.handleRecommendationsBy((HttpServerRequest<ByteBuf>)request, (HttpServerResponse<ByteBuf>)response);
                }
                if (request.getPath().contains("/movies")) {
                    return RxMovieServer.this.handleRegisterMovie((HttpServerRequest<ByteBuf>)request, (HttpServerResponse<ByteBuf>)response);
                }
                response.setStatus(HttpResponseStatus.NOT_FOUND);
                return response.close();
            }
        }).pipelineConfigurator(PipelineConfigurators.httpServerConfigurator())).enableWireLogging(LogLevel.ERROR)).build();
        System.out.println("RxMovie server started...");
        return server;
    }

    private Observable<Void> handleRecommendationsByUserId(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
        System.out.println("HTTP request -> recommendations by user id request: " + request.getPath());
        String userId = RxMovieServer.userIdFromPath(request.getPath());
        if (userId == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return response.close();
        }
        if (!this.userRecommendations.containsKey(userId)) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
            return response.close();
        }
        StringBuilder builder = new StringBuilder();
        for (String movieId : this.userRecommendations.get(userId)) {
            System.out.println("    returning: " + this.movies.get(movieId));
            builder.append(this.movies.get(movieId)).append('\n');
        }
        ByteBuf byteBuf = UnpooledByteBufAllocator.DEFAULT.buffer();
        byteBuf.writeBytes(builder.toString().getBytes(Charset.defaultCharset()));
        response.write((Object)byteBuf);
        return response.close();
    }

    private Observable<Void> handleRecommendationsBy(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
        System.out.println(String.format("HTTP request -> recommendations by multiple criteria: %s?%s", request.getPath(), request.getQueryString()));
        List category = (List)request.getQueryParameters().get("category");
        List ageGroup = (List)request.getQueryParameters().get("ageGroup");
        if (category.isEmpty() || ageGroup.isEmpty()) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return response.close();
        }
        boolean any = false;
        StringBuilder builder = new StringBuilder();
        for (Movie movie : this.movies.values()) {
            if (!movie.getCategory().equals(category.get(0)) || !movie.getAgeGroup().equals(ageGroup.get(0))) continue;
            System.out.println("    returning: " + movie);
            builder.append(movie).append('\n');
            any = true;
        }
        if (!any) {
            System.out.println("No movie matched the given criteria:");
            for (Movie movie : this.movies.values()) {
                System.out.print("    ");
                System.out.println(movie);
            }
        }
        ByteBuf byteBuf = UnpooledByteBufAllocator.DEFAULT.buffer();
        byteBuf.writeBytes(builder.toString().getBytes(Charset.defaultCharset()));
        response.write((Object)byteBuf);
        return response.close();
    }

    private Observable<Void> handleUpdateRecommendationsForUser(HttpServerRequest<ByteBuf> request, final HttpServerResponse<ByteBuf> response) {
        System.out.println("HTTP request -> update recommendations for user: " + request.getPath());
        final String userId = RxMovieServer.userIdFromPath(request.getPath());
        if (userId == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return response.close();
        }
        return request.getContent().flatMap((Func1)new Func1<ByteBuf, Observable<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Observable<Void> call(ByteBuf byteBuf) {
                String movieId = byteBuf.toString(Charset.defaultCharset());
                System.out.println(String.format("    updating: {user=%s, movie=%s}", userId, movieId));
                2 var3_3 = this;
                synchronized (var3_3) {
                    Object recommendations;
                    if (RxMovieServer.this.userRecommendations.containsKey(userId)) {
                        recommendations = RxMovieServer.this.userRecommendations.get(userId);
                    } else {
                        recommendations = new ConcurrentSet();
                        RxMovieServer.this.userRecommendations.put(userId, (Set<String>)recommendations);
                    }
                    recommendations.add(movieId);
                }
                response.setStatus(HttpResponseStatus.OK);
                return response.close();
            }
        });
    }

    private Observable<Void> handleRegisterMovie(HttpServerRequest<ByteBuf> request, final HttpServerResponse<ByteBuf> response) {
        System.out.println("Http request -> register movie: " + request.getPath());
        return request.getContent().flatMap((Func1)new Func1<ByteBuf, Observable<Void>>(){

            public Observable<Void> call(ByteBuf byteBuf) {
                String formatted = byteBuf.toString(Charset.defaultCharset());
                System.out.println("    movie: " + formatted);
                try {
                    Movie movie = Movie.from(formatted);
                    RxMovieServer.this.movies.put(movie.getId(), movie);
                    response.setStatus(HttpResponseStatus.CREATED);
                }
                catch (Exception e) {
                    System.err.println("Invalid movie content");
                    e.printStackTrace();
                    response.setStatus(HttpResponseStatus.BAD_REQUEST);
                }
                return response.close();
            }
        });
    }

    private static String userIdFromPath(String path) {
        Matcher matcher = USER_RECOMMENDATIONS_PATH_RE.matcher(path);
        return matcher.matches() ? matcher.group(1) : null;
    }

    public static void main(String[] args) {
        new RxMovieServer(8080).createServer().startAndWait();
    }
}

