/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.rx.template;

import com.netflix.ribbon.ClientOptions;
import com.netflix.ribbon.ResponseValidator;
import com.netflix.ribbon.Ribbon;
import com.netflix.ribbon.examples.rx.AbstractRxMovieClient;
import com.netflix.ribbon.examples.rx.common.Movie;
import com.netflix.ribbon.examples.rx.common.RecommendationServiceFallbackHandler;
import com.netflix.ribbon.examples.rx.common.RecommendationServiceResponseValidator;
import com.netflix.ribbon.examples.rx.common.RxMovieTransformer;
import com.netflix.ribbon.http.HttpRequestTemplate;
import com.netflix.ribbon.http.HttpResourceGroup;
import com.netflix.ribbon.hystrix.FallbackHandler;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.channel.ContentTransformer;
import io.reactivex.netty.channel.StringTransformer;
import rx.Observable;

public class RxMovieTemplateExample
extends AbstractRxMovieClient {
    private final HttpResourceGroup httpResourceGroup;
    private final HttpRequestTemplate<ByteBuf> registerMovieTemplate;
    private final HttpRequestTemplate<ByteBuf> updateRecommendationTemplate;
    private final HttpRequestTemplate<ByteBuf> recommendationsByUserIdTemplate;
    private final HttpRequestTemplate<ByteBuf> recommendationsByTemplate;

    public RxMovieTemplateExample(int port) {
        this.httpResourceGroup = Ribbon.createHttpResourceGroup((String)"movieServiceClient", (ClientOptions)ClientOptions.create().withMaxAutoRetriesNextServer(3).withConfigurationBasedServerList("localhost:" + port));
        this.registerMovieTemplate = this.httpResourceGroup.newRequestTemplate("registerMovie", ByteBuf.class).withMethod("POST").withUriTemplate("/movies").withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc").withResponseValidator((ResponseValidator)new RecommendationServiceResponseValidator());
        this.updateRecommendationTemplate = this.httpResourceGroup.newRequestTemplate("updateRecommendation", ByteBuf.class).withMethod("POST").withUriTemplate("/users/{userId}/recommendations").withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc").withResponseValidator((ResponseValidator)new RecommendationServiceResponseValidator());
        this.recommendationsByUserIdTemplate = this.httpResourceGroup.newRequestTemplate("recommendationsByUserId", ByteBuf.class).withMethod("GET").withUriTemplate("/users/{userId}/recommendations").withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc").withFallbackProvider((FallbackHandler)new RecommendationServiceFallbackHandler()).withResponseValidator((ResponseValidator)new RecommendationServiceResponseValidator());
        this.recommendationsByTemplate = this.httpResourceGroup.newRequestTemplate("recommendationsBy", ByteBuf.class).withMethod("GET").withUriTemplate("/recommendations?category={category}&ageGroup={ageGroup}").withHeader("X-Platform-Version", "xyz").withHeader("X-Auth-Token", "abc").withFallbackProvider((FallbackHandler)new RecommendationServiceFallbackHandler()).withResponseValidator((ResponseValidator)new RecommendationServiceResponseValidator());
    }

    @Override
    protected Observable<ByteBuf>[] triggerMoviesRegistration() {
        return new Observable[]{this.registerMovieTemplate.requestBuilder().withRawContentSource(Observable.just((Object)Movie.ORANGE_IS_THE_NEW_BLACK), (ContentTransformer)new RxMovieTransformer()).build().toObservable(), this.registerMovieTemplate.requestBuilder().withRawContentSource(Observable.just((Object)Movie.BREAKING_BAD), (ContentTransformer)new RxMovieTransformer()).build().toObservable(), this.registerMovieTemplate.requestBuilder().withRawContentSource(Observable.just((Object)Movie.HOUSE_OF_CARDS), (ContentTransformer)new RxMovieTransformer()).build().toObservable()};
    }

    @Override
    protected Observable<ByteBuf>[] triggerRecommendationsUpdate() {
        return new Observable[]{this.updateRecommendationTemplate.requestBuilder().withRawContentSource(Observable.just((Object)Movie.ORANGE_IS_THE_NEW_BLACK.getId()), (ContentTransformer)new StringTransformer()).withRequestProperty("userId", (Object)"user1").build().toObservable(), this.updateRecommendationTemplate.requestBuilder().withRawContentSource(Observable.just((Object)Movie.BREAKING_BAD.getId()), (ContentTransformer)new StringTransformer()).withRequestProperty("userId", (Object)"user1").build().toObservable()};
    }

    @Override
    protected Observable<ByteBuf>[] triggerRecommendationsSearch() {
        return new Observable[]{this.recommendationsByUserIdTemplate.requestBuilder().withRequestProperty("userId", (Object)"user1").build().toObservable(), this.recommendationsByTemplate.requestBuilder().withRequestProperty("category", (Object)"Drama").withRequestProperty("ageGroup", (Object)"Adults").build().toObservable()};
    }

    public static void main(String[] args) {
        System.out.println("Starting templates based movie service...");
        new RxMovieTemplateExample(8080).runExample();
    }
}

