/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples.rx.proxy;

import com.netflix.ribbon.ClientOptions;
import com.netflix.ribbon.Ribbon;
import com.netflix.ribbon.examples.rx.AbstractRxMovieClient;
import com.netflix.ribbon.examples.rx.common.Movie;
import com.netflix.ribbon.examples.rx.proxy.MovieService;
import com.netflix.ribbon.http.HttpResourceGroup;
import com.netflix.ribbon.proxy.ProxyLifeCycle;
import io.netty.buffer.ByteBuf;
import rx.Observable;

public class RxMovieProxyExample
extends AbstractRxMovieClient {
    private final MovieService movieService;

    public RxMovieProxyExample() {
        HttpResourceGroup httpResourceGroup = Ribbon.createHttpResourceGroup((String)"movieServiceClient", (ClientOptions)ClientOptions.create().withMaxAutoRetriesNextServer(3).withConfigurationBasedServerList("localhost:8080"));
        this.movieService = (MovieService)Ribbon.from(MovieService.class, (HttpResourceGroup)httpResourceGroup);
    }

    @Override
    protected Observable<Void>[] triggerMoviesRegistration() {
        return new Observable[]{this.movieService.registerMovie(Movie.ORANGE_IS_THE_NEW_BLACK).observe(), this.movieService.registerMovie(Movie.BREAKING_BAD).observe(), this.movieService.registerMovie(Movie.HOUSE_OF_CARDS).observe()};
    }

    @Override
    protected Observable<Void>[] triggerRecommendationsUpdate() {
        return new Observable[]{this.movieService.updateRecommendations("user1", Movie.ORANGE_IS_THE_NEW_BLACK.getId()).observe(), this.movieService.updateRecommendations("user1", Movie.BREAKING_BAD.getId()).observe()};
    }

    @Override
    protected Observable<ByteBuf>[] triggerRecommendationsSearch() {
        return new Observable[]{this.movieService.recommendationsByUserId("user1").observe(), this.movieService.recommendationsBy("Drama", "Adults").observe()};
    }

    @Override
    public void shutdown() {
        super.shutdown();
        ((ProxyLifeCycle)this.movieService).shutdown();
    }

    public static void main(String[] args) {
        System.out.println("Starting proxy based movie service...");
        new RxMovieProxyExample().execute();
    }
}

