/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples;

import com.netflix.client.BufferedResponseCallback;
import com.netflix.client.ClientRequest;
import com.netflix.client.http.AsyncBufferingHttpClient;
import com.netflix.client.http.AsyncHttpClientBuilder;
import com.netflix.client.http.BufferedHttpResponseCallback;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import java.util.concurrent.Future;

public class AsyncClientSampleApp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        AsyncBufferingHttpClient client = AsyncHttpClientBuilder.withApacheAsyncClient().buildBufferingClient();
        HttpRequest request = HttpRequest.newBuilder().uri("http://www.google.com/").build();
        try {
            Future future = client.execute((ClientRequest)request, (BufferedResponseCallback)new BufferedHttpResponseCallback(){

                public void failed(Throwable e) {
                    System.err.println("failed: " + e);
                }

                public void completed(HttpResponse response) {
                    System.out.println("Get response: " + response.getStatus());
                    try {
                        response.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void cancelled() {
                    System.err.println("cancelled");
                }
            });
            HttpResponse response = (HttpResponse)future.get();
            System.out.println("Status from response " + response.getStatus());
        }
        finally {
            client.close();
        }
    }
}

