/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.examples;

import com.netflix.client.ClientRequest;
import com.netflix.client.ObservableAsyncClient;
import com.netflix.client.StreamDecoder;
import com.netflix.client.http.AsyncHttpClientBuilder;
import com.netflix.client.http.HttpRequest;
import com.netflix.client.http.HttpResponse;
import com.netflix.ribbon.examples.ExampleAppWithLocalResource;
import com.netflix.ribbon.examples.SSEDecoder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import rx.util.functions.Action1;

public class StreamingObservableExample
extends ExampleAppWithLocalResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        HttpRequest request = HttpRequest.newBuilder().uri(this.SERVICE_URI + "testAsync/stream").build();
        ObservableAsyncClient observableClient = AsyncHttpClientBuilder.withApacheAsyncClient().observableClient();
        final AtomicReference httpResponse = new AtomicReference();
        final AtomicInteger counter = new AtomicInteger();
        try {
            observableClient.stream((ClientRequest)request, (StreamDecoder)new SSEDecoder()).toBlockingObservable().forEach((Action1)new Action1<ObservableAsyncClient.StreamEvent<HttpResponse, String>>(){

                public void call(ObservableAsyncClient.StreamEvent<HttpResponse, String> t1) {
                    System.out.println("Content from server: " + (String)t1.getEvent());
                    counter.incrementAndGet();
                    httpResponse.set(t1.getResponse());
                }
            });
        }
        finally {
            ((HttpResponse)httpResponse.get()).close();
            observableClient.close();
            System.out.println("\nTotal event received: " + counter.get());
        }
    }

    public static void main(String[] args) throws Exception {
        StreamingObservableExample app = new StreamingObservableExample();
        app.runApp();
    }
}

