/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.lib;

import com.netflix.nebula.lint.jgit.lib.BranchConfig;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.revwalk.RevWalkUtils;
import com.netflix.nebula.lint.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

public class BranchTrackingStatus {
    private final String remoteTrackingBranch;
    private final int aheadCount;
    private final int behindCount;

    public static BranchTrackingStatus of(Repository repository, String branchName) throws IOException {
        String shortBranchName = Repository.shortenRefName(branchName);
        String fullBranchName = "refs/heads/" + shortBranchName;
        BranchConfig branchConfig = new BranchConfig(repository.getConfig(), shortBranchName);
        String trackingBranch = branchConfig.getTrackingBranch();
        if (trackingBranch == null) {
            return null;
        }
        Ref tracking = repository.exactRef(trackingBranch);
        if (tracking == null) {
            return null;
        }
        Ref local = repository.exactRef(fullBranchName);
        if (local == null) {
            return null;
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit localCommit = walk.parseCommit(local.getObjectId());
            RevCommit trackingCommit = walk.parseCommit(tracking.getObjectId());
            walk.setRevFilter(RevFilter.MERGE_BASE);
            walk.markStart(localCommit);
            walk.markStart(trackingCommit);
            RevCommit mergeBase = walk.next();
            walk.reset();
            walk.setRevFilter(RevFilter.ALL);
            int aheadCount = RevWalkUtils.count(walk, localCommit, mergeBase);
            int behindCount = RevWalkUtils.count(walk, trackingCommit, mergeBase);
            return new BranchTrackingStatus(trackingBranch, aheadCount, behindCount);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private BranchTrackingStatus(String remoteTrackingBranch, int aheadCount, int behindCount) {
        this.remoteTrackingBranch = remoteTrackingBranch;
        this.aheadCount = aheadCount;
        this.behindCount = behindCount;
    }

    public String getRemoteTrackingBranch() {
        return this.remoteTrackingBranch;
    }

    public int getAheadCount() {
        return this.aheadCount;
    }

    public int getBehindCount() {
        return this.behindCount;
    }
}

