/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.formatter.comment;

import com.netflix.nebula.lint.jdt.internal.formatter.comment.ICommentAttributes;
import com.netflix.nebula.lint.jdt.internal.formatter.comment.IHtmlTagDelimiters;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.Position;

public class CommentRange
extends Position
implements ICommentAttributes,
IHtmlTagDelimiters {
    private int fAttributes = 0;

    public CommentRange(int position, int count) {
        super(position, count);
    }

    protected final boolean hasAttribute(int attribute) {
        return (this.fAttributes & attribute) == attribute;
    }

    protected final boolean isClosingTag(String token, String tag) {
        boolean result;
        boolean bl = result = token.startsWith("</") && token.charAt(token.length() - 1) == '>';
        if (result) {
            this.setAttribute(8);
            result = token.substring("</".length(), token.length() - 1).equals(tag);
        }
        return result;
    }

    protected final boolean isOpeningTag(String token, String tag) {
        boolean result;
        boolean bl = result = token.length() > 0 && token.charAt(0) == '<' && !token.startsWith("</") && token.charAt(token.length() - 1) == '>';
        if (result) {
            this.setAttribute(256);
            result = token.startsWith(tag, 1);
        }
        return result;
    }

    protected final void markHtmlTag(String[] tags, String token, int attribute, boolean open, boolean close) {
        if (token.charAt(0) == '<' && token.charAt(token.length() - 1) == '>') {
            String tag = null;
            boolean isOpen = false;
            boolean isClose = false;
            int index = 0;
            while (index < tags.length) {
                tag = tags[index];
                isOpen = this.isOpeningTag(token, tag);
                isClose = this.isClosingTag(token, tag);
                if (open && isOpen || close && isClose) {
                    this.setAttribute(attribute);
                    break;
                }
                ++index;
            }
        }
    }

    protected final void markPrefixTag(String[] tags, char prefix, String token, int attribute) {
        if (token.charAt(0) == prefix) {
            String tag = null;
            int index = 0;
            while (index < tags.length) {
                tag = tags[index];
                if (token.equals(tag)) {
                    this.setAttribute(attribute);
                    break;
                }
                ++index;
            }
        }
    }

    protected final int markTagRange(String token, String tag, int level, int key, boolean html) {
        if (this.isOpeningTag(token, tag)) {
            if (level++ > 0) {
                this.setAttribute(key);
            }
        } else if (this.isClosingTag(token, tag)) {
            if (--level > 0) {
                this.setAttribute(key);
            }
        } else if (level > 0 && (html || !this.hasAttribute(32))) {
            this.setAttribute(key);
        }
        return level;
    }

    public final void move(int delta) {
        this.offset += delta;
    }

    protected final void setAttribute(int attribute) {
        this.fAttributes |= attribute;
    }

    public final void trimBegin(int delta) {
        this.offset += delta;
        this.length -= delta;
    }

    public final void trimEnd(int delta) {
        this.length += delta;
    }

    public String toString() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (this.hasAttribute(2)) {
            attributes.add("COMMENT_BLANKLINE");
        }
        if (this.hasAttribute(4)) {
            attributes.add("COMMENT_BREAK");
        }
        if (this.hasAttribute(8)) {
            attributes.add("COMMENT_CLOSE");
        }
        if (this.hasAttribute(16)) {
            attributes.add("COMMENT_CODE");
        }
        if (this.hasAttribute(32)) {
            attributes.add("COMMENT_HTML");
        }
        if (this.hasAttribute(64)) {
            attributes.add("COMMENT_IMMUTABLE");
        }
        if (this.hasAttribute(128)) {
            attributes.add("COMMENT_NEWLINE");
        }
        if (this.hasAttribute(256)) {
            attributes.add("COMMENT_OPEN");
        }
        if (this.hasAttribute(512)) {
            attributes.add("COMMENT_PARAGRAPH");
        }
        if (this.hasAttribute(1024)) {
            attributes.add("COMMENT_PARAMETER");
        }
        if (this.hasAttribute(2048)) {
            attributes.add("COMMENT_ROOT");
        }
        if (this.hasAttribute(4096)) {
            attributes.add("COMMENT_SEPARATOR");
        }
        if (this.hasAttribute(8192)) {
            attributes.add("COMMENT_FIRST_TOKEN");
        }
        if (this.hasAttribute(16384)) {
            attributes.add("COMMENT_STARTS_WITH_RANGE_DELIMITER");
        }
        StringBuffer buf = new StringBuffer("CommentRange [" + this.offset + "+" + this.length + "] {");
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            String string = (String)it.next();
            buf.append(string);
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return String.valueOf(buf.toString()) + "}";
    }
}

