/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.eval;

import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CastExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.MessageSend;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.NameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.CompilerOptions;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.FieldBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ProblemMethodBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ProblemReasons;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeConstants;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeVariableBinding;
import com.netflix.nebula.lint.jdt.internal.eval.CodeSnippetCodeStream;
import com.netflix.nebula.lint.jdt.internal.eval.CodeSnippetScope;
import com.netflix.nebula.lint.jdt.internal.eval.CodeSnippetThisReference;
import com.netflix.nebula.lint.jdt.internal.eval.EvaluationConstants;
import com.netflix.nebula.lint.jdt.internal.eval.EvaluationContext;

public class CodeSnippetMessageSend
extends MessageSend
implements ProblemReasons,
EvaluationConstants {
    EvaluationContext evaluationContext;
    FieldBinding delegateThis;

    public CodeSnippetMessageSend(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.codegenBinding.canBeSeenBy(this.actualReceiverType, this, currentScope)) {
            boolean isStatic = this.codegenBinding.isStatic();
            if (!isStatic && (this.bits & 0x1FE0) != 0) {
                ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                Object[] path = currentScope.getEmulationPath(targetType, true, false);
                if (path == null) {
                    currentScope.problemReporter().needImplementation();
                } else {
                    codeStream.generateOuterAccess(path, this, targetType, currentScope);
                }
            } else {
                this.receiver.generateCode(currentScope, codeStream, !isStatic);
            }
            this.generateArguments(this.binding, this.arguments, currentScope, codeStream);
            if (isStatic) {
                codeStream.invokestatic(this.codegenBinding);
            } else if (this.receiver.isSuper()) {
                codeStream.invokespecial(this.codegenBinding);
            } else if (this.codegenBinding.declaringClass.isInterface()) {
                codeStream.invokeinterface(this.codegenBinding);
            } else {
                codeStream.invokevirtual(this.codegenBinding);
            }
        } else {
            ((CodeSnippetCodeStream)codeStream).generateEmulationForMethod(currentScope, this.codegenBinding);
            boolean isStatic = this.codegenBinding.isStatic();
            if (!isStatic && (this.bits & 0x1FE0) != 0) {
                currentScope.problemReporter().needImplementation();
            } else {
                this.receiver.generateCode(currentScope, codeStream, !isStatic);
            }
            if (isStatic) {
                codeStream.aconst_null();
            }
            if (this.arguments != null) {
                int argsLength = this.arguments.length;
                codeStream.generateInlinedValue(argsLength);
                codeStream.newArray(currentScope.createArrayType(currentScope.getType(TypeConstants.JAVA_LANG_OBJECT, 3), 1));
                codeStream.dup();
                int i = 0;
                while (i < argsLength) {
                    codeStream.generateInlinedValue(i);
                    this.arguments[i].generateCode(currentScope, codeStream, true);
                    TypeBinding parameterBinding = this.codegenBinding.parameters[i];
                    if (parameterBinding.isBaseType() && parameterBinding != NullBinding) {
                        ((CodeSnippetCodeStream)codeStream).generateObjectWrapperForType(this.codegenBinding.parameters[i]);
                    }
                    codeStream.aastore();
                    if (i < argsLength - 1) {
                        codeStream.dup();
                    }
                    ++i;
                }
            } else {
                codeStream.generateInlinedValue(0);
                codeStream.newArray(currentScope.createArrayType(currentScope.getType(TypeConstants.JAVA_LANG_OBJECT, 3), 1));
            }
            ((CodeSnippetCodeStream)codeStream).invokeJavaLangReflectMethodInvoke();
            if (this.codegenBinding.returnType.isBaseType()) {
                int typeID = this.codegenBinding.returnType.id;
                if (typeID == 6) {
                    codeStream.pop();
                }
                ((CodeSnippetCodeStream)codeStream).checkcast(typeID);
                ((CodeSnippetCodeStream)codeStream).getBaseTypeValue(typeID);
            } else {
                codeStream.checkcast(this.codegenBinding.returnType);
            }
        }
        if (valueRequired) {
            if (this.valueCast != null) {
                codeStream.checkcast(this.valueCast);
            }
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            switch (this.binding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(pc, (int)(this.nameSourcePosition >>> 32));
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        this.codegenBinding = this.binding.original();
        if (this.codegenBinding != this.binding && this.codegenBinding.returnType.isTypeVariable()) {
            TypeVariableBinding variableReturnType = (TypeVariableBinding)this.codegenBinding.returnType;
            if (variableReturnType.firstBound != this.binding.returnType) {
                this.valueCast = this.binding.returnType;
            }
        }
        if (this.binding.declaringClass != this.actualReceiverType && !this.actualReceiverType.isArrayType()) {
            CompilerOptions options = currentScope.compilerOptions();
            if (!((options.targetJDK < 0x2E0000L || options.complianceLevel < 0x300000L && this.receiver.isImplicitThis() && this.codegenBinding.isStatic() || this.binding.declaringClass.id == 1) && this.binding.declaringClass.canBeSeenBy(currentScope))) {
                this.codegenBinding = currentScope.enclosingSourceType().getUpdatedMethodBinding(this.codegenBinding, (ReferenceBinding)this.actualReceiverType.erasure());
            }
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        boolean argHasError;
        this.constant = NotAConstant;
        boolean receiverCast = false;
        boolean argsContainCast = false;
        if (this.receiver instanceof CastExpression) {
            this.receiver.bits |= 0x20;
            receiverCast = true;
        }
        this.actualReceiverType = this.receiver.resolveType(scope);
        if (receiverCast && this.actualReceiverType != null && ((CastExpression)this.receiver).expression.resolvedType == this.actualReceiverType) {
            scope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
        }
        if (this.typeArguments != null) {
            int length = this.typeArguments.length;
            argHasError = false;
            this.genericTypeArguments = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                this.genericTypeArguments[i] = this.typeArguments[i].resolveType(scope, true);
                if (this.genericTypeArguments[i] == null) {
                    argHasError = true;
                }
                ++i;
            }
            if (argHasError) {
                return null;
            }
        }
        TypeBinding[] argumentTypes = NoParameters;
        if (this.arguments != null) {
            argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                Expression argument = this.arguments[i];
                if (argument instanceof CastExpression) {
                    argument.bits |= 0x20;
                    argsContainCast = true;
                }
                if ((argumentTypes[i] = this.arguments[i].resolveType(scope)) == null) {
                    argHasError = true;
                }
                ++i;
            }
            if (argHasError) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding = scope.findMethod((ReferenceBinding)this.actualReceiverType, this.selector, new TypeBinding[0], this);
                }
                return null;
            }
        }
        if (this.actualReceiverType == null) {
            return null;
        }
        if (this.actualReceiverType.isBaseType()) {
            scope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, argumentTypes);
            return null;
        }
        MethodBinding methodBinding = this.binding = this.receiver.isImplicitThis() ? scope.getImplicitMethod(this.selector, argumentTypes, this) : scope.getMethod(this.actualReceiverType, this.selector, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding instanceof ProblemMethodBinding && ((ProblemMethodBinding)this.binding).problemId() == 2) {
                MethodBinding privateBinding;
                if (this.evaluationContext.declaringTypeName != null) {
                    this.delegateThis = scope.getField(scope.enclosingSourceType(), DELEGATE_THIS, this);
                    if (this.delegateThis == null) {
                        this.constant = NotAConstant;
                        scope.problemReporter().invalidMethod(this, this.binding);
                        return null;
                    }
                } else {
                    this.constant = NotAConstant;
                    scope.problemReporter().invalidMethod(this, this.binding);
                    return null;
                }
                CodeSnippetScope localScope = new CodeSnippetScope(scope);
                MethodBinding methodBinding2 = privateBinding = this.receiver instanceof CodeSnippetThisReference && ((CodeSnippetThisReference)this.receiver).isImplicit ? localScope.getImplicitMethod((ReferenceBinding)this.delegateThis.type, this.selector, argumentTypes, this) : localScope.getMethod(this.delegateThis.type, this.selector, argumentTypes, this);
                if (!privateBinding.isValidBinding()) {
                    if (this.binding.declaringClass == null) {
                        if (this.actualReceiverType instanceof ReferenceBinding) {
                            this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                        } else {
                            scope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, argumentTypes);
                            return null;
                        }
                    }
                    scope.problemReporter().invalidMethod(this, this.binding);
                    return null;
                }
                this.binding = privateBinding;
            } else {
                if (this.binding.declaringClass == null) {
                    if (this.actualReceiverType instanceof ReferenceBinding) {
                        this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                    } else {
                        scope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, argumentTypes);
                        return null;
                    }
                }
                scope.problemReporter().invalidMethod(this, this.binding);
                return null;
            }
        }
        if (!this.binding.isStatic()) {
            if (this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0) {
                scope.problemReporter().mustUseAStaticMethod(this, this.binding);
            } else {
                ReferenceBinding match;
                TypeBinding receiverErasure = this.actualReceiverType.erasure();
                if (receiverErasure instanceof ReferenceBinding && (match = ((ReferenceBinding)receiverErasure).findSuperTypeWithSameErasure(this.binding.declaringClass)) == null) {
                    this.actualReceiverType = this.binding.declaringClass;
                }
                this.receiver.computeConversion(scope, this.actualReceiverType, this.actualReceiverType);
            }
        }
        CodeSnippetMessageSend.checkInvocationArguments(scope, this.receiver, this.actualReceiverType, this.binding, this.arguments, argumentTypes, argsContainCast, this);
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            scope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.actualReceiverType.isArrayType() && this.binding.parameters == NoParameters && scope.compilerOptions().complianceLevel >= 0x310000L && CharOperation.equals(this.binding.selector, CLONE)) {
            this.resolvedType = this.actualReceiverType;
        } else {
            TypeBinding returnType = this.binding.returnType;
            if (returnType != null) {
                returnType = returnType.capture(scope, this.sourceEnd);
            }
            this.resolvedType = returnType;
        }
        return this.resolvedType;
    }
}

