/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search.matching;

import com.netflix.nebula.lint.jdt.core.IMember;
import com.netflix.nebula.lint.jdt.core.IMethod;
import com.netflix.nebula.lint.jdt.core.IPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.core.IType;
import com.netflix.nebula.lint.jdt.core.ITypeParameter;
import com.netflix.nebula.lint.jdt.core.Signature;
import com.netflix.nebula.lint.jdt.core.search.IJavaSearchScope;
import com.netflix.nebula.lint.jdt.core.search.SearchParticipant;
import com.netflix.nebula.lint.jdt.internal.compiler.env.AccessRuleSet;
import com.netflix.nebula.lint.jdt.internal.core.index.Index;
import com.netflix.nebula.lint.jdt.internal.core.search.IndexQueryRequestor;
import com.netflix.nebula.lint.jdt.internal.core.search.JavaSearchScope;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.IIndexConstants;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.JavaSearchPattern;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class TypeParameterPattern
extends JavaSearchPattern
implements IIndexConstants {
    protected boolean findDeclarations;
    protected boolean findReferences;
    protected char[] name;
    protected ITypeParameter typeParameter;
    protected char[] declaringMemberName;
    protected char[] methodDeclaringClassName;
    protected char[][] methodArgumentTypes;

    public TypeParameterPattern(boolean findDeclarations, boolean findReferences, ITypeParameter typeParameter, int matchRule) {
        super(1024, matchRule);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        this.typeParameter = typeParameter;
        this.name = typeParameter.getElementName().toCharArray();
        IMember member = typeParameter.getDeclaringMember();
        this.declaringMemberName = member.getElementName().toCharArray();
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            this.methodDeclaringClassName = method.getParent().getElementName().toCharArray();
            String[] parameters = method.getParameterTypes();
            int length = parameters.length;
            this.methodArgumentTypes = new char[length][];
            int i = 0;
            while (i < length) {
                this.methodArgumentTypes[i] = Signature.toCharArray(parameters[i].toCharArray());
                ++i;
            }
        }
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        JavaSearchScope javaSearchScope;
        AccessRuleSet access;
        String documentPath;
        String relativePath;
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.typeParameter.getAncestor(3);
        if (root.isArchive()) {
            IType type = (IType)this.typeParameter.getAncestor(7);
            relativePath = String.valueOf(type.getFullyQualifiedName('/').replace('.', '/')) + ".class";
            documentPath = root.getPath() + "|" + relativePath;
        } else {
            IPath path = this.typeParameter.getPath();
            documentPath = path.toString();
            relativePath = Util.relativePath(path, 1);
        }
        if (scope instanceof JavaSearchScope ? (access = (javaSearchScope = (JavaSearchScope)scope).getAccessRuleSet(relativePath, index.containerPath)) != JavaSearchScope.NOT_ENCLOSED && !requestor.acceptIndexMatch(documentPath, this, participant, access) : scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, this, participant, null)) {
            throw new OperationCanceledException();
        }
    }

    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "TypeParamCombinedPattern: " : "TypeParamDeclarationPattern: ");
        } else {
            output.append("TypeParamReferencePattern: ");
        }
        output.append(this.typeParameter.toString());
        return super.print(output);
    }
}

