/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search;

import com.netflix.nebula.lint.jdt.core.search.IJavaSearchScope;
import com.netflix.nebula.lint.jdt.core.search.SearchParticipant;
import com.netflix.nebula.lint.jdt.core.search.SearchPattern;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.index.Index;
import com.netflix.nebula.lint.jdt.internal.core.search.IndexQueryRequestor;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.IndexManager;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.ReadWriteMonitor;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.MatchLocator;
import com.netflix.nebula.lint.jdt.internal.core.search.processing.IJob;
import com.netflix.nebula.lint.jdt.internal.core.search.processing.JobManager;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import java.io.EOFException;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class PatternSearchJob
implements IJob {
    protected SearchPattern pattern;
    protected IJavaSearchScope scope;
    protected SearchParticipant participant;
    protected IndexQueryRequestor requestor;
    protected boolean areIndexesReady;
    protected long executionTime = 0L;

    public PatternSearchJob(SearchPattern pattern, SearchParticipant participant, IJavaSearchScope scope, IndexQueryRequestor requestor) {
        this.pattern = pattern;
        this.participant = participant;
        this.scope = scope;
        this.requestor = requestor;
    }

    public boolean belongsTo(String jobFamily) {
        return true;
    }

    public void cancel() {
    }

    public void ensureReadyToRun() {
        if (!this.areIndexesReady) {
            this.getIndexes(null);
        }
    }

    public boolean execute(IProgressMonitor progressMonitor) {
        boolean bl;
        block8: {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            boolean isComplete = true;
            this.executionTime = 0L;
            Index[] indexes = this.getIndexes(progressMonitor);
            try {
                int max = indexes.length;
                if (progressMonitor != null) {
                    progressMonitor.beginTask("", max);
                }
                int i = 0;
                while (i < max) {
                    isComplete &= this.search(indexes[i], progressMonitor);
                    if (progressMonitor != null) {
                        if (progressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        progressMonitor.worked(1);
                    }
                    ++i;
                }
                if (JobManager.VERBOSE) {
                    Util.verbose("-> execution time: " + this.executionTime + "ms - " + this);
                }
                bl = isComplete;
                Object var6_7 = null;
                if (progressMonitor == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_8 = null;
                    if (progressMonitor == null) break block9;
                    progressMonitor.done();
                }
                throw throwable;
            }
            progressMonitor.done();
        }
        return bl;
    }

    public Index[] getIndexes(IProgressMonitor progressMonitor) {
        IPath[] indexLocations = this.participant.selectIndexes(this.pattern, this.scope);
        int length = indexLocations.length;
        Index[] indexes = new Index[length];
        int count = 0;
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        int i = 0;
        while (i < length) {
            IPath containerPath;
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            String indexLocation = indexLocations[i].toOSString();
            Index index = indexManager.getIndex(indexLocation);
            if (index == null && (containerPath = (IPath)indexManager.indexLocations.keyForValue(indexLocation)) != null) {
                index = indexManager.getIndex(containerPath, indexLocation, true, false);
            }
            if (index != null) {
                indexes[count++] = index;
            }
            ++i;
        }
        if (count == length) {
            this.areIndexesReady = true;
        } else {
            Index[] indexArray = indexes;
            indexes = new Index[count];
            System.arraycopy(indexArray, 0, indexes, 0, count);
        }
        return indexes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean search(Index index, IProgressMonitor progressMonitor) {
        if (index == null) {
            return true;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                long start = System.currentTimeMillis();
                MatchLocator.findIndexMatches(this.pattern, index, this.requestor, this.participant, this.scope, progressMonitor);
                this.executionTime += System.currentTimeMillis() - start;
                Object var6_6 = null;
                monitor.exitRead();
                return true;
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    e.printStackTrace();
                }
                Object var6_7 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.exitRead();
            throw throwable;
        }
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }
}

