/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.classfmt;

import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Annotation;
import com.netflix.nebula.lint.jdt.internal.compiler.classfmt.ClassFileStruct;
import com.netflix.nebula.lint.jdt.internal.compiler.classfmt.ClassFormatException;
import com.netflix.nebula.lint.jdt.internal.compiler.classfmt.FieldInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.classfmt.InnerClassInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.classfmt.MethodInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.AttributeNamesConstants;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.ConstantPool;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryField;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryMethod;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryNestedType;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryType;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.Constant;
import com.netflix.nebula.lint.jdt.internal.compiler.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassFileReader
extends ClassFileStruct
implements AttributeNamesConstants,
IBinaryType {
    private int accessFlags;
    private char[] classFileName;
    private char[] className;
    private int classNameIndex;
    private int constantPoolCount;
    private int[] constantPoolOffsets;
    private FieldInfo[] fields;
    private int fieldsCount;
    private InnerClassInfo innerInfo;
    private int innerInfoIndex;
    private InnerClassInfo[] innerInfos;
    private char[][] interfaceNames;
    private int interfacesCount;
    private MethodInfo[] methods;
    private int methodsCount;
    private char[] signature;
    private char[] sourceFileName;
    private char[] superclassName;
    private long tagBits;
    private long version;

    public static ClassFileReader read(File file) throws ClassFormatException, IOException {
        return ClassFileReader.read(file, false);
    }

    public static ClassFileReader read(File file, boolean fullyInitialize) throws ClassFormatException, IOException {
        byte[] classFileBytes = Util.getFileByteContent(file);
        ClassFileReader classFileReader = new ClassFileReader(classFileBytes, file.getAbsolutePath().toCharArray());
        if (fullyInitialize) {
            classFileReader.initialize();
        }
        return classFileReader;
    }

    public static ClassFileReader read(ZipFile zip, String filename) throws ClassFormatException, IOException {
        return ClassFileReader.read(zip, filename, false);
    }

    public static ClassFileReader read(ZipFile zip, String filename, boolean fullyInitialize) throws ClassFormatException, IOException {
        ZipEntry ze = zip.getEntry(filename);
        if (ze == null) {
            return null;
        }
        byte[] classFileBytes = Util.getZipEntryByteContent(ze, zip);
        ClassFileReader classFileReader = new ClassFileReader(classFileBytes, filename.toCharArray());
        if (fullyInitialize) {
            classFileReader.initialize();
        }
        return classFileReader;
    }

    public static ClassFileReader read(String fileName) throws ClassFormatException, IOException {
        return ClassFileReader.read(fileName, false);
    }

    public static ClassFileReader read(String fileName, boolean fullyInitialize) throws ClassFormatException, IOException {
        return ClassFileReader.read(new File(fileName), fullyInitialize);
    }

    public ClassFileReader(byte[] classFileBytes, char[] fileName) throws ClassFormatException {
        this(classFileBytes, fileName, false);
    }

    public ClassFileReader(byte[] classFileBytes, char[] fileName, boolean fullyInitialize) throws ClassFormatException {
        super(classFileBytes, 0);
        this.classFileName = fileName;
        int readOffset = 10;
        try {
            int i;
            this.version = ((long)this.u2At(6) << 16) + (long)this.u2At(4);
            this.constantPoolCount = this.u2At(8);
            this.constantPoolOffsets = new int[this.constantPoolCount];
            int i2 = 1;
            while (i2 < this.constantPoolCount) {
                int tag = this.u1At(readOffset);
                switch (tag) {
                    case 1: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += this.u2At(readOffset + 1);
                        readOffset += 3;
                        break;
                    }
                    case 3: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += 5;
                        break;
                    }
                    case 4: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += 5;
                        break;
                    }
                    case 5: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += 9;
                        ++i2;
                        break;
                    }
                    case 6: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += 9;
                        ++i2;
                        break;
                    }
                    case 7: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += 3;
                        break;
                    }
                    case 8: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += 3;
                        break;
                    }
                    case 9: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += 5;
                        break;
                    }
                    case 10: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += 5;
                        break;
                    }
                    case 11: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += 5;
                        break;
                    }
                    case 12: {
                        this.constantPoolOffsets[i2] = readOffset;
                        readOffset += 5;
                    }
                }
                ++i2;
            }
            this.accessFlags = this.u2At(readOffset);
            this.classNameIndex = this.u2At(readOffset += 2);
            this.className = this.getConstantClassNameAt(this.classNameIndex);
            int superclassNameIndex = this.u2At(readOffset += 2);
            readOffset += 2;
            if (superclassNameIndex != 0) {
                this.superclassName = this.getConstantClassNameAt(superclassNameIndex);
            }
            this.interfacesCount = this.u2At(readOffset);
            readOffset += 2;
            if (this.interfacesCount != 0) {
                this.interfaceNames = new char[this.interfacesCount][];
                int i3 = 0;
                while (i3 < this.interfacesCount) {
                    this.interfaceNames[i3] = this.getConstantClassNameAt(this.u2At(readOffset));
                    readOffset += 2;
                    ++i3;
                }
            }
            this.fieldsCount = this.u2At(readOffset);
            readOffset += 2;
            if (this.fieldsCount != 0) {
                this.fields = new FieldInfo[this.fieldsCount];
                i = 0;
                while (i < this.fieldsCount) {
                    FieldInfo field;
                    this.fields[i] = field = new FieldInfo(this.reference, this.constantPoolOffsets, readOffset);
                    readOffset += field.sizeInBytes();
                    ++i;
                }
            }
            this.methodsCount = this.u2At(readOffset);
            readOffset += 2;
            if (this.methodsCount != 0) {
                this.methods = new MethodInfo[this.methodsCount];
                i = 0;
                while (i < this.methodsCount) {
                    MethodInfo method;
                    this.methods[i] = method = new MethodInfo(this.reference, this.constantPoolOffsets, readOffset);
                    readOffset += method.sizeInBytes();
                    ++i;
                }
            }
            int attributesCount = this.u2At(readOffset);
            readOffset += 2;
            i = 0;
            while (i < attributesCount) {
                int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)];
                char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
                if (attributeName.length == 0) {
                    readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
                } else {
                    switch (attributeName[0]) {
                        case 'D': {
                            if (!CharOperation.equals(attributeName, DeprecatedName)) break;
                            this.accessFlags |= 0x100000;
                            break;
                        }
                        case 'I': {
                            int innerOffset;
                            int number_of_classes;
                            if (!CharOperation.equals(attributeName, InnerClassName) || (number_of_classes = this.u2At(innerOffset = readOffset + 6)) == 0) break;
                            innerOffset += 2;
                            this.innerInfos = new InnerClassInfo[number_of_classes];
                            int j = 0;
                            while (j < number_of_classes) {
                                this.innerInfos[j] = new InnerClassInfo(this.reference, this.constantPoolOffsets, innerOffset);
                                if (this.classNameIndex == this.innerInfos[j].innerClassNameIndex) {
                                    this.innerInfo = this.innerInfos[j];
                                    this.innerInfoIndex = j;
                                }
                                innerOffset += 8;
                                ++j;
                            }
                            break;
                        }
                        case 'S': {
                            if (attributeName.length <= 2) break;
                            switch (attributeName[1]) {
                                case 'o': {
                                    if (!CharOperation.equals(attributeName, SourceName)) break;
                                    utf8Offset = this.constantPoolOffsets[this.u2At(readOffset + 6)];
                                    this.sourceFileName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
                                    break;
                                }
                                case 'y': {
                                    if (!CharOperation.equals(attributeName, SyntheticName)) break;
                                    this.accessFlags |= 0x1000;
                                    break;
                                }
                                case 'i': {
                                    if (!CharOperation.equals(attributeName, SignatureName)) break;
                                    utf8Offset = this.constantPoolOffsets[this.u2At(readOffset + 6)];
                                    this.signature = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
                                }
                            }
                            break;
                        }
                        case 'R': {
                            if (!CharOperation.equals(attributeName, RuntimeVisibleAnnotationsName)) break;
                            this.decodeStandardAnnotations(readOffset);
                        }
                    }
                    readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
                }
                ++i;
            }
            if (fullyInitialize) {
                this.initialize();
            }
        }
        catch (ClassFormatException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new ClassFormatException(21, readOffset);
        }
    }

    public int accessFlags() {
        return this.accessFlags;
    }

    private int decodeAnnotation(int offset) {
        int readOffset = offset;
        int utf8Offset = this.constantPoolOffsets[this.u2At(offset)];
        char[] typeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        int numberOfPairs = this.u2At(offset + 2);
        readOffset += 4;
        switch (typeName.length) {
            case 21: {
                if (!CharOperation.equals(typeName, ConstantPool.JAVA_LANG_ANNOTATION_INHERITED)) break;
                this.tagBits |= 0x800000000000L;
                return readOffset;
            }
            case 22: {
                if (!CharOperation.equals(typeName, ConstantPool.JAVA_LANG_DEPRECATED)) break;
                this.tagBits |= 0x200000000000L;
                return readOffset;
            }
            case 29: {
                if (!CharOperation.equals(typeName, ConstantPool.JAVA_LANG_ANNOTATION_TARGET)) break;
                int i = 0;
                while (i < numberOfPairs) {
                    readOffset += 2;
                    readOffset = this.decodeElementValueForJavaLangAnnotationTarget(readOffset);
                    ++i;
                }
                return readOffset;
            }
            case 33: {
                if (!CharOperation.equals(typeName, ConstantPool.JAVA_LANG_ANNOTATION_DOCUMENTED)) break;
                this.tagBits |= 0x400000000000L;
                return readOffset;
            }
            case 32: {
                if (!CharOperation.equals(typeName, ConstantPool.JAVA_LANG_ANNOTATION_RETENTION)) break;
                int i = 0;
                while (i < numberOfPairs) {
                    readOffset += 2;
                    readOffset = this.decodeElementValueForJavaLangAnnotationRetention(readOffset);
                    ++i;
                }
                return readOffset;
            }
        }
        int i = 0;
        while (i < numberOfPairs) {
            readOffset += 2;
            readOffset = this.decodeElementValue(readOffset);
            ++i;
        }
        return readOffset;
    }

    private int decodeElementValue(int offset) {
        int readOffset = offset;
        int tag = this.u1At(readOffset);
        ++readOffset;
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                readOffset += 2;
                break;
            }
            case 101: {
                readOffset += 4;
                break;
            }
            case 99: {
                readOffset += 2;
                break;
            }
            case 64: {
                readOffset = this.decodeAnnotation(readOffset);
                break;
            }
            case 91: {
                int numberOfValues = this.u2At(readOffset);
                readOffset += 2;
                int i = 0;
                while (i < numberOfValues) {
                    readOffset = this.decodeElementValue(readOffset);
                    ++i;
                }
                break;
            }
        }
        return readOffset;
    }

    private int decodeElementValueForJavaLangAnnotationTarget(int offset) {
        int readOffset = offset;
        int tag = this.u1At(readOffset);
        ++readOffset;
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                readOffset += 2;
                break;
            }
            case 101: {
                int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)];
                char[] typeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
                utf8Offset = this.constantPoolOffsets[this.u2At(readOffset += 2)];
                char[] constName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
                readOffset += 2;
                if (typeName.length != 34 || !CharOperation.equals(typeName, ConstantPool.JAVA_LANG_ANNOTATION_ELEMENTTYPE)) break;
                this.tagBits |= Annotation.getTargetElementType(constName);
                break;
            }
            case 99: {
                readOffset += 2;
                break;
            }
            case 64: {
                readOffset = this.decodeAnnotation(readOffset);
                break;
            }
            case 91: {
                int numberOfValues = this.u2At(readOffset);
                readOffset += 2;
                if (numberOfValues == 0) {
                    this.tagBits |= 0x400000000L;
                    break;
                }
                int i = 0;
                while (i < numberOfValues) {
                    readOffset = this.decodeElementValueForJavaLangAnnotationTarget(readOffset);
                    ++i;
                }
                break;
            }
        }
        return readOffset;
    }

    private int decodeElementValueForJavaLangAnnotationRetention(int offset) {
        int readOffset = offset;
        int tag = this.u1At(readOffset);
        ++readOffset;
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                readOffset += 2;
                break;
            }
            case 101: {
                int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)];
                char[] typeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
                utf8Offset = this.constantPoolOffsets[this.u2At(readOffset += 2)];
                char[] constName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
                readOffset += 2;
                this.tagBits |= Annotation.getRetentionPolicy(constName);
                if (typeName.length != 38 || !CharOperation.equals(typeName, ConstantPool.JAVA_LANG_ANNOTATION_RETENTIONPOLICY)) break;
                this.tagBits |= Annotation.getRetentionPolicy(constName);
                break;
            }
            case 99: {
                readOffset += 2;
                break;
            }
            case 64: {
                readOffset = this.decodeAnnotation(readOffset);
                break;
            }
            case 91: {
                int numberOfValues = this.u2At(readOffset);
                readOffset += 2;
                int i = 0;
                while (i < numberOfValues) {
                    readOffset = this.decodeElementValue(readOffset);
                    ++i;
                }
                break;
            }
        }
        return readOffset;
    }

    private void decodeStandardAnnotations(int offset) {
        int numberOfAnnotations = this.u2At(offset + 6);
        int readOffset = offset + 8;
        int i = 0;
        while (i < numberOfAnnotations) {
            readOffset = this.decodeAnnotation(readOffset);
            ++i;
        }
    }

    private char[] getConstantClassNameAt(int constantPoolIndex) {
        int utf8Offset = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[constantPoolIndex] + 1)];
        return this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
    }

    public int[] getConstantPoolOffsets() {
        return this.constantPoolOffsets;
    }

    public char[] getEnclosingTypeName() {
        if (this.innerInfo != null && !this.isAnonymous()) {
            return this.innerInfo.getEnclosingTypeName();
        }
        return null;
    }

    public IBinaryField[] getFields() {
        return this.fields;
    }

    public char[] getFileName() {
        return this.classFileName;
    }

    public char[] getGenericSignature() {
        return this.signature;
    }

    public char[] getInnerSourceName() {
        if (this.innerInfo != null) {
            return this.innerInfo.getSourceName();
        }
        return null;
    }

    public char[][] getInterfaceNames() {
        return this.interfaceNames;
    }

    public int getKind() {
        switch (this.getModifiers() & 0x6200) {
            case 512: {
                return 2;
            }
            case 8704: {
                return 4;
            }
            case 16384: {
                return 3;
            }
        }
        return 1;
    }

    public IBinaryNestedType[] getMemberTypes() {
        int startingIndex;
        if (this.innerInfos == null) {
            return null;
        }
        int length = this.innerInfos.length;
        int n = startingIndex = this.innerInfo != null ? this.innerInfoIndex + 1 : 0;
        if (length != startingIndex) {
            IBinaryNestedType[] memberTypes = new IBinaryNestedType[length - this.innerInfoIndex];
            int memberTypeIndex = 0;
            int i = startingIndex;
            while (i < length) {
                InnerClassInfo currentInnerInfo = this.innerInfos[i];
                int outerClassNameIdx = currentInnerInfo.outerClassNameIndex;
                int innerNameIndex = currentInnerInfo.innerNameIndex;
                if (outerClassNameIdx != 0 && innerNameIndex != 0 && outerClassNameIdx == this.classNameIndex && currentInnerInfo.getSourceName().length != 0) {
                    memberTypes[memberTypeIndex++] = currentInnerInfo;
                }
                ++i;
            }
            if (memberTypeIndex == 0) {
                return null;
            }
            if (memberTypeIndex != memberTypes.length) {
                IBinaryNestedType[] iBinaryNestedTypeArray = memberTypes;
                memberTypes = new IBinaryNestedType[memberTypeIndex];
                System.arraycopy(iBinaryNestedTypeArray, 0, memberTypes, 0, memberTypeIndex);
            }
            return memberTypes;
        }
        return null;
    }

    public IBinaryMethod[] getMethods() {
        return this.methods;
    }

    public int getModifiers() {
        if (this.innerInfo != null) {
            return this.innerInfo.getModifiers() | this.accessFlags & 0x100000;
        }
        return this.accessFlags;
    }

    public char[] getName() {
        return this.className;
    }

    public char[] getSuperclassName() {
        return this.superclassName;
    }

    public long getTagBits() {
        return this.tagBits;
    }

    public long getVersion() {
        return this.version;
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasNonSyntheticFieldChanges(FieldInfo[] currentFieldInfos, FieldInfo[] otherFieldInfos) {
        length1 = currentFieldInfos == null ? 0 : currentFieldInfos.length;
        length2 = otherFieldInfos == null ? 0 : otherFieldInfos.length;
        index1 = 0;
        index2 = 0;
        ** GOTO lbl13
        block0: while (++index1 < length1) {
            while (!currentFieldInfos[index1].isSynthetic()) {
                while (otherFieldInfos[index2].isSynthetic()) {
                    if (++index2 >= length2) break block0;
                }
                if (this.hasStructuralFieldChanges(currentFieldInfos[index1++], otherFieldInfos[index2++])) {
                    return true;
                }
lbl13:
                // 3 sources

                if (index1 < length1 && index2 < length2) continue;
            }
        }
        while (index1 < length1) {
            if (currentFieldInfos[index1++].isSynthetic()) continue;
            return true;
        }
        while (index2 < length2) {
            if (otherFieldInfos[index2++].isSynthetic()) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasNonSyntheticMethodChanges(MethodInfo[] currentMethodInfos, MethodInfo[] otherMethodInfos) {
        length1 = currentMethodInfos == null ? 0 : currentMethodInfos.length;
        length2 = otherMethodInfos == null ? 0 : otherMethodInfos.length;
        index1 = 0;
        index2 = 0;
        ** GOTO lbl13
        block0: while (++index1 < length1) {
            while (!(m = currentMethodInfos[index1]).isSynthetic() && !m.isClinit()) {
                while ((m = otherMethodInfos[index2]).isSynthetic() || m.isClinit()) {
                    if (++index2 >= length2) break block0;
                }
                if (this.hasStructuralMethodChanges(currentMethodInfos[index1++], otherMethodInfos[index2++])) {
                    return true;
                }
lbl13:
                // 3 sources

                if (index1 < length1 && index2 < length2) continue;
            }
        }
        while (index1 < length1) {
            if ((m = currentMethodInfos[index1++]).isSynthetic() || m.isClinit()) continue;
            return true;
        }
        while (index2 < length2) {
            if ((m = otherMethodInfos[index2++]).isSynthetic() || m.isClinit()) continue;
            return true;
        }
        return false;
    }

    public boolean hasStructuralChanges(byte[] newBytes) {
        return this.hasStructuralChanges(newBytes, true, true);
    }

    public boolean hasStructuralChanges(byte[] newBytes, boolean orderRequired, boolean excludesSynthetic) {
        try {
            int i;
            Object[] otherMethodInfos;
            int i2;
            Object[] otherFieldInfos;
            IBinaryNestedType[] otherMemberTypes;
            IBinaryNestedType[] currentMemberTypes;
            ClassFileReader newClassFile = new ClassFileReader(newBytes, this.classFileName);
            if (this.getModifiers() != newClassFile.getModifiers()) {
                return true;
            }
            if ((this.getTagBits() & 0x7FC00000000L | 0x200000000000L | 0x180000000000L) != (newClassFile.getTagBits() & 0x7FC00000000L | 0x200000000000L | 0x180000000000L)) {
                return true;
            }
            if (!CharOperation.equals(this.getGenericSignature(), newClassFile.getGenericSignature())) {
                return true;
            }
            if (!CharOperation.equals(this.getSuperclassName(), newClassFile.getSuperclassName())) {
                return true;
            }
            char[][] newInterfacesNames = newClassFile.getInterfaceNames();
            if (this.interfaceNames != newInterfacesNames) {
                int newInterfacesLength;
                int n = newInterfacesLength = newInterfacesNames == null ? 0 : newInterfacesNames.length;
                if (newInterfacesLength != this.interfacesCount) {
                    return true;
                }
                int i3 = 0;
                int max = this.interfacesCount;
                while (i3 < max) {
                    if (!CharOperation.equals(this.interfaceNames[i3], newInterfacesNames[i3])) {
                        return true;
                    }
                    ++i3;
                }
            }
            if ((currentMemberTypes = this.getMemberTypes()) != (otherMemberTypes = newClassFile.getMemberTypes())) {
                int otherMemberTypeLength;
                int currentMemberTypeLength = currentMemberTypes == null ? 0 : currentMemberTypes.length;
                int n = otherMemberTypeLength = otherMemberTypes == null ? 0 : otherMemberTypes.length;
                if (currentMemberTypeLength != otherMemberTypeLength) {
                    return true;
                }
                int i4 = 0;
                while (i4 < currentMemberTypeLength) {
                    if (!CharOperation.equals(currentMemberTypes[i4].getName(), otherMemberTypes[i4].getName()) || currentMemberTypes[i4].getModifiers() != otherMemberTypes[i4].getModifiers()) {
                        return true;
                    }
                    ++i4;
                }
            }
            int otherFieldInfosLength = (otherFieldInfos = (FieldInfo[])newClassFile.getFields()) == null ? 0 : otherFieldInfos.length;
            boolean compareFields = true;
            if (this.fieldsCount == otherFieldInfosLength) {
                i2 = 0;
                while (i2 < this.fieldsCount) {
                    if (this.hasStructuralFieldChanges(this.fields[i2], otherFieldInfos[i2])) break;
                    ++i2;
                }
                if ((compareFields = i2 != this.fieldsCount) && !orderRequired && !excludesSynthetic) {
                    return true;
                }
            }
            if (compareFields) {
                if (this.fieldsCount != otherFieldInfosLength && !excludesSynthetic) {
                    return true;
                }
                if (orderRequired) {
                    if (this.fieldsCount != 0) {
                        Arrays.sort(this.fields);
                    }
                    if (otherFieldInfosLength != 0) {
                        Arrays.sort(otherFieldInfos);
                    }
                }
                if (excludesSynthetic) {
                    if (this.hasNonSyntheticFieldChanges(this.fields, (FieldInfo[])otherFieldInfos)) {
                        return true;
                    }
                } else {
                    i2 = 0;
                    while (i2 < this.fieldsCount) {
                        if (this.hasStructuralFieldChanges(this.fields[i2], (FieldInfo)otherFieldInfos[i2])) {
                            return true;
                        }
                        ++i2;
                    }
                }
            }
            int otherMethodInfosLength = (otherMethodInfos = (MethodInfo[])newClassFile.getMethods()) == null ? 0 : otherMethodInfos.length;
            boolean compareMethods = true;
            if (this.methodsCount == otherMethodInfosLength) {
                i = 0;
                while (i < this.methodsCount) {
                    if (this.hasStructuralMethodChanges(this.methods[i], otherMethodInfos[i])) break;
                    ++i;
                }
                if ((compareMethods = i != this.methodsCount) && !orderRequired && !excludesSynthetic) {
                    return true;
                }
            }
            if (compareMethods) {
                if (this.methodsCount != otherMethodInfosLength && !excludesSynthetic) {
                    return true;
                }
                if (orderRequired) {
                    if (this.methodsCount != 0) {
                        Arrays.sort(this.methods);
                    }
                    if (otherMethodInfosLength != 0) {
                        Arrays.sort(otherMethodInfos);
                    }
                }
                if (excludesSynthetic) {
                    if (this.hasNonSyntheticMethodChanges(this.methods, (MethodInfo[])otherMethodInfos)) {
                        return true;
                    }
                } else {
                    i = 0;
                    while (i < this.methodsCount) {
                        if (this.hasStructuralMethodChanges(this.methods[i], (MethodInfo)otherMethodInfos[i])) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            return false;
        }
        catch (ClassFormatException classFormatException) {
            return true;
        }
    }

    private boolean hasStructuralFieldChanges(FieldInfo currentFieldInfo, FieldInfo otherFieldInfo) {
        if (!CharOperation.equals(currentFieldInfo.getGenericSignature(), otherFieldInfo.getGenericSignature())) {
            return true;
        }
        if (currentFieldInfo.getModifiers() != otherFieldInfo.getModifiers()) {
            return true;
        }
        if ((currentFieldInfo.getTagBits() & 0x200000000000L) != (otherFieldInfo.getTagBits() & 0x200000000000L)) {
            return true;
        }
        if (!CharOperation.equals(currentFieldInfo.getName(), otherFieldInfo.getName())) {
            return true;
        }
        if (!CharOperation.equals(currentFieldInfo.getTypeName(), otherFieldInfo.getTypeName())) {
            return true;
        }
        if (currentFieldInfo.hasConstant() != otherFieldInfo.hasConstant()) {
            return true;
        }
        if (currentFieldInfo.hasConstant()) {
            Constant currentConstant = currentFieldInfo.getConstant();
            Constant otherConstant = otherFieldInfo.getConstant();
            if (currentConstant.typeID() != otherConstant.typeID()) {
                return true;
            }
            if (!currentConstant.getClass().equals(otherConstant.getClass())) {
                return true;
            }
            switch (currentConstant.typeID()) {
                case 10: {
                    return currentConstant.intValue() != otherConstant.intValue();
                }
                case 3: {
                    return currentConstant.byteValue() != otherConstant.byteValue();
                }
                case 4: {
                    return currentConstant.shortValue() != otherConstant.shortValue();
                }
                case 2: {
                    return currentConstant.charValue() != otherConstant.charValue();
                }
                case 7: {
                    return currentConstant.longValue() != otherConstant.longValue();
                }
                case 9: {
                    return currentConstant.floatValue() != otherConstant.floatValue();
                }
                case 8: {
                    return currentConstant.doubleValue() != otherConstant.doubleValue();
                }
                case 5: {
                    return currentConstant.booleanValue() != otherConstant.booleanValue();
                }
                case 11: {
                    return !currentConstant.stringValue().equals(otherConstant.stringValue());
                }
            }
        }
        return false;
    }

    private boolean hasStructuralMethodChanges(MethodInfo currentMethodInfo, MethodInfo otherMethodInfo) {
        char[][] otherThrownExceptions;
        if (!CharOperation.equals(currentMethodInfo.getGenericSignature(), otherMethodInfo.getGenericSignature())) {
            return true;
        }
        if (currentMethodInfo.getModifiers() != otherMethodInfo.getModifiers()) {
            return true;
        }
        if ((currentMethodInfo.getTagBits() & 0x200000000000L) != (otherMethodInfo.getTagBits() & 0x200000000000L)) {
            return true;
        }
        if (!CharOperation.equals(currentMethodInfo.getSelector(), otherMethodInfo.getSelector())) {
            return true;
        }
        if (!CharOperation.equals(currentMethodInfo.getMethodDescriptor(), otherMethodInfo.getMethodDescriptor())) {
            return true;
        }
        if (!CharOperation.equals(currentMethodInfo.getGenericSignature(), otherMethodInfo.getGenericSignature())) {
            return true;
        }
        char[][] currentThrownExceptions = currentMethodInfo.getExceptionTypeNames();
        if (currentThrownExceptions != (otherThrownExceptions = otherMethodInfo.getExceptionTypeNames())) {
            int otherThrownExceptionsLength;
            int currentThrownExceptionsLength = currentThrownExceptions == null ? 0 : currentThrownExceptions.length;
            int n = otherThrownExceptionsLength = otherThrownExceptions == null ? 0 : otherThrownExceptions.length;
            if (currentThrownExceptionsLength != otherThrownExceptionsLength) {
                return true;
            }
            int k = 0;
            while (k < currentThrownExceptionsLength) {
                if (!CharOperation.equals(currentThrownExceptions[k], otherThrownExceptions[k])) {
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    private void initialize() throws ClassFormatException {
        try {
            int i = 0;
            int max = this.fieldsCount;
            while (i < max) {
                this.fields[i].initialize();
                ++i;
            }
            i = 0;
            max = this.methodsCount;
            while (i < max) {
                this.methods[i].initialize();
                ++i;
            }
            if (this.innerInfos != null) {
                i = 0;
                max = this.innerInfos.length;
                while (i < max) {
                    this.innerInfos[i].initialize();
                    ++i;
                }
            }
            this.reset();
        }
        catch (RuntimeException e) {
            ClassFormatException exception = new ClassFormatException(e, this.classFileName);
            throw exception;
        }
    }

    public boolean isAnonymous() {
        if (this.innerInfo == null) {
            return false;
        }
        char[] sourceName = this.innerInfo.getSourceName();
        return sourceName == null || sourceName.length == 0;
    }

    public boolean isBinaryType() {
        return true;
    }

    public boolean isLocal() {
        if (this.innerInfo == null) {
            return false;
        }
        if (this.innerInfo.getEnclosingTypeName() != null) {
            return false;
        }
        char[] sourceName = this.innerInfo.getSourceName();
        return sourceName != null && sourceName.length > 0;
    }

    public boolean isMember() {
        if (this.innerInfo == null) {
            return false;
        }
        if (this.innerInfo.getEnclosingTypeName() == null) {
            return false;
        }
        char[] sourceName = this.innerInfo.getSourceName();
        return sourceName != null && sourceName.length > 0;
    }

    public boolean isNestedType() {
        return this.innerInfo != null;
    }

    protected void reset() {
        this.constantPoolOffsets = null;
        super.reset();
    }

    public char[] sourceFileName() {
        return this.sourceFileName;
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter print = new PrintWriter(out);
        print.println(String.valueOf(this.getClass().getName()) + "{");
        print.println(" this.className: " + new String(this.getName()));
        print.println(" this.superclassName: " + (this.getSuperclassName() == null ? "null" : new String(this.getSuperclassName())));
        print.println(" access_flags: " + ClassFileStruct.printTypeModifiers(this.accessFlags()) + "(" + this.accessFlags() + ")");
        print.flush();
        return out.toString();
    }
}

