/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.codeassist.select;

import com.netflix.nebula.lint.jdt.internal.codeassist.select.SelectionNodeFound;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.MessageSend;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;

public class SelectionOnMessageSend
extends MessageSend {
    private MethodBinding findNonDefaultAbstractMethod(MethodBinding methodBinding) {
        ReferenceBinding[] itsInterfaces = methodBinding.declaringClass.superInterfaces();
        if (itsInterfaces != NoSuperInterfaces) {
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
            int lastPosition = 0;
            interfacesToVisit[lastPosition] = itsInterfaces;
            int i = 0;
            while (i <= lastPosition) {
                ReferenceBinding[] interfaces = interfacesToVisit[i];
                int j = 0;
                int length = interfaces.length;
                while (j < length) {
                    ReferenceBinding currentType = interfaces[j];
                    if ((currentType.tagBits & 0x800L) == 0L) {
                        currentType.tagBits |= 0x800L;
                        MethodBinding[] methods = currentType.getMethods(methodBinding.selector);
                        if (methods != null) {
                            int k = 0;
                            while (k < methods.length) {
                                if (methodBinding.areParametersEqual(methods[k])) {
                                    return methods[k];
                                }
                                ++k;
                            }
                        }
                        if ((itsInterfaces = currentType.superInterfaces()) != NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return methodBinding;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("<SelectOnMessageSend:");
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, output).append('.');
        }
        output.append(this.selector).append('(');
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(")>");
    }

    public TypeBinding resolveType(BlockScope scope) {
        super.resolveType(scope);
        if (this.binding == null || !this.binding.isValidBinding() && this.binding.problemId() != 2 && this.binding.problemId() != 5 && this.binding.problemId() != 6 && this.binding.problemId() != 7) {
            throw new SelectionNodeFound();
        }
        if (this.binding.isDefaultAbstract()) {
            throw new SelectionNodeFound(this.findNonDefaultAbstractMethod(this.binding));
        }
        throw new SelectionNodeFound(this.binding);
    }
}

