/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.dependencyverifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import nebula.plugin.dependencylock.DependencyLockPlugin;
import nebula.plugin.dependencylock.utils.ConfigurationFilters;
import nebula.plugin.dependencylock.utils.CoreLocking;
import nebula.plugin.dependencyverifier.DependencyResolutionVerifier;
import nebula.plugin.dependencyverifier.DependencyResolutionVerifierExtension;
import nebula.plugin.dependencyverifier.exceptions.DependencyResolutionException;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskState;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.diagnostics.DependencyInsightReportTask;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.locking.LockOutOfDateException;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\b\f\u0018\u0000 92\u00020\u0001:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J\u001e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*H\u0002J(\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050,2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00040.H\u0002J(\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050,2\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00040.H\u0002J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050,2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\b\u00103\u001a\u00020 H\u0002J\u0010\u00104\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u00105\u001a\u00020\u001eH\u0002J\u0010\u00106\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00107\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u00108\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR#\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lnebula/plugin/dependencyverifier/DependencyResolutionVerifier;", "", "()V", "configurationsToExcludeOverride", "", "", "getConfigurationsToExcludeOverride", "()Ljava/util/Set;", "setConfigurationsToExcludeOverride", "(Ljava/util/Set;)V", "extension", "Lnebula/plugin/dependencyverifier/DependencyResolutionVerifierExtension;", "getExtension", "()Lnebula/plugin/dependencyverifier/DependencyResolutionVerifierExtension;", "setExtension", "(Lnebula/plugin/dependencyverifier/DependencyResolutionVerifierExtension;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "logger$delegate", "Lkotlin/Lazy;", "project", "Lorg/gradle/api/Project;", "getProject", "()Lorg/gradle/api/Project;", "setProject", "(Lorg/gradle/api/Project;)V", "providedErrorMessageForThisProject", "", "collectDependencyResolutionErrorsAfterBuildFailure", "", "buildResult", "Lorg/gradle/BuildResult;", "collectDependencyResolutionErrorsAfterExecute", "task", "Lorg/gradle/api/Task;", "configurationIsResolvedAndMatches", "conf", "Lorg/gradle/api/artifacts/Configuration;", "configurationsToExclude", "", "createMessagesForDepsWhereResolvedVersionIsNotTheLockedVersion", "", "depsWhereResolvedVersionIsNotTheLockedVersionByConf", "", "createMessagesForFailedDeps", "failedDepsForConfs", "createMessagesForLockedDepsOutOfDate", "lockedDepsOutOfDate", "logOrThrowOnFailedDependencies", "uniqueProjectKey", "unresolvedDependenciesShouldFailTheBuild", "validateThatResolvedVersionIsLockedVersion", "verifyResolution", "verifySuccessfulResolution", "Companion", "gradle-dependency-lock-plugin"})
public final class DependencyResolutionVerifier {
    private final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
    private boolean providedErrorMessageForThisProject;
    @NotNull
    public Project project;
    @NotNull
    public DependencyResolutionVerifierExtension extension;
    @NotNull
    public Set<String> configurationsToExcludeOverride;
    @NotNull
    private static Map<String, Map<String, Set<Configuration>>> failedDependenciesPerProjectForConfigurations;
    @NotNull
    private static Map<String, Set<String>> lockedDepsOutOfDatePerProject;
    @NotNull
    private static Map<String, Map<String, Set<Configuration>>> depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations;
    public static final Companion Companion;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        DependencyResolutionVerifier dependencyResolutionVerifier = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final DependencyResolutionVerifierExtension getExtension() {
        DependencyResolutionVerifierExtension dependencyResolutionVerifierExtension = this.extension;
        if (dependencyResolutionVerifierExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        }
        return dependencyResolutionVerifierExtension;
    }

    public final void setExtension(@NotNull DependencyResolutionVerifierExtension dependencyResolutionVerifierExtension) {
        Intrinsics.checkNotNullParameter((Object)dependencyResolutionVerifierExtension, (String)"<set-?>");
        this.extension = dependencyResolutionVerifierExtension;
    }

    @NotNull
    public final Set<String> getConfigurationsToExcludeOverride() {
        Set<String> set = this.configurationsToExcludeOverride;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationsToExcludeOverride");
        }
        return set;
    }

    public final void setConfigurationsToExcludeOverride(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.configurationsToExcludeOverride = set;
    }

    public final void verifySuccessfulResolution(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        Object object = project2.getExtensions().findByType(DependencyResolutionVerifierExtension.class);
        Intrinsics.checkNotNull((Object)object);
        this.extension = (DependencyResolutionVerifierExtension)object;
        boolean bl = false;
        this.configurationsToExcludeOverride = new LinkedHashSet();
        if (project.hasProperty("dependencyResolutionVerifier.configurationsToExclude")) {
            Set<String> set = this.configurationsToExcludeOverride;
            if (set == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configurationsToExcludeOverride");
            }
            Object object2 = project.property("dependencyResolutionVerifier.configurationsToExclude");
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            set.addAll(StringsKt.split$default((CharSequence)((String)object2), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null));
        }
        String uniqueProjectKey = this.uniqueProjectKey(project);
        boolean bl2 = false;
        failedDependenciesPerProjectForConfigurations.put(uniqueProjectKey, new LinkedHashMap());
        bl2 = false;
        lockedDepsOutOfDatePerProject.put(uniqueProjectKey, new LinkedHashSet());
        bl2 = false;
        depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations.put(uniqueProjectKey, new LinkedHashMap());
        this.verifyResolution(project);
    }

    private final void verifyResolution(Project project) {
        project.getGradle().buildFinished((Action)new Action<BuildResult>(this){
            final /* synthetic */ DependencyResolutionVerifier this$0;

            public final void execute(BuildResult buildResult) {
                boolean buildFailed;
                BuildResult buildResult2 = buildResult;
                Intrinsics.checkNotNullExpressionValue((Object)buildResult2, (String)"buildResult");
                boolean bl = buildFailed = buildResult2.getFailure() != null;
                if (buildFailed && !DependencyResolutionVerifier.access$getProvidedErrorMessageForThisProject$p(this.this$0)) {
                    DependencyResolutionVerifier.access$collectDependencyResolutionErrorsAfterBuildFailure(this.this$0, buildResult);
                }
                if (!DependencyResolutionVerifier.access$getProvidedErrorMessageForThisProject$p(this.this$0)) {
                    DependencyResolutionVerifier.access$logOrThrowOnFailedDependencies(this.this$0);
                }
            }
            {
                this.this$0 = dependencyResolutionVerifier;
            }
        });
        Gradle gradle = project.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
        gradle.getTaskGraph().whenReady((Action)new Action<TaskExecutionGraph>(this, project){
            final /* synthetic */ DependencyResolutionVerifier this$0;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public final void execute(TaskExecutionGraph taskGraph) {
                void $this$filterTo$iv$iv;
                TaskExecutionGraph taskExecutionGraph = taskGraph;
                Intrinsics.checkNotNullExpressionValue((Object)taskExecutionGraph, (String)"taskGraph");
                List list = taskExecutionGraph.getAllTasks();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"taskGraph.allTasks");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Task it = (Task)element$iv$iv;
                    boolean bl = false;
                    Task task = it;
                    Intrinsics.checkNotNullExpressionValue((Object)task, (String)"it");
                    if (!Intrinsics.areEqual((Object)task.getProject(), (Object)this.$project)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List tasks = (List)destination$iv$iv;
                if (tasks.isEmpty()) {
                    return;
                }
                taskGraph.addTaskExecutionListener(new TaskExecutionListener(this){
                    final /* synthetic */ verifyResolution.2 this$0;

                    public void beforeExecute(@NotNull Task task) {
                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    }

                    public void afterExecute(@NotNull Task task, @NotNull TaskState taskState) {
                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                        Intrinsics.checkNotNullParameter((Object)taskState, (String)"taskState");
                        if (Intrinsics.areEqual((Object)task.getProject(), (Object)this.this$0.$project) ^ true) {
                            return;
                        }
                        if (this.this$0.this$0.getExtension().getTasksToExclude().contains(task.getName())) {
                            return;
                        }
                        if (DependencyResolutionVerifier.access$getProvidedErrorMessageForThisProject$p(this.this$0.this$0)) {
                            return;
                        }
                        if (!(task instanceof DependencyReportTask || task instanceof DependencyInsightReportTask || task instanceof AbstractCompile)) {
                            return;
                        }
                        DependencyResolutionVerifier.access$collectDependencyResolutionErrorsAfterExecute(this.this$0.this$0, task);
                        DependencyResolutionVerifier.access$logOrThrowOnFailedDependencies(this.this$0.this$0);
                    }
                    {
                        this.this$0 = this$0;
                    }
                });
            }
            {
                this.this$0 = dependencyResolutionVerifier;
                this.$project = project;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void collectDependencyResolutionErrorsAfterBuildFailure(BuildResult buildResult) {
        String string;
        String buildResultFailureMessage;
        void $this$filterIsInstanceTo$iv$iv;
        Throwable failureCause;
        Throwable throwable = buildResult.getFailure();
        Throwable throwable2 = throwable != null && (throwable = throwable.getCause()) != null ? throwable.getCause() : (failureCause = null);
        if (failureCause == null || !(failureCause instanceof DefaultMultiCauseException)) {
            return;
        }
        List list = ((DefaultMultiCauseException)failureCause).getCauses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"failureCause.causes");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ModuleVersionNotFoundException)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List moduleVersionNotFoundCauses = (List)destination$iv$iv;
        if (moduleVersionNotFoundCauses.isEmpty()) {
            return;
        }
        String string2 = buildResultFailureMessage = failureCause.getMessage();
        Intrinsics.checkNotNull((Object)string2);
        List split = StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        String projectNameFromFailure = null;
        if (split.size() == 3) {
            string = (String)split.get(1);
        } else {
            Project project = this.project;
            if (project == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            Project project2 = project.getRootProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
            String string3 = project2.getName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.rootProject.name");
        }
        projectNameFromFailure = string;
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        if (Intrinsics.areEqual((Object)project.getName(), (Object)projectNameFromFailure)) {
            Object it;
            this.getLogger().debug("Starting dependency resolution verification after the build has completed: " + buildResultFailureMessage);
            Configuration conf = null;
            try {
                Object element$iv2;
                String confName;
                block16: {
                    confName = (String)StringsKt.split$default((CharSequence)StringsKt.replace$default((String)buildResultFailureMessage, (String)".", (String)"", (boolean)false, (int)4, null), (String[])new String[]{"for "}, (boolean)false, (int)0, (int)6, null).get(1);
                    Project project3 = this.project;
                    if (project3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                    }
                    ConfigurationContainer configurationContainer = project3.getConfigurations();
                    Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                    Iterable $this$first$iv = (Iterable)configurationContainer;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        it = (Configuration)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.toString(), (Object)confName)) continue;
                        break block16;
                    }
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object t = element$iv2;
                Intrinsics.checkNotNullExpressionValue(t, (String)"project.configurations.f\u2026.toString() == confName }");
                conf = (Configuration)t;
                this.getLogger().debug("Found " + conf + " from " + confName);
            }
            catch (Exception e) {
                this.getLogger().warn("Error finding configuration associated with build failure from '" + buildResultFailureMessage + '\'', (Throwable)e);
                return;
            }
            Project project4 = this.project;
            if (project4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            Map<String, Set<Configuration>> failedDepsByConf = failedDependenciesPerProjectForConfigurations.get(this.uniqueProjectKey(project4));
            Iterable $this$forEach$iv = moduleVersionNotFoundCauses;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (Throwable)element$iv2;
                boolean bl = false;
                boolean bl2 = it instanceof ModuleVersionNotFoundException;
                boolean bl3 = false;
                boolean bl4 = false;
                bl4 = false;
                boolean bl5 = false;
                if (!bl2) {
                    boolean bl6 = false;
                    String string4 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string4.toString());
                }
                String dep = ((ModuleVersionNotFoundException)it).getSelector().toString();
                Map<String, Set<Configuration>> map = failedDepsByConf;
                Intrinsics.checkNotNull(map);
                if (map.containsKey(dep)) {
                    Set<Configuration> set = failedDepsByConf.get(dep);
                    Intrinsics.checkNotNull(set);
                    set.add(conf);
                    continue;
                }
                failedDepsByConf.put(dep, SetsKt.mutableSetOf((Object[])new Configuration[]{conf}));
            }
        }
    }

    private final void collectDependencyResolutionErrorsAfterExecute(Task task) {
        Set<String> set;
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Map<String, Set<Configuration>> failedDepsByConf = failedDependenciesPerProjectForConfigurations.get(this.uniqueProjectKey(project));
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Set<String> lockedDepsOutOfDate = lockedDepsOutOfDatePerProject.get(this.uniqueProjectKey(project2));
        Set<String> set2 = this.configurationsToExcludeOverride;
        if (set2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configurationsToExcludeOverride");
        }
        Collection collection = set2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            set = this.configurationsToExcludeOverride;
            if (set == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configurationsToExcludeOverride");
            }
        } else {
            DependencyResolutionVerifierExtension dependencyResolutionVerifierExtension = this.extension;
            if (dependencyResolutionVerifierExtension == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
            }
            set = dependencyResolutionVerifierExtension.getConfigurationsToExclude();
        }
        Set<String> configurationsToExclude = set;
        Project project3 = task.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"task.project");
        project3.getConfigurations().matching((Spec)new Spec<Configuration>(this, configurationsToExclude){
            final /* synthetic */ DependencyResolutionVerifier this$0;
            final /* synthetic */ Set $configurationsToExclude;

            public final boolean isSatisfiedBy(Configuration it) {
                Configuration configuration = it;
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"it");
                Set set = this.$configurationsToExclude;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configurationsToExclude");
                return DependencyResolutionVerifier.access$configurationIsResolvedAndMatches(this.this$0, configuration, set);
            }
            {
                this.this$0 = dependencyResolutionVerifier;
                this.$configurationsToExclude = set;
            }
        }).all((Action)new Action<Configuration>(this, task, failedDepsByConf, lockedDepsOutOfDate){
            final /* synthetic */ DependencyResolutionVerifier this$0;
            final /* synthetic */ Task $task;
            final /* synthetic */ Map $failedDepsByConf;
            final /* synthetic */ Set $lockedDepsOutOfDate;

            public final void execute(Configuration conf) {
                Logger logger2 = DependencyResolutionVerifier.access$getLogger$p(this.this$0);
                StringBuilder stringBuilder = new StringBuilder().append(conf).append(" in ").append(this.this$0.getProject().getName()).append(" has state ");
                Configuration configuration = conf;
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"conf");
                logger2.debug(stringBuilder.append(configuration.getState()).append(". Starting dependency resolution verification after task '").append(this.$task.getName()).append("'.").toString());
                try {
                    ResolvedConfiguration resolvedConfiguration = conf.getResolvedConfiguration();
                    Intrinsics.checkNotNullExpressionValue((Object)resolvedConfiguration, (String)"conf.resolvedConfiguration");
                    resolvedConfiguration.getResolvedArtifacts();
                }
                catch (Exception e) {
                    Exception exception = e;
                    if (exception instanceof ResolveException) {
                        List list = ((ResolveException)((Object)e)).getCauses();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.causes");
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Throwable cause = (Throwable)element$iv;
                            boolean bl = false;
                            Throwable throwable = cause;
                            if (throwable instanceof ModuleVersionNotFoundException) {
                                String dep = ((ModuleVersionNotFoundException)cause).getSelector().toString();
                                Map map = this.$failedDepsByConf;
                                Intrinsics.checkNotNull((Object)map);
                                if (map.containsKey(dep)) {
                                    V v = this.$failedDepsByConf.get(dep);
                                    Intrinsics.checkNotNull(v);
                                    ((Set)v).add(conf);
                                    continue;
                                }
                                this.$failedDepsByConf.put(dep, SetsKt.mutableSetOf((Object[])new Configuration[]{conf}));
                                continue;
                            }
                            if (!(throwable instanceof LockOutOfDateException)) continue;
                            Set set = this.$lockedDepsOutOfDate;
                            Intrinsics.checkNotNull((Object)set);
                            set.add(String.valueOf(cause.getMessage()));
                        }
                    } else {
                        DependencyResolutionVerifier.access$getLogger$p(this.this$0).warn("Received an unhandled exception", (Object)e.getMessage());
                    }
                    return;
                }
                DependencyResolutionVerifier.access$validateThatResolvedVersionIsLockedVersion(this.this$0, conf);
            }
            {
                this.this$0 = dependencyResolutionVerifier;
                this.$task = task;
                this.$failedDepsByConf = map;
                this.$lockedDepsOutOfDate = set;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void validateThatResolvedVersionIsLockedVersion(Configuration conf) {
        void $this$mapTo$iv$iv;
        Map overrideDependencies;
        Map map;
        Object object;
        String string;
        String string2;
        DependencyLockPlugin.ModuleVersionSelectorKey it;
        Object object2;
        Object destination$iv$iv;
        boolean usesNebulaAlignment = !Boolean.getBoolean("nebula.features.coreAlignmentSupport");
        boolean usesCoreLocking = CoreLocking.isCoreLockingEnabled();
        if (usesCoreLocking || usesNebulaAlignment) {
            return;
        }
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Map<String, Set<Configuration>> depsWhereResolvedVersionIsNotTheLockedVersionByConf = depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations.get(this.uniqueProjectKey(project));
        Map<String, Map<String, List<DependencyLockPlugin.ModuleVersionSelectorKey>>> map2 = DependencyLockPlugin.Companion.getLockedDepsPerProjectForConfigurations();
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Map<String, List<DependencyLockPlugin.ModuleVersionSelectorKey>> lockedDepsByConf = map2.get(this.uniqueProjectKey(project2));
        Map<String, Map<String, List<DependencyLockPlugin.ModuleVersionSelectorKey>>> map3 = DependencyLockPlugin.Companion.getOverrideDepsPerProjectForConfigurations();
        Project project3 = this.project;
        if (project3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Map<String, List<DependencyLockPlugin.ModuleVersionSelectorKey>> overrideDepsByConf = map3.get(this.uniqueProjectKey(project3));
        Map<String, List<DependencyLockPlugin.ModuleVersionSelectorKey>> map4 = lockedDepsByConf;
        Intrinsics.checkNotNull(map4);
        List<DependencyLockPlugin.ModuleVersionSelectorKey> list = map4.get(conf.getName());
        if (list != null) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                DependencyLockPlugin.ModuleVersionSelectorKey moduleVersionSelectorKey = (DependencyLockPlugin.ModuleVersionSelectorKey)element$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                string2 = it.getGroup() + ':' + it.getName();
                it = (DependencyLockPlugin.ModuleVersionSelectorKey)element$iv$iv;
                boolean bl2 = false;
                string = String.valueOf(it.getVersion());
                object2.put(string2, string);
            }
            object = destination$iv$iv;
        } else {
            object = MapsKt.emptyMap();
        }
        Map lockedDependencies = object;
        Map<String, List<DependencyLockPlugin.ModuleVersionSelectorKey>> map5 = overrideDepsByConf;
        Intrinsics.checkNotNull(map5);
        List<DependencyLockPlugin.ModuleVersionSelectorKey> list2 = map5.get(conf.getName());
        if (list2 != null) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = list2;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                DependencyLockPlugin.ModuleVersionSelectorKey it2;
                DependencyLockPlugin.ModuleVersionSelectorKey bl2 = (DependencyLockPlugin.ModuleVersionSelectorKey)element$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl = false;
                string2 = it2.getGroup() + ':' + it2.getName();
                it2 = (DependencyLockPlugin.ModuleVersionSelectorKey)element$iv$iv;
                boolean bl3 = false;
                string = String.valueOf(it2.getVersion());
                object2.put(string2, string);
            }
            map = destination$iv$iv2;
        } else {
            map = overrideDependencies = MapsKt.emptyMap();
        }
        if (lockedDependencies.isEmpty() && overrideDependencies.isEmpty()) {
            return;
        }
        ResolvedConfiguration resolvedConfiguration = conf.getResolvedConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedConfiguration, (String)"conf.resolvedConfiguration");
        Set set = resolvedConfiguration.getResolvedArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"conf.resolvedConfiguration.resolvedArtifacts");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable capacity$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object element$iv$iv;
            element$iv$iv = (ResolvedArtifact)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl4 = false;
            DependencyLockPlugin.ModuleVersionSelectorKey moduleVersionSelectorKey = it;
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionSelectorKey, (String)"it");
            ResolvedModuleVersion resolvedModuleVersion = moduleVersionSelectorKey.getModuleVersion();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedModuleVersion, (String)"it.moduleVersion");
            string2 = resolvedModuleVersion.getId();
            object2.add(string2);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string3;
            String string4;
            String lockedVersion;
            ModuleVersionIdentifier dep = (ModuleVersionIdentifier)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            ModuleVersionIdentifier moduleVersionIdentifier = dep;
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier, (String)"dep");
            String string5 = (String)lockedDependencies.get(stringBuilder.append(moduleVersionIdentifier.getGroup()).append(':').append(dep.getName()).toString());
            if (string5 == null) {
                string5 = lockedVersion = "";
            }
            if ((string4 = (String)overrideDependencies.get(dep.getGroup() + ':' + dep.getName())) == null) {
                string4 = "";
            }
            String overrideVersion = string4;
            CharSequence bl4 = overrideVersion;
            boolean bl3 = false;
            if (bl4.length() > 0) {
                string3 = overrideVersion;
            } else {
                bl4 = lockedVersion;
                bl3 = false;
                string3 = bl4.length() > 0 ? lockedVersion : "";
            }
            String expectedVersion = string3;
            bl4 = expectedVersion;
            bl3 = false;
            if (!(bl4.length() > 0) || !(Intrinsics.areEqual((Object)expectedVersion, (Object)dep.getVersion()) ^ true)) continue;
            String depAsString = dep.getGroup() + ':' + dep.getName() + ':' + dep.getVersion();
            String key = '\'' + depAsString + "' instead of locked version '" + expectedVersion + '\'';
            Map<String, Set<Configuration>> map6 = depsWhereResolvedVersionIsNotTheLockedVersionByConf;
            Intrinsics.checkNotNull(map6);
            if (map6.containsKey(dep.toString())) {
                Set<Configuration> set2 = depsWhereResolvedVersionIsNotTheLockedVersionByConf.get(key);
                Intrinsics.checkNotNull(set2);
                set2.add(conf);
                continue;
            }
            depsWhereResolvedVersionIsNotTheLockedVersionByConf.put(key, SetsKt.mutableSetOf((Object[])new Configuration[]{conf}));
        }
    }

    private final void logOrThrowOnFailedDependencies() {
        block8: {
            Map<String, Set<Configuration>> depsWhereResolvedVersionIsNotTheLockedVersionByConf;
            Set<String> lockedDepsOutOfDate;
            Map<String, Set<Configuration>> failedDepsByConf;
            List messages;
            block7: {
                boolean bl = false;
                messages = new ArrayList();
                Project project = this.project;
                if (project == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                }
                Map<String, Set<Configuration>> map = failedDependenciesPerProjectForConfigurations.get(this.uniqueProjectKey(project));
                Intrinsics.checkNotNull(map);
                failedDepsByConf = map;
                Project project2 = this.project;
                if (project2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                }
                Set<String> set = lockedDepsOutOfDatePerProject.get(this.uniqueProjectKey(project2));
                Intrinsics.checkNotNull(set);
                lockedDepsOutOfDate = set;
                Project project3 = this.project;
                if (project3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                }
                Map<String, Set<Configuration>> map2 = depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations.get(this.uniqueProjectKey(project3));
                Intrinsics.checkNotNull(map2);
                depsWhereResolvedVersionIsNotTheLockedVersionByConf = map2;
                Map<String, Set<Configuration>> map3 = failedDepsByConf;
                boolean bl2 = false;
                if (!map3.isEmpty()) break block7;
                map3 = lockedDepsOutOfDate;
                bl2 = false;
                if (!map3.isEmpty()) break block7;
                map3 = depsWhereResolvedVersionIsNotTheLockedVersionByConf;
                bl2 = false;
                if (!(!map3.isEmpty())) break block8;
            }
            try {
                messages.addAll((Collection)this.createMessagesForFailedDeps(failedDepsByConf));
                messages.addAll((Collection)this.createMessagesForLockedDepsOutOfDate(lockedDepsOutOfDate));
                messages.addAll((Collection)this.createMessagesForDepsWhereResolvedVersionIsNotTheLockedVersion(depsWhereResolvedVersionIsNotTheLockedVersionByConf));
            }
            catch (Exception e) {
                this.getLogger().warn("Error creating message regarding failed dependencies", (Throwable)e);
                return;
            }
            this.providedErrorMessageForThisProject = true;
            if (this.unresolvedDependenciesShouldFailTheBuild()) {
                throw (Throwable)new DependencyResolutionException(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            this.getLogger().warn(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
    }

    private final List<String> createMessagesForFailedDeps(Map<String, Set<Configuration>> failedDepsForConfs) {
        boolean bl = false;
        List messages = new ArrayList();
        boolean bl2 = false;
        List depsMissingVersions = new ArrayList();
        Map<String, Set<Configuration>> map = failedDepsForConfs;
        boolean bl3 = false;
        if (!map.isEmpty()) {
            messages.add("Failed to resolve the following dependencies:");
        }
        int failureMessageCounter = 0;
        Map $this$forEach$iv = MapsKt.toSortedMap(failedDepsForConfs);
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl4 = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$dep$_u24__u24 = element$iv = iterator.next();
            boolean bl5 = false;
            Map.Entry entry = $dstr$dep$_u24__u24;
            boolean bl6 = false;
            String dep = (String)entry.getKey();
            StringBuilder stringBuilder = new StringBuilder().append("  ").append(failureMessageCounter + 1).append(". Failed to resolve '").append(dep).append("' for project '");
            Project project = this.project;
            if (project == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            messages.add(stringBuilder.append(project.getName()).append('\'').toString());
            String string = dep;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dep");
            if (StringsKt.split$default((CharSequence)string, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null).size() < 3) {
                depsMissingVersions.add(dep);
            }
            ++failureMessageCounter;
        }
        if (depsMissingVersions.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("The following dependencies are missing a version: ").append(CollectionsKt.joinToString$default((Iterable)depsMissingVersions, null, null, null, (int)0, null, null, (int)63, null)).append('\n').append("Please add a version to fix this. If you have been using a BOM, perhaps these dependencies are no longer managed. \n");
            DependencyResolutionVerifierExtension dependencyResolutionVerifierExtension = this.extension;
            if (dependencyResolutionVerifierExtension == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
            }
            messages.add(stringBuilder.append(dependencyResolutionVerifierExtension.getMissingVersionsMessageAddition()).toString());
        }
        return messages;
    }

    private final List<String> createMessagesForLockedDepsOutOfDate(Set<String> lockedDepsOutOfDate) {
        boolean bl = false;
        List messages = new ArrayList();
        Collection collection = lockedDepsOutOfDate;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            messages.add("Resolved dependencies were missing from the lock state:");
        }
        int locksOutOfDateCounter = 0;
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)lockedDepsOutOfDate);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String outOfDateMessage = (String)element$iv;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("  ").append(locksOutOfDateCounter + 1).append(". ").append(outOfDateMessage).append(" for project '");
            Project project = this.project;
            if (project == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            messages.add(stringBuilder.append(project.getName()).append('\'').toString());
            ++locksOutOfDateCounter;
        }
        return messages;
    }

    private final List<String> createMessagesForDepsWhereResolvedVersionIsNotTheLockedVersion(Map<String, Set<Configuration>> depsWhereResolvedVersionIsNotTheLockedVersionByConf) {
        boolean bl = false;
        List messages = new ArrayList();
        Map<String, Set<Configuration>> map = depsWhereResolvedVersionIsNotTheLockedVersionByConf;
        boolean bl2 = false;
        if (!map.isEmpty()) {
            messages.add("Dependency lock state is out of date:");
        }
        int failureMessageCounter = 0;
        Map $this$forEach$iv = MapsKt.toSortedMap(depsWhereResolvedVersionIsNotTheLockedVersionByConf);
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl3 = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$dep$_u24__u24 = element$iv = iterator.next();
            boolean bl4 = false;
            Map.Entry entry = $dstr$dep$_u24__u24;
            boolean bl5 = false;
            String dep = (String)entry.getKey();
            StringBuilder stringBuilder = new StringBuilder().append("  ").append(failureMessageCounter + 1).append(". Resolved ").append(dep).append(" for project '");
            Project project = this.project;
            if (project == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            messages.add(stringBuilder.append(project.getName()).append('\'').toString());
            ++failureMessageCounter;
        }
        Map<String, Set<Configuration>> map3 = depsWhereResolvedVersionIsNotTheLockedVersionByConf;
        boolean bl6 = false;
        if (!map3.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("Please update your dependency locks or your build file constraints.\n");
            DependencyResolutionVerifierExtension dependencyResolutionVerifierExtension = this.extension;
            if (dependencyResolutionVerifierExtension == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
            }
            messages.add(stringBuilder.append(dependencyResolutionVerifierExtension.getResolvedVersionDoesNotEqualLockedVersionMessageAddition()).toString());
        }
        return messages;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean configurationIsResolvedAndMatches(Configuration conf, Set<String> configurationsToExclude) {
        if (conf.getState() == Configuration.State.UNRESOLVED) return false;
        String string = conf.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"conf.name");
        if (StringsKt.startsWith$default((String)string, (String)"incrementalScala", (boolean)false, (int)2, null)) return false;
        if (configurationsToExclude.contains(conf.getName())) return false;
        if (ConfigurationFilters.safelyHasAResolutionAlternative(conf)) return false;
        return true;
    }

    private final boolean unresolvedDependenciesShouldFailTheBuild() {
        boolean bl;
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        if (project.hasProperty("dependencyResolutionVerifier.unresolvedDependenciesFailTheBuild")) {
            Project project2 = this.project;
            if (project2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            Object object = project2.property("dependencyResolutionVerifier.unresolvedDependenciesFailTheBuild");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)object;
            boolean bl2 = false;
            bl = Boolean.parseBoolean(string);
        } else {
            DependencyResolutionVerifierExtension dependencyResolutionVerifierExtension = this.extension;
            if (dependencyResolutionVerifierExtension == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
            }
            bl = dependencyResolutionVerifierExtension.getShouldFailTheBuild();
        }
        return bl;
    }

    private final String uniqueProjectKey(Project project) {
        return project.getName() + '-' + (Intrinsics.areEqual((Object)project, (Object)project.getRootProject()) ? "rootproject" : "subproject");
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        failedDependenciesPerProjectForConfigurations = new LinkedHashMap();
        bl = false;
        lockedDepsOutOfDatePerProject = new LinkedHashMap();
        bl = false;
        depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations = new LinkedHashMap();
    }

    public static final /* synthetic */ boolean access$getProvidedErrorMessageForThisProject$p(DependencyResolutionVerifier $this) {
        return $this.providedErrorMessageForThisProject;
    }

    public static final /* synthetic */ void access$setProvidedErrorMessageForThisProject$p(DependencyResolutionVerifier $this, boolean bl) {
        $this.providedErrorMessageForThisProject = bl;
    }

    public static final /* synthetic */ void access$collectDependencyResolutionErrorsAfterBuildFailure(DependencyResolutionVerifier $this, BuildResult buildResult) {
        $this.collectDependencyResolutionErrorsAfterBuildFailure(buildResult);
    }

    public static final /* synthetic */ void access$logOrThrowOnFailedDependencies(DependencyResolutionVerifier $this) {
        $this.logOrThrowOnFailedDependencies();
    }

    public static final /* synthetic */ void access$collectDependencyResolutionErrorsAfterExecute(DependencyResolutionVerifier $this, Task task) {
        $this.collectDependencyResolutionErrorsAfterExecute(task);
    }

    public static final /* synthetic */ boolean access$configurationIsResolvedAndMatches(DependencyResolutionVerifier $this, Configuration conf, Set configurationsToExclude) {
        return $this.configurationIsResolvedAndMatches(conf, configurationsToExclude);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DependencyResolutionVerifier $this) {
        return $this.getLogger();
    }

    public static final /* synthetic */ void access$validateThatResolvedVersionIsLockedVersion(DependencyResolutionVerifier $this, Configuration conf) {
        $this.validateThatResolvedVersionIsLockedVersion(conf);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R8\u0010\u0003\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR8\u0010\f\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR,\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lnebula/plugin/dependencyverifier/DependencyResolutionVerifier$Companion;", "", "()V", "depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations", "", "", "", "Lorg/gradle/api/artifacts/Configuration;", "getDepsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations", "()Ljava/util/Map;", "setDepsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations", "(Ljava/util/Map;)V", "failedDependenciesPerProjectForConfigurations", "getFailedDependenciesPerProjectForConfigurations", "setFailedDependenciesPerProjectForConfigurations", "lockedDepsOutOfDatePerProject", "getLockedDepsOutOfDatePerProject", "setLockedDepsOutOfDatePerProject", "gradle-dependency-lock-plugin"})
    public static final class Companion {
        @NotNull
        public final Map<String, Map<String, Set<Configuration>>> getFailedDependenciesPerProjectForConfigurations() {
            return failedDependenciesPerProjectForConfigurations;
        }

        public final void setFailedDependenciesPerProjectForConfigurations(@NotNull Map<String, Map<String, Set<Configuration>>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            failedDependenciesPerProjectForConfigurations = map;
        }

        @NotNull
        public final Map<String, Set<String>> getLockedDepsOutOfDatePerProject() {
            return lockedDepsOutOfDatePerProject;
        }

        public final void setLockedDepsOutOfDatePerProject(@NotNull Map<String, Set<String>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            lockedDepsOutOfDatePerProject = map;
        }

        @NotNull
        public final Map<String, Map<String, Set<Configuration>>> getDepsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations() {
            return depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations;
        }

        public final void setDepsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations(@NotNull Map<String, Map<String, Set<Configuration>>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations = map;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

