/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.netflix.governator.guice.LifecycleInjector;
import com.netflix.governator.lifecycle.LifecycleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import netflix.admin.AdminConfigImpl;
import netflix.admin.AdminContainerConfig;
import netflix.adminresources.AdminPageInfo;
import netflix.adminresources.AdminPageRegistry;
import netflix.adminresources.AdminResourcesFilter;
import netflix.adminresources.LoggingFilter;
import netflix.adminresources.RedirectFilter;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AdminResourcesContainer {
    private static final Logger logger = LoggerFactory.getLogger(AdminResourcesContainer.class);
    @Deprecated
    public static final String CONTAINER_LISTEN_PORT = "netflix.platform.admin.resources.port";
    private Server server;
    @Inject(optional=true)
    private Injector appInjector;
    @Inject(optional=true)
    private AdminContainerConfig adminContainerConfig;
    @Inject(optional=true)
    private AdminPageRegistry adminPageRegistry;
    private AtomicBoolean alreadyInited = new AtomicBoolean(false);
    private int serverPort;

    @PostConstruct
    public void init() throws Exception {
        try {
            if (this.alreadyInited.compareAndSet(false, true)) {
                Injector adminResourceInjector;
                this.initAdminContainerConfigIfNeeded();
                this.initAdminRegistryIfNeeded();
                if (!this.adminContainerConfig.shouldEnable()) {
                    return;
                }
                if (this.adminContainerConfig.shouldScanClassPathForPluginDiscovery()) {
                    this.adminPageRegistry.registerAdminPagesWithClasspathScan();
                }
                if (this.shouldShareResourcesWithParentInjector()) {
                    adminResourceInjector = this.appInjector.createChildInjector(this.buildAdminPluginsGuiceModules());
                } else {
                    adminResourceInjector = LifecycleInjector.builder().inStage(Stage.DEVELOPMENT).usingBasePackages(new String[]{"com.netflix.explorers"}).withModules(this.buildAdminPluginsGuiceModules()).build().createInjector();
                    ((LifecycleManager)adminResourceInjector.getInstance(LifecycleManager.class)).start();
                }
                this.server = new Server(this.adminContainerConfig.listenPort());
                Context rootHandler = new Context();
                rootHandler.setContextPath("/");
                rootHandler.addFilter(new FilterHolder((Filter)adminResourceInjector.getInstance(RedirectFilter.class)), "/*", 0);
                rootHandler.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
                AdminResourcesFilter arfTemplatesResources = (AdminResourcesFilter)((Object)adminResourceInjector.getInstance(AdminResourcesFilter.class));
                arfTemplatesResources.setPackages(this.adminContainerConfig.jerseyViewableResourcePkgList());
                Context adminTemplatesResHandler = new Context();
                adminTemplatesResHandler.setContextPath(this.adminContainerConfig.templateResourceContext());
                adminTemplatesResHandler.setSessionHandler(new SessionHandler());
                adminTemplatesResHandler.addFilter(LoggingFilter.class, "/*", 0);
                adminTemplatesResHandler.addFilter(new FilterHolder((Filter)adminResourceInjector.getInstance(RedirectFilter.class)), "/*", 0);
                adminTemplatesResHandler.addFilter(new FilterHolder((Filter)arfTemplatesResources), "/*", 0);
                adminTemplatesResHandler.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
                String jerseyPkgListForAjaxResources = this.appendCoreJerseyPackages(this.adminPageRegistry.buildJerseyResourcePkgListForAdminPages());
                AdminResourcesFilter arfDataResources = (AdminResourcesFilter)((Object)adminResourceInjector.getInstance(AdminResourcesFilter.class));
                arfDataResources.setPackages(jerseyPkgListForAjaxResources);
                Context adminDataResHandler = new Context();
                adminDataResHandler.setContextPath(this.adminContainerConfig.ajaxDataResourceContext());
                adminDataResHandler.addFilter(new FilterHolder((Filter)adminResourceInjector.getInstance(RedirectFilter.class)), "/*", 0);
                adminDataResHandler.addFilter(new FilterHolder((Filter)arfDataResources), "/*", 0);
                adminDataResHandler.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
                QueuedThreadPool threadPool = new QueuedThreadPool();
                threadPool.setDaemon(true);
                this.server.setThreadPool((ThreadPool)threadPool);
                HandlerCollection handlers = new HandlerCollection();
                handlers.setHandlers(new Handler[]{adminTemplatesResHandler, adminDataResHandler, rootHandler});
                this.server.setHandler((Handler)handlers);
                this.server.start();
                Connector connector = this.server.getConnectors()[0];
                this.serverPort = connector.getLocalPort();
            }
        }
        catch (Exception e) {
            logger.error("Exception in building AdminResourcesContainer ", (Throwable)e);
        }
    }

    private void initAdminContainerConfigIfNeeded() {
        if (this.adminContainerConfig == null) {
            this.adminContainerConfig = new AdminConfigImpl();
        }
    }

    private void initAdminRegistryIfNeeded() {
        if (this.adminPageRegistry == null) {
            this.adminPageRegistry = new AdminPageRegistry();
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public AdminPageRegistry getAdminPageRegistry() {
        return this.adminPageRegistry;
    }

    private Module getAdditionalBindings() {
        return new AbstractModule(){

            protected void configure() {
                this.bind(AdminResourcesFilter.class);
                if (!AdminResourcesContainer.this.shouldShareResourcesWithParentInjector()) {
                    this.bind(AdminPageRegistry.class).toInstance((Object)AdminResourcesContainer.this.adminPageRegistry);
                    this.bind(AdminContainerConfig.class).toInstance((Object)AdminResourcesContainer.this.adminContainerConfig);
                }
            }
        };
    }

    private String appendCoreJerseyPackages(String jerseyResourcePkgListForAdminPages) {
        String pkgPath = this.adminContainerConfig.jerseyResourcePkgList();
        if (jerseyResourcePkgListForAdminPages != null && !jerseyResourcePkgListForAdminPages.isEmpty()) {
            pkgPath = pkgPath + ";" + jerseyResourcePkgListForAdminPages;
        }
        return pkgPath;
    }

    private List<Module> buildAdminPluginsGuiceModules() {
        ArrayList<Module> guiceModules = new ArrayList<Module>();
        if (this.adminPageRegistry != null) {
            Collection<AdminPageInfo> allPages = this.adminPageRegistry.getAllPages();
            for (AdminPageInfo adminPlugin : allPages) {
                List<Module> guiceModuleList = adminPlugin.getGuiceModules();
                if (guiceModuleList == null || guiceModuleList.isEmpty()) continue;
                guiceModules.addAll(adminPlugin.getGuiceModules());
            }
        }
        guiceModules.add(this.getAdditionalBindings());
        return guiceModules;
    }

    private boolean shouldShareResourcesWithParentInjector() {
        return this.appInjector != null && !this.adminContainerConfig.shouldIsolateResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void shutdown() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Throwable t) {
            logger.warn("Error while shutting down Admin resources server", t);
        }
        finally {
            this.alreadyInited.set(false);
        }
    }
}

