/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.netflix.config.ConfigurationManager;
import com.netflix.governator.lifecycle.ClasspathScanner;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import netflix.adminresources.AbstractAdminPageInfo;
import netflix.adminresources.AdminPageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminPageRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(AdminPageRegistry.class);
    public static final String PROP_ID_ADMIN_PAGES_SCAN = "netflix.platform.admin.pages.packages";
    public static final String DEFAULT_SCAN_PKG = "netflix";
    public static final String PROP_ID_ADMIN_PAGE_ANNOTATION = "netflix.platform.admin.pages.annotation";
    public static final String DEFAULT_ADMIN_PAGE_ANNOTATION = "netflix.adminresources.AdminPage";
    private Map<String, AdminPageInfo> baseServerPageInfoMap = new ConcurrentHashMap<String, AdminPageInfo>();

    public void add(AdminPageInfo baseServerPageInfo) {
        Preconditions.checkNotNull((Object)baseServerPageInfo);
        this.baseServerPageInfoMap.put(baseServerPageInfo.getPageId(), baseServerPageInfo);
    }

    public void remove(AdminPageInfo baseServerPageInfo) {
        Preconditions.checkNotNull((Object)baseServerPageInfo);
        this.baseServerPageInfoMap.remove(baseServerPageInfo.getPageId());
    }

    public AdminPageInfo getPageInfo(String pageId) {
        return this.baseServerPageInfoMap.get(pageId);
    }

    public Collection<AdminPageInfo> getAllPages() {
        ArrayList pages = Lists.newArrayList(this.baseServerPageInfoMap.values());
        List<AdminPageInfo> enabledPages = this.getEnabledPages(pages);
        Collections.sort(enabledPages, new Comparator<AdminPageInfo>(){

            @Override
            public int compare(AdminPageInfo left, AdminPageInfo right) {
                String leftVal = left.getName() != null ? left.getName() : left.getPageId();
                String rightVal = right.getName() != null ? right.getName() : right.getPageId();
                return leftVal.compareToIgnoreCase(rightVal);
            }
        });
        return enabledPages;
    }

    public void registerAdminPagesWithClasspathScan() {
        List<Class<? extends Annotation>> annotationList = this.getAdminPageAnnotations();
        ClasspathScanner cs = new ClasspathScanner(this.getAdminPagesPackagesToScan(), annotationList);
        for (Class baseServerAdminPageClass : cs.getClasses()) {
            if (!this.derivedFromAbstractBaseServePageInfo(baseServerAdminPageClass) && !this.implementsAdminPageInfo(baseServerAdminPageClass)) continue;
            try {
                AdminPageInfo baseServerPageInfo = (AdminPageInfo)baseServerAdminPageClass.newInstance();
                this.add(baseServerPageInfo);
            }
            catch (Exception e) {
                LOG.warn(String.format("Exception registering %s admin page", baseServerAdminPageClass.getName()), (Throwable)e);
            }
        }
    }

    public String buildJerseyResourcePkgListForAdminPages() {
        StringBuilder stringBuilder = new StringBuilder();
        Collection<AdminPageInfo> adminPages = this.getAllPages();
        int i = 0;
        for (AdminPageInfo adminPage : adminPages) {
            String pkgList;
            if (i > 0) {
                stringBuilder.append(";");
            }
            if ((pkgList = adminPage.getJerseyResourcePackageList()) != null) {
                stringBuilder.append(pkgList);
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    private List<String> getAdminPagesPackagesToScan() {
        String adminPagesPkgPath = ConfigurationManager.getConfigInstance().getString(PROP_ID_ADMIN_PAGES_SCAN, DEFAULT_SCAN_PKG);
        Object[] pkgPaths = adminPagesPkgPath.split(";");
        return Lists.newArrayList((Object[])pkgPaths);
    }

    private boolean implementsAdminPageInfo(Class<?> baseServerAdminPageClass) {
        Class<?>[] interfacesImplemented;
        for (Class<?> interfaceObj : interfacesImplemented = baseServerAdminPageClass.getInterfaces()) {
            if (!interfaceObj.equals(AdminPageInfo.class)) continue;
            return true;
        }
        return false;
    }

    private boolean derivedFromAbstractBaseServePageInfo(Class<?> baseServerAdminPageClass) {
        for (Class<?> superClass = baseServerAdminPageClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!superClass.equals(AbstractAdminPageInfo.class)) continue;
            return true;
        }
        return false;
    }

    public List<Class<? extends Annotation>> getAdminPageAnnotations() {
        String adminPageAnnotationClasses = ConfigurationManager.getConfigInstance().getString(PROP_ID_ADMIN_PAGE_ANNOTATION, DEFAULT_ADMIN_PAGE_ANNOTATION);
        String[] clsNameList = adminPageAnnotationClasses.split(";");
        ArrayList<Class<? extends Annotation>> clsList = new ArrayList<Class<? extends Annotation>>(clsNameList.length);
        for (String clsName : clsNameList) {
            try {
                Class<?> aClass = Class.forName(clsName);
                if (!aClass.isAnnotation()) continue;
                clsList.add(aClass.asSubclass(Annotation.class));
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Invalid AdminPage Annotation class - " + clsName);
            }
        }
        return clsList;
    }

    private List<AdminPageInfo> getEnabledPages(List<AdminPageInfo> pages) {
        ArrayList enabledPages = Lists.newArrayList();
        for (AdminPageInfo page : pages) {
            if (!page.isEnabled()) continue;
            enabledPages.add(page);
        }
        return enabledPages;
    }
}

