/*
 * Decompiled with CFR 0.152.
 */
package netflix.admin;

import com.google.common.base.Supplier;
import com.google.inject.Singleton;
import com.netflix.explorers.AbstractExplorerModule;
import com.netflix.explorers.Explorer;
import com.netflix.explorers.ExplorerManager;
import com.netflix.explorers.PropertiesGlobalModelContext;
import com.netflix.explorers.context.GlobalModelContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import netflix.admin.AdminUtils;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AdminExplorerManager
implements ExplorerManager {
    private static final Logger LOG = LoggerFactory.getLogger(AdminExplorerManager.class);
    public static final String ADMIN_EXPLORER_NAME = "baseserver";
    private PropertiesGlobalModelContext propertiesGlobalModelContext;
    private AdminResourceExplorer adminExplorer;

    public AdminExplorerManager() {
        Properties properties = AdminUtils.loadAdminConsoleProps();
        this.propertiesGlobalModelContext = new PropertiesGlobalModelContext(properties);
        this.adminExplorer = new AdminResourceExplorer();
        this.adminExplorer.initialize();
    }

    public void initialize() {
    }

    public void shutdown() {
    }

    public String getDefaultModule() {
        return null;
    }

    public void registerExplorer(Explorer module) {
    }

    public void unregisterExplorer(Explorer module) {
    }

    public void registerExplorerFromClassName(String className) throws Exception {
    }

    public Explorer getExplorer(String name) {
        if (name.equals(ADMIN_EXPLORER_NAME)) {
            return this.adminExplorer;
        }
        throw new IllegalArgumentException("AdminExplorerManager called with explorerName = " + name);
    }

    public Collection<Explorer> getExplorers() {
        return Collections.emptyList();
    }

    public GlobalModelContext getGlobalModel() {
        return this.propertiesGlobalModelContext;
    }

    public Configuration getConfiguration() {
        return null;
    }

    public void registerExplorersFromClassNames(Set<String> classNames) {
    }

    public <T> T getService(Class<T> className) {
        return null;
    }

    public <T> void registerService(Class<T> serviceClass, T instance) {
    }

    public <T> void registerService(Class<T> serviceClass, Supplier<T> supplier) {
    }

    public <T> void registerService(Class<T> serviceClass, Class<? extends T> serviceImplClassName) {
    }

    public boolean getHasAuthProvider() {
        return false;
    }

    public static class AdminResourceExplorer
    extends AbstractExplorerModule {
        public AdminResourceExplorer() {
            super(AdminExplorerManager.ADMIN_EXPLORER_NAME);
        }
    }
}

