/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.netflix.adminresources.AdminResourcesFilter;
import com.netflix.adminresources.AdminResourcesModule;
import com.netflix.adminresources.LoggingFilter;
import com.netflix.adminresources.RedirectFilter;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.governator.annotations.Configuration;
import com.netflix.governator.guice.LifecycleInjector;
import com.netflix.governator.lifecycle.LifecycleManager;
import com.netflix.karyon.server.eureka.HealthCheckInvocationStrategy;
import com.netflix.karyon.spi.Component;
import java.util.EnumSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(disableProperty="netflix.platform.admin.resources.disable")
public class AdminResourcesContainer {
    private static final Logger logger = LoggerFactory.getLogger(AdminResourcesContainer.class);
    public static final String DEFAULT_PAGE_PROP_NAME = "com.netflix.karyon.admin.default.page";
    public static final DynamicStringProperty DEFAULT_PAGE = DynamicPropertyFactory.getInstance().getStringProperty("com.netflix.karyon.admin.default.page", "/healthcheck");
    public static final String CONTAINER_LISTEN_PORT = "netflix.platform.admin.resources.port";
    public static final int LISTEN_PORT_DEFAULT = 8077;
    private static final String JERSEY_CORE_PACKAGES = "netflix.platform.admin.resources.core.packages";
    public static final String JERSEY_CORE_PACKAGES_DEAULT = "com.netflix.adminresources;com.netflix.explorers.resources;com.netflix.explorers.providers";
    private final Provider<HealthCheckInvocationStrategy> healthCheckInvocationStrategyProvider;
    @Configuration(value="netflix.platform.admin.resources.core.packages", documentation="Property defining the list of core packages which contains jersey resources for karyon admin. com.netflix.adminresources is always added to this.")
    private String coreJerseyPackages = "com.netflix.adminresources;com.netflix.explorers.resources;com.netflix.explorers.providers";
    @Configuration(value="netflix.platform.admin.resources.port", documentation="Property defining the listen port for admin resources.", ignoreTypeMismatch=true)
    private int listenPort = 8077;
    private Server server;

    @Inject
    public AdminResourcesContainer(Provider<HealthCheckInvocationStrategy> healthCheckInvocationStrategyProvider) {
        this.healthCheckInvocationStrategyProvider = healthCheckInvocationStrategyProvider;
    }

    @PostConstruct
    public void init() throws Exception {
        this.server = new Server(this.listenPort);
        Injector injector = LifecycleInjector.builder().usingBasePackages(new String[]{"com.netflix.explorers"}).withModules(new Module[]{new AdminResourcesModule(this.healthCheckInvocationStrategyProvider)}).createInjector();
        try {
            ((LifecycleManager)injector.getInstance(LifecycleManager.class)).start();
            AdminResourcesFilter adminResourcesFilter = (AdminResourcesFilter)((Object)injector.getInstance(AdminResourcesFilter.class));
            adminResourcesFilter.setPackages(this.coreJerseyPackages);
            ServletContextHandler handler = new ServletContextHandler();
            handler.setContextPath("/");
            handler.setSessionHandler(new SessionHandler());
            handler.addFilter(LoggingFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
            handler.addFilter(RedirectFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
            handler.addFilter(new FilterHolder((Filter)adminResourcesFilter), "/*", EnumSet.allOf(DispatcherType.class));
            handler.addServlet(new ServletHolder((Servlet)adminResourcesFilter), "/*");
            this.server.setHandler((Handler)handler);
            this.server.start();
        }
        catch (Exception e) {
            logger.error("Exception in building AdminResourcesContainer ", (Throwable)e);
        }
    }

    @PreDestroy
    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (Throwable t) {
            logger.warn("Error while shutting down Admin resources server", t);
        }
    }
}

