/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.demo;

import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.examples.demo.CreditCardAuthorizationResult;
import com.netflix.hystrix.examples.demo.CreditCardCommand;
import com.netflix.hystrix.examples.demo.GetOrderCommand;
import com.netflix.hystrix.examples.demo.GetPaymentInformationCommand;
import com.netflix.hystrix.examples.demo.GetUserAccountCommand;
import com.netflix.hystrix.examples.demo.Order;
import com.netflix.hystrix.examples.demo.PaymentInformation;
import com.netflix.hystrix.examples.demo.UserAccount;
import com.netflix.hystrix.strategy.concurrency.HystrixContextRunnable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.math.BigDecimal;
import java.net.HttpCookie;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.plugins.RxJavaPlugins;
import rx.plugins.RxJavaSchedulersHook;

public class HystrixCommandAsyncDemo {
    private static final Random r = new Random();

    public HystrixCommandAsyncDemo() {
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.coreSize", (Object)8);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.CreditCardCommand.execution.isolation.thread.timeoutInMilliseconds", (Object)3000);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.GetUserAccountCommand.execution.isolation.thread.timeoutInMilliseconds", (Object)50);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.metrics.rollingPercentile.numBuckets", (Object)60);
        RxJavaPlugins.getInstance().registerSchedulersHook((RxJavaSchedulersHook)new ContextAwareRxSchedulersHook());
    }

    public void startDemo(final boolean shouldLog) {
        this.startMetricsMonitor(shouldLog);
        while (true) {
            final HystrixRequestContext context = HystrixRequestContext.initializeContext();
            Observable<CreditCardAuthorizationResult> o = this.observeSimulatedUserRequestForOrderConfirmationAndCreditCardPayment();
            final CountDownLatch latch = new CountDownLatch(1);
            o.subscribe((Subscriber)new Subscriber<CreditCardAuthorizationResult>(){

                public void onCompleted() {
                    latch.countDown();
                    context.shutdown();
                }

                public void onError(Throwable e) {
                    e.printStackTrace();
                    latch.countDown();
                    context.shutdown();
                }

                public void onNext(CreditCardAuthorizationResult creditCardAuthorizationResult) {
                    if (shouldLog) {
                        System.out.println("Request => " + HystrixRequestLog.getCurrentRequest().getExecutedCommandsAsString());
                    }
                }
            });
            try {
                latch.await(5000L, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (InterruptedException ex) {
                System.out.println("INTERRUPTED!");
                continue;
            }
            break;
        }
    }

    public Observable<CreditCardAuthorizationResult> observeSimulatedUserRequestForOrderConfirmationAndCreditCardPayment() {
        try {
            Observable user = new GetUserAccountCommand(new HttpCookie("mockKey", "mockValueFromHttpRequest")).observe();
            Observable paymentInformation = user.flatMap((Func1)new Func1<UserAccount, Observable<PaymentInformation>>(){

                public Observable<PaymentInformation> call(UserAccount userAccount) {
                    return new GetPaymentInformationCommand(userAccount).observe();
                }
            });
            int orderIdFromRequestArgument = 13579;
            Observable previouslySavedOrder = new GetOrderCommand(orderIdFromRequestArgument).observe();
            return Observable.zip((Observable)paymentInformation, (Observable)previouslySavedOrder, (Func2)new Func2<PaymentInformation, Order, Pair<PaymentInformation, Order>>(){

                public Pair<PaymentInformation, Order> call(PaymentInformation paymentInformation, Order order) {
                    return new Pair<PaymentInformation, Order>(paymentInformation, order);
                }
            }).flatMap((Func1)new Func1<Pair<PaymentInformation, Order>, Observable<CreditCardAuthorizationResult>>(){

                public Observable<CreditCardAuthorizationResult> call(Pair<PaymentInformation, Order> pair) {
                    return new CreditCardCommand(pair.b(), pair.a(), new BigDecimal(123.45)).observe();
                }
            });
        }
        catch (IllegalArgumentException ex) {
            return Observable.error((Throwable)ex);
        }
    }

    public void startMetricsMonitor(final boolean shouldLog) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    HystrixCommandMetrics creditCardMetrics = HystrixCommandMetrics.getInstance((HystrixCommandKey)HystrixCommandKey.Factory.asKey((String)CreditCardCommand.class.getSimpleName()));
                    HystrixCommandMetrics orderMetrics = HystrixCommandMetrics.getInstance((HystrixCommandKey)HystrixCommandKey.Factory.asKey((String)GetOrderCommand.class.getSimpleName()));
                    HystrixCommandMetrics userAccountMetrics = HystrixCommandMetrics.getInstance((HystrixCommandKey)HystrixCommandKey.Factory.asKey((String)GetUserAccountCommand.class.getSimpleName()));
                    HystrixCommandMetrics paymentInformationMetrics = HystrixCommandMetrics.getInstance((HystrixCommandKey)HystrixCommandKey.Factory.asKey((String)GetPaymentInformationCommand.class.getSimpleName()));
                    if (!shouldLog) continue;
                    StringBuilder out = new StringBuilder();
                    out.append("\n");
                    out.append("#####################################################################################").append("\n");
                    out.append("# CreditCardCommand: " + this.getStatsStringFromMetrics(creditCardMetrics)).append("\n");
                    out.append("# GetOrderCommand: " + this.getStatsStringFromMetrics(orderMetrics)).append("\n");
                    out.append("# GetUserAccountCommand: " + this.getStatsStringFromMetrics(userAccountMetrics)).append("\n");
                    out.append("# GetPaymentInformationCommand: " + this.getStatsStringFromMetrics(paymentInformationMetrics)).append("\n");
                    out.append("#####################################################################################").append("\n");
                    System.out.println(out.toString());
                }
            }

            private String getStatsStringFromMetrics(HystrixCommandMetrics metrics) {
                StringBuilder m = new StringBuilder();
                if (metrics != null) {
                    HystrixCommandMetrics.HealthCounts health = metrics.getHealthCounts();
                    m.append("Requests: ").append(health.getTotalRequests()).append(" ");
                    m.append("Errors: ").append(health.getErrorCount()).append(" (").append(health.getErrorPercentage()).append("%)   ");
                    m.append("Mean: ").append(metrics.getExecutionTimePercentile(50.0)).append(" ");
                    m.append("75th: ").append(metrics.getExecutionTimePercentile(75.0)).append(" ");
                    m.append("90th: ").append(metrics.getExecutionTimePercentile(90.0)).append(" ");
                    m.append("99th: ").append(metrics.getExecutionTimePercentile(99.0)).append(" ");
                }
                return m.toString();
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private class Pair<A, B> {
        private final A a;
        private final B b;

        Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        A a() {
            return this.a;
        }

        B b() {
            return this.b;
        }
    }

    static class ContextAwareRxSchedulersHook
    extends RxJavaSchedulersHook {
        ContextAwareRxSchedulersHook() {
        }

        public Action0 onSchedule(final Action0 initialAction) {
            Runnable initialRunnable = new Runnable(){

                @Override
                public void run() {
                    initialAction.call();
                }
            };
            HystrixContextRunnable wrappedRunnable = new HystrixContextRunnable(initialRunnable);
            return new Action0((Runnable)wrappedRunnable){
                final /* synthetic */ Runnable val$wrappedRunnable;
                {
                    this.val$wrappedRunnable = runnable;
                }

                public void call() {
                    this.val$wrappedRunnable.run();
                }
            };
        }
    }
}

