/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.demo;

public class CreditCardAuthorizationResult {
    private final boolean success;
    private final boolean isDuplicate;
    private final String authorizationCode;
    private final String transactionID;
    private final String errorMessage;

    public static CreditCardAuthorizationResult createSuccessResponse(String transactionID, String authorizationCode) {
        return new CreditCardAuthorizationResult(true, transactionID, authorizationCode, false);
    }

    public static CreditCardAuthorizationResult createDuplicateSuccessResponse(String transactionID, String authorizationCode) {
        return new CreditCardAuthorizationResult(true, transactionID, authorizationCode, true);
    }

    public static CreditCardAuthorizationResult createFailedResponse(String message) {
        return new CreditCardAuthorizationResult(false, message, null, false);
    }

    private CreditCardAuthorizationResult(boolean success, String value, String value2, boolean isResponseDuplicate) {
        this.success = success;
        this.isDuplicate = isResponseDuplicate;
        if (success) {
            this.transactionID = value;
            this.authorizationCode = value2;
            this.errorMessage = null;
        } else {
            this.transactionID = null;
            this.errorMessage = value;
            this.authorizationCode = null;
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isDuplicateTransaction() {
        return this.isDuplicate;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

