/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;

public class CommandHelloFailure
extends HystrixCommand<String> {
    private final String name;

    public CommandHelloFailure(String name) {
        super(HystrixCommandGroupKey.Factory.asKey((String)"ExampleGroup"));
        this.name = name;
    }

    protected String run() {
        throw new RuntimeException("this command always fails");
    }

    protected String getFallback() {
        return "Hello Failure " + this.name + "!";
    }

    public static class UnitTest {
        @Test
        public void testSynchronous() {
            Assert.assertEquals((Object)"Hello Failure World!", (Object)new CommandHelloFailure("World").execute());
            Assert.assertEquals((Object)"Hello Failure Bob!", (Object)new CommandHelloFailure("Bob").execute());
        }

        @Test
        public void testAsynchronous1() throws Exception {
            Assert.assertEquals((Object)"Hello Failure World!", new CommandHelloFailure("World").queue().get());
            Assert.assertEquals((Object)"Hello Failure Bob!", new CommandHelloFailure("Bob").queue().get());
        }

        @Test
        public void testAsynchronous2() throws Exception {
            Future fWorld = new CommandHelloFailure("World").queue();
            Future fBob = new CommandHelloFailure("Bob").queue();
            Assert.assertEquals((Object)"Hello Failure World!", fWorld.get());
            Assert.assertEquals((Object)"Hello Failure Bob!", fBob.get());
        }
    }
}

