/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.zenoadapter.util;

import java.util.Arrays;

public class ObjectIdentityOrdinalMap {
    private final Segment[] segments;
    private final int mask;
    private final int logOfSegmentNumber;

    public ObjectIdentityOrdinalMap() {
        this(8);
    }

    public ObjectIdentityOrdinalMap(int logOfSegmentNumber) {
        if (logOfSegmentNumber < 1 && logOfSegmentNumber > 32) {
            throw new RuntimeException("Invalid power level");
        }
        this.segments = new Segment[2 << logOfSegmentNumber];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment();
        }
        this.mask = (2 << logOfSegmentNumber) - 1;
        this.logOfSegmentNumber = logOfSegmentNumber;
    }

    public void put(Object obj, int ordinal) {
        int hashCode = System.identityHashCode(obj);
        int segment = this.segment(hashCode);
        this.segments[segment].put(obj, hashCode, ordinal);
    }

    public Entry getEntry(Object obj) {
        int hashCode = System.identityHashCode(obj);
        int segment = this.segment(hashCode);
        return this.segments[segment].get(obj, hashCode);
    }

    private final int segment(int hashCode) {
        return hashCode & this.mask;
    }

    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    public int size() {
        int size = 0;
        for (Segment segment : this.segments) {
            size += segment.size();
        }
        return size;
    }

    private class Segment {
        private static final int LOAD_FACTOR_PERCENT = 75;
        private static final int MINIMUM_CAPACITY = 256;
        private static final int MAXIMUM_CAPACITY = 0x40000000;
        private int count = 0;
        private int maxThreshold = 0;
        private int minThreshold = 0;
        private Entry[] entries;

        public Segment() {
            this.resize(256);
        }

        public synchronized void put(Object object, int hashCode, int ordinal) {
            Entry entry;
            int index = this.index(hashCode, this.entries.length);
            Entry current = this.entries[index];
            Entry prev = null;
            while (current != null) {
                if (current.hash() == hashCode) {
                    Object currentObject = current.getKey();
                    if (currentObject == null) {
                        this.deleteEntry(index, current, prev);
                        current = current.next;
                        continue;
                    }
                    if (currentObject == object) {
                        return;
                    }
                }
                prev = current;
                current = current.next;
            }
            ++this.count;
            Entry first = this.entries[index];
            this.entries[index] = entry = new Entry(object, hashCode, ordinal, first);
            entry.next = first;
            this.checkSize();
        }

        public synchronized Entry get(Object object, int hashCode) {
            int index = this.index(hashCode, this.entries.length);
            Entry current = this.entries[index];
            Entry prev = null;
            while (current != null) {
                if (current.hash() == hashCode) {
                    Object currentObject = current.getKey();
                    if (currentObject == null) {
                        this.deleteEntry(index, current, prev);
                        current = current.next;
                        continue;
                    }
                    if (currentObject == object) {
                        return current;
                    }
                }
                prev = current;
                current = current.next;
            }
            return null;
        }

        private void checkSize() {
            if (this.count >= this.minThreshold && this.count <= this.maxThreshold) {
                return;
            }
            int newCapacity = this.count < this.minThreshold ? Math.max(256, this.entries.length >> 1) : Math.min(0x40000000, this.entries.length << 1);
            if (newCapacity == this.entries.length) {
                return;
            }
            this.resize(newCapacity);
        }

        private void resize(int newCapacity) {
            Entry[] newEntries = new Entry[newCapacity];
            if (this.entries != null) {
                Entry[] arr$ = this.entries;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Entry entry;
                    Entry current = entry = arr$[i$];
                    while (current != null) {
                        Entry newEntry = current;
                        current = current.next;
                        int index = this.index(newEntry.hash(), newEntries.length);
                        newEntry.next = newEntries[index];
                        newEntries[index] = newEntry;
                    }
                }
            }
            this.minThreshold = newEntries.length == 256 ? 0 : newEntries.length * 75 / 200;
            this.maxThreshold = newEntries.length == 0x40000000 ? Integer.MAX_VALUE : newEntries.length * 75 / 100;
            this.entries = newEntries;
        }

        private void deleteEntry(int index, Entry current, Entry prev) {
            --this.count;
            if (prev != null) {
                prev.next = current.next;
            } else {
                this.entries[index] = current.next;
            }
        }

        private final int index(int hashCode, int capacity) {
            return (hashCode >>> ObjectIdentityOrdinalMap.this.logOfSegmentNumber) % capacity;
        }

        public synchronized void clear() {
            Arrays.fill(this.entries, null);
            this.count = 0;
            this.resize(256);
        }

        public synchronized int size() {
            return this.count;
        }
    }

    public static final class Entry {
        private final Object key;
        private final int ordinal;
        private Entry next;

        Entry(Object key, int hash, int ordinal, Entry next) {
            this.key = key;
            this.ordinal = ordinal;
            this.next = next;
        }

        public Object getKey() {
            return this.key;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String toString() {
            Object v = this.key;
            return v == null ? "null" : v.toString();
        }

        public int hash() {
            return System.identityHashCode(this.key);
        }
    }
}

