/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.zenoadapter;

import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.core.write.HollowListTypeWriteState;
import com.netflix.hollow.core.write.HollowMapTypeWriteState;
import com.netflix.hollow.core.write.HollowObjectTypeWriteState;
import com.netflix.hollow.core.write.HollowSetTypeWriteState;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.zenoadapter.HollowFrameworkSerializer;
import com.netflix.hollow.zenoadapter.HollowSerializationRecord;
import com.netflix.hollow.zenoadapter.util.ObjectIdentityOrdinalMap;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.fastblob.record.schema.FieldDefinition;
import com.netflix.zeno.fastblob.record.schema.MapFieldDefinition;
import com.netflix.zeno.fastblob.record.schema.TypedFieldDefinition;
import com.netflix.zeno.serializer.NFSerializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializationFramework;
import com.netflix.zeno.serializer.SerializerFactory;
import com.netflix.zeno.serializer.common.ListSerializer;
import com.netflix.zeno.serializer.common.MapSerializer;
import com.netflix.zeno.serializer.common.SetSerializer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HollowSerializationFramework
extends SerializationFramework {
    private final HollowWriteStateEngine stateEngine;
    private final ConcurrentHashMap<String, ObjectIdentityOrdinalMap> objectIdentityOrdinalMaps;

    public HollowSerializationFramework(SerializerFactory serializerFactory, HollowObjectHashCodeFinder hashCodeFinder) {
        super(serializerFactory);
        this.frameworkSerializer = new HollowFrameworkSerializer(this, hashCodeFinder);
        this.stateEngine = new HollowWriteStateEngine(hashCodeFinder);
        this.objectIdentityOrdinalMaps = new ConcurrentHashMap();
        this.populateStateEngineTypes();
    }

    public HollowObjectHashCodeFinder getHollowObjectHasher() {
        return ((HollowFrameworkSerializer)this.getFrameworkSerializer()).hasher;
    }

    public void prepareForNextCycle() {
        this.stateEngine.prepareForNextCycle();
        this.objectIdentityOrdinalMaps.clear();
    }

    public int add(String type, Object o) {
        ObjectIdentityOrdinalMap identityOrdinalMap = this.getIdentityOrdinalMap(type);
        ObjectIdentityOrdinalMap.Entry entry = identityOrdinalMap.getEntry(o);
        if (entry != null) {
            return entry.getOrdinal();
        }
        NFTypeSerializer serializer = this.getSerializer(type);
        int ordinal = this.add(type, o, (NFTypeSerializer<Object>)serializer);
        identityOrdinalMap.put(o, ordinal);
        return ordinal;
    }

    private int add(String type, Object o, NFTypeSerializer<Object> serializer) {
        if (serializer instanceof ListSerializer) {
            return this.addList(type, o, serializer);
        }
        if (serializer instanceof SetSerializer) {
            return this.addSet(type, o, serializer);
        }
        if (serializer instanceof MapSerializer) {
            return this.addMap(type, o, serializer);
        }
        return this.addObject(type, o, serializer);
    }

    private int addList(String type, Object o, NFTypeSerializer<Object> serializer) {
        String elementType = ((TypedFieldDefinition)serializer.getFastBlobSchema().getFieldDefinition(0)).getSubType();
        int ordinal = this.frameworkSerializer().serializeList(this.getRec(type), elementType, (Collection)o);
        return ordinal;
    }

    private int addSet(String type, Object o, NFTypeSerializer<Object> serializer) {
        String elementType = ((TypedFieldDefinition)serializer.getFastBlobSchema().getFieldDefinition(0)).getSubType();
        int ordinal = this.frameworkSerializer().serializeSet(this.getRec(type), elementType, (Set)o);
        return ordinal;
    }

    private int addMap(String type, Object o, NFTypeSerializer<Object> serializer) {
        String keyType = ((MapFieldDefinition)serializer.getFastBlobSchema().getFieldDefinition(0)).getKeyType();
        String valueType = ((MapFieldDefinition)serializer.getFastBlobSchema().getFieldDefinition(0)).getValueType();
        int ordinal = this.frameworkSerializer().serializeMap(this.getRec(type), keyType, valueType, (Map)o);
        return ordinal;
    }

    private int addObject(String type, Object o, NFTypeSerializer<Object> serializer) {
        HollowSerializationRecord rec = this.getRec(type);
        serializer.serialize(o, (NFSerializationRecord)rec);
        int ordinal = this.stateEngine.add(type, rec.getHollowWriteRecord());
        return ordinal;
    }

    private HollowSerializationRecord getRec(String type) {
        HollowSerializationRecord rec = this.frameworkSerializer().getRec(type);
        rec.reset();
        return rec;
    }

    private HollowFrameworkSerializer frameworkSerializer() {
        return (HollowFrameworkSerializer)this.frameworkSerializer;
    }

    public HollowWriteStateEngine getStateEngine() {
        return this.stateEngine;
    }

    public HollowSchema getHollowSchema(String schemaName) {
        return this.stateEngine.getSchema(schemaName);
    }

    private void populateStateEngineTypes() {
        for (NFTypeSerializer serializer : this.getOrderedSerializers()) {
            HollowListTypeWriteState writeState;
            TypedFieldDefinition elementFieldDef;
            if (serializer instanceof ListSerializer) {
                ListSerializer listSerializer = (ListSerializer)serializer;
                elementFieldDef = (TypedFieldDefinition)listSerializer.getFastBlobSchema().getFieldDefinition(0);
                HollowListSchema listSchema = new HollowListSchema(serializer.getName(), elementFieldDef.getSubType());
                writeState = new HollowListTypeWriteState(listSchema);
                this.stateEngine.addTypeState((HollowTypeWriteState)writeState);
                continue;
            }
            if (serializer instanceof SetSerializer) {
                SetSerializer setSerializer = (SetSerializer)serializer;
                elementFieldDef = (TypedFieldDefinition)setSerializer.getFastBlobSchema().getFieldDefinition(0);
                HollowSetSchema setSchema = new HollowSetSchema(serializer.getName(), elementFieldDef.getSubType(), new String[0]);
                writeState = new HollowSetTypeWriteState(setSchema);
                this.stateEngine.addTypeState((HollowTypeWriteState)writeState);
                continue;
            }
            if (serializer instanceof MapSerializer) {
                MapSerializer mapSerializer = (MapSerializer)serializer;
                MapFieldDefinition fieldDef = (MapFieldDefinition)mapSerializer.getFastBlobSchema().getFieldDefinition(0);
                HollowMapSchema mapSchema = new HollowMapSchema(serializer.getName(), fieldDef.getKeyType(), fieldDef.getValueType(), new String[0]);
                writeState = new HollowMapTypeWriteState(mapSchema);
                this.stateEngine.addTypeState((HollowTypeWriteState)writeState);
                continue;
            }
            HollowObjectSchema objectSchema = this.getHollowObjectSchema(serializer.getFastBlobSchema());
            HollowObjectTypeWriteState writeState2 = new HollowObjectTypeWriteState(objectSchema);
            this.stateEngine.addTypeState((HollowTypeWriteState)writeState2);
        }
    }

    private HollowObjectSchema getHollowObjectSchema(FastBlobSchema schema) {
        HollowObjectSchema hollowSchema = new HollowObjectSchema(schema.getName(), schema.numFields(), new String[0]);
        block13: for (int i = 0; i < schema.numFields(); ++i) {
            FieldDefinition def = schema.getFieldDefinition(i);
            switch (def.getFieldType()) {
                case OBJECT: {
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.REFERENCE, ((TypedFieldDefinition)def).getSubType());
                    continue block13;
                }
                case LIST: {
                    String listTypeName = schema.getName() + "_" + schema.getFieldName(i);
                    String listElementType = ((TypedFieldDefinition)def).getSubType();
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.REFERENCE, listTypeName);
                    HollowListSchema listSchema = new HollowListSchema(listTypeName, listElementType);
                    HollowListTypeWriteState listWriteState = new HollowListTypeWriteState(listSchema);
                    this.stateEngine.addTypeState((HollowTypeWriteState)listWriteState);
                    continue block13;
                }
                case SET: {
                    String setTypeName = schema.getName() + "_" + schema.getFieldName(i);
                    String setElementType = ((TypedFieldDefinition)def).getSubType();
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.REFERENCE, setTypeName);
                    HollowSetSchema setSchema = new HollowSetSchema(setTypeName, setElementType, new String[0]);
                    HollowSetTypeWriteState setWriteState = new HollowSetTypeWriteState(setSchema);
                    this.stateEngine.addTypeState((HollowTypeWriteState)setWriteState);
                    continue block13;
                }
                case MAP: {
                    String mapTypeName = schema.getName() + "_" + schema.getFieldName(i);
                    String keyType = ((MapFieldDefinition)def).getKeyType();
                    String valueType = ((MapFieldDefinition)def).getValueType();
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.REFERENCE, mapTypeName);
                    HollowMapSchema mapSchema = new HollowMapSchema(mapTypeName, keyType, valueType, new String[0]);
                    HollowMapTypeWriteState mapWriteState = new HollowMapTypeWriteState(mapSchema);
                    this.stateEngine.addTypeState((HollowTypeWriteState)mapWriteState);
                    continue block13;
                }
                case BOOLEAN: {
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.BOOLEAN);
                    continue block13;
                }
                case BYTES: {
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.BYTES);
                    continue block13;
                }
                case DOUBLE: {
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.DOUBLE);
                    continue block13;
                }
                case FLOAT: {
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.FLOAT);
                    continue block13;
                }
                case INT: {
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.INT);
                    continue block13;
                }
                case LONG: {
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.LONG);
                    continue block13;
                }
                case STRING: {
                    hollowSchema.addField(schema.getFieldName(i), HollowObjectSchema.FieldType.STRING);
                    continue block13;
                }
                default: {
                    throw new IllegalArgumentException("Field " + schema.getName() + "." + schema.getFieldName(i) + " is declared with illegal type " + schema.getFieldType(i));
                }
            }
        }
        return hollowSchema;
    }

    private ObjectIdentityOrdinalMap getIdentityOrdinalMap(String type) {
        ObjectIdentityOrdinalMap existing;
        ObjectIdentityOrdinalMap objectIdentityOrdinalMap = this.objectIdentityOrdinalMaps.get(type);
        if (objectIdentityOrdinalMap == null && (existing = this.objectIdentityOrdinalMaps.putIfAbsent(type, objectIdentityOrdinalMap = new ObjectIdentityOrdinalMap())) != null) {
            objectIdentityOrdinalMap = existing;
        }
        return objectIdentityOrdinalMap;
    }
}

