/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui.pages;

import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.diff.ui.model.HollowDiffUIBreadcrumbs;
import com.netflix.hollow.diff.ui.pages.DiffPage;
import com.netflix.hollow.diffview.HollowDiffHtmlKickstarter;
import com.netflix.hollow.diffview.HollowObjectView;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.tools.diff.count.HollowFieldDiff;
import com.netflix.hollow.ui.HollowUISession;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;

public class DiffObjectPage
extends DiffPage {
    public DiffObjectPage(HollowDiffUI diffUI) {
        super(diffUI, "diff-object.vm");
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        String type = req.getParameter("type");
        int fromOrdinal = Integer.parseInt(req.getParameter("fromOrdinal"));
        int toOrdinal = Integer.parseInt(req.getParameter("toOrdinal"));
        int fieldIdx = -1;
        if (req.getParameter("fieldIdx") != null) {
            fieldIdx = Integer.parseInt(req.getParameter("fieldIdx"));
        }
        ctx.put("typeName", (Object)type);
        ctx.put("fromOrdinal", (Object)fromOrdinal);
        ctx.put("toOrdinal", (Object)toOrdinal);
        HollowObjectView diffView = this.diffUI.getHollowObjectViewProvider().getObjectView(req, session);
        HollowDiffHtmlKickstarter htmlKickstarter = new HollowDiffHtmlKickstarter(this.diffUI.getBaseURLPath());
        ctx.put("initialHtml", (Object)htmlKickstarter.initialHtmlRows(diffView));
        ctx.put("breadcrumbs", this.getBreadcrumbs(type, fieldIdx, fromOrdinal, toOrdinal));
    }

    private List<HollowDiffUIBreadcrumbs> getBreadcrumbs(String type, int fieldIdx, int fromOrdinal, int toOrdinal) {
        HollowTypeDiff typeDiff = this.getTypeDiff(type);
        ArrayList<HollowDiffUIBreadcrumbs> breadcrumbs = new ArrayList<HollowDiffUIBreadcrumbs>();
        breadcrumbs.add(new HollowDiffUIBreadcrumbs(this.diffUI.getDiffUIPath() == null || this.diffUI.getDiffUIPath().length() == 0 ? "/" : this.diffUI.getDiffUIPath(), "Overview"));
        breadcrumbs.add(new HollowDiffUIBreadcrumbs(this.diffUI.getDiffUIPath() == null || this.diffUI.getDiffUIPath().length() == 0 ? "typediff?type=" + type : this.diffUI.getDiffUIPath() + "/typediff?type=" + type, type));
        if (fieldIdx != -1) {
            breadcrumbs.add(new HollowDiffUIBreadcrumbs(this.diffUI.getDiffUIPath() == null || this.diffUI.getDiffUIPath().length() == 0 ? "fielddiff?type=" + type + "&fieldIdx=" + fieldIdx : this.diffUI.getDiffUIPath() + "/fielddiff?type=" + type + "&fieldIdx=" + fieldIdx, ((HollowFieldDiff)typeDiff.getFieldDiffs().get(fieldIdx)).getFieldIdentifier().toString()));
        }
        String displayKey = fromOrdinal != -1 ? typeDiff.getMatcher().getKeyDisplayString(typeDiff.getFromTypeState(), fromOrdinal) : typeDiff.getMatcher().getKeyDisplayString(typeDiff.getToTypeState(), toOrdinal);
        breadcrumbs.add(new HollowDiffUIBreadcrumbs(null, displayKey));
        return breadcrumbs;
    }
}

