/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview.effigy;

import com.netflix.hollow.core.read.dataaccess.HollowCollectionTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.diffview.effigy.HollowEffigy;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HollowEffigyFactory {
    private final Base64.Encoder base64 = Base64.getEncoder();
    private final Map<HollowEffigy.Field, HollowEffigy.Field> fieldMemoizer = new HashMap<HollowEffigy.Field, HollowEffigy.Field>();

    public HollowEffigy effigy(HollowDataAccess dataAccess, String typeName, int ordinal) {
        if (ordinal == -1) {
            return null;
        }
        HollowTypeDataAccess typeState = dataAccess.getTypeDataAccess(typeName, ordinal);
        if (typeState == null) {
            return null;
        }
        if (typeState instanceof HollowObjectTypeDataAccess) {
            return new HollowEffigy(this, (HollowTypeDataAccess)((HollowObjectTypeDataAccess)typeState), ordinal);
        }
        if (typeState instanceof HollowCollectionTypeDataAccess) {
            return new HollowEffigy(this, (HollowTypeDataAccess)((HollowCollectionTypeDataAccess)typeState), ordinal);
        }
        if (typeState instanceof HollowMapTypeDataAccess) {
            return new HollowEffigy(this, (HollowTypeDataAccess)((HollowMapTypeDataAccess)typeState), ordinal);
        }
        throw new IllegalArgumentException("I don't know how to effigize a " + typeState.getClass());
    }

    List<HollowEffigy.Field> createFields(HollowEffigy effigy) {
        switch (effigy.dataAccess.getSchema().getSchemaType()) {
            case OBJECT: {
                return this.createObjectFields(effigy);
            }
            case LIST: 
            case SET: {
                return this.createCollectionFields(effigy);
            }
            case MAP: {
                return this.createMapFields(effigy);
            }
        }
        throw new IllegalArgumentException();
    }

    List<HollowEffigy.Field> createObjectFields(HollowEffigy effigy) {
        ArrayList<HollowEffigy.Field> fields = new ArrayList<HollowEffigy.Field>();
        HollowObjectTypeDataAccess typeDataAccess = (HollowObjectTypeDataAccess)effigy.dataAccess;
        HollowObjectSchema schema = typeDataAccess.getSchema();
        for (int i = 0; i < schema.numFields(); ++i) {
            String fieldName = schema.getFieldName(i);
            String fieldType = schema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE ? schema.getReferencedType(i) : schema.getFieldType(i).toString();
            Object fieldValue = null;
            switch (schema.getFieldType(i)) {
                case BOOLEAN: {
                    fieldValue = typeDataAccess.readBoolean(effigy.ordinal, i);
                    break;
                }
                case BYTES: {
                    byte[] fieldValueBytes = typeDataAccess.readBytes(effigy.ordinal, i);
                    if (fieldValueBytes == null || fieldValueBytes.length == 0) {
                        fieldValue = fieldValueBytes;
                        break;
                    }
                    fieldValue = this.base64.encodeToString(fieldValueBytes);
                    break;
                }
                case DOUBLE: {
                    fieldValue = typeDataAccess.readDouble(effigy.ordinal, i);
                    break;
                }
                case FLOAT: {
                    fieldValue = Float.valueOf(typeDataAccess.readFloat(effigy.ordinal, i));
                    break;
                }
                case INT: {
                    fieldValue = typeDataAccess.readInt(effigy.ordinal, i);
                    break;
                }
                case LONG: {
                    long longVal = typeDataAccess.readLong(effigy.ordinal, i);
                    if (longVal != Long.MIN_VALUE && "Date".equals(typeDataAccess.getSchema().getName())) {
                        fieldValue = new Date(longVal).toString();
                        break;
                    }
                    fieldValue = typeDataAccess.readLong(effigy.ordinal, i);
                    break;
                }
                case STRING: {
                    fieldValue = typeDataAccess.readString(effigy.ordinal, i);
                    break;
                }
                case REFERENCE: {
                    fieldValue = this.effigy(typeDataAccess.getDataAccess(), schema.getReferencedType(i), typeDataAccess.readOrdinal(effigy.ordinal, i));
                }
            }
            HollowEffigy.Field field = new HollowEffigy.Field(fieldName, fieldType, fieldValue);
            if (schema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE) {
                field = this.memoize(field);
            }
            fields.add(field);
        }
        return fields;
    }

    private List<HollowEffigy.Field> createCollectionFields(HollowEffigy effigy) {
        ArrayList<HollowEffigy.Field> fields = new ArrayList<HollowEffigy.Field>();
        HollowCollectionTypeDataAccess typeDataAccess = (HollowCollectionTypeDataAccess)effigy.dataAccess;
        HollowCollectionSchema schema = typeDataAccess.getSchema();
        HollowOrdinalIterator iter = typeDataAccess.ordinalIterator(effigy.ordinal);
        int elementOrdinal = iter.next();
        while (elementOrdinal != Integer.MAX_VALUE) {
            HollowEffigy elementEffigy = this.effigy(typeDataAccess.getDataAccess(), schema.getElementType(), elementOrdinal);
            fields.add(new HollowEffigy.Field("element", elementEffigy));
            elementOrdinal = iter.next();
        }
        return fields;
    }

    private List<HollowEffigy.Field> createMapFields(HollowEffigy effigy) {
        ArrayList<HollowEffigy.Field> fields = new ArrayList<HollowEffigy.Field>();
        HollowMapTypeDataAccess typeDataAccess = (HollowMapTypeDataAccess)effigy.dataAccess;
        HollowMapSchema schema = typeDataAccess.getSchema();
        HollowMapEntryOrdinalIterator iter = typeDataAccess.ordinalIterator(effigy.ordinal);
        while (iter.next()) {
            HollowEffigy entryEffigy = new HollowEffigy("Map.Entry");
            entryEffigy.add(new HollowEffigy.Field("key", this.effigy(typeDataAccess.getDataAccess(), schema.getKeyType(), iter.getKey())));
            entryEffigy.add(new HollowEffigy.Field("value", this.effigy(typeDataAccess.getDataAccess(), schema.getValueType(), iter.getValue())));
            fields.add(new HollowEffigy.Field("entry", "Map.Entry", entryEffigy));
        }
        return fields;
    }

    private HollowEffigy.Field memoize(HollowEffigy.Field field) {
        HollowEffigy.Field canonical = this.fieldMemoizer.get(field);
        if (canonical == null) {
            this.fieldMemoizer.put(field, field);
            canonical = field;
        }
        return canonical;
    }
}

