/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview.effigy.pairer;

import com.netflix.hollow.diffview.effigy.HollowEffigy;
import java.util.HashMap;
import java.util.Map;

public class HollowEffigyDiffRecord {
    private final Map<HollowEffigy.Field, FieldDiffCount> map;
    private final SimilarityDifferenceCounter simDiffCount = new SimilarityDifferenceCounter();
    private int totalOriginalFieldCount;
    private int runId;

    public HollowEffigyDiffRecord(HollowEffigy basedOn) {
        this.map = new HashMap<HollowEffigy.Field, FieldDiffCount>();
        this.traverseOriginalFields(basedOn);
    }

    private void traverseOriginalFields(HollowEffigy effigy) {
        for (HollowEffigy.Field field : effigy.getFields()) {
            if (field.isLeafNode()) {
                FieldDiffCount fieldCount = this.map.get(field);
                if (fieldCount == null) {
                    fieldCount = new FieldDiffCount();
                    this.map.put(field, fieldCount);
                }
                fieldCount.incrementOriginalCount();
                ++this.totalOriginalFieldCount;
                continue;
            }
            this.traverseOriginalFields((HollowEffigy)field.getValue());
        }
    }

    public int calculateDiff(HollowEffigy comparison, int maxDiff) {
        ++this.runId;
        this.simDiffCount.reset();
        this.traverseComparisonFields(comparison, maxDiff);
        if (this.simDiffCount.diffCount >= maxDiff) {
            return 0x1FFFFF;
        }
        return this.score();
    }

    public void traverseComparisonFields(HollowEffigy comparison, int maxDiff) {
        for (HollowEffigy.Field field : comparison.getFields()) {
            if (field.isLeafNode()) {
                FieldDiffCount fieldCount = this.map.get(field);
                if (fieldCount == null) {
                    if (this.simDiffCount.diffCount + 1 >= maxDiff) {
                        this.simDiffCount.diffCount++;
                        return;
                    }
                    fieldCount = new FieldDiffCount();
                    this.map.put(field, fieldCount);
                }
                if (fieldCount.incrementComparisonCount(this.runId)) {
                    if (++this.simDiffCount.diffCount < maxDiff) continue;
                    return;
                }
                this.simDiffCount.simCount++;
                continue;
            }
            this.traverseComparisonFields((HollowEffigy)field.getValue(), maxDiff);
            if (this.simDiffCount.diffCount < maxDiff) continue;
            return;
        }
    }

    private int score() {
        int totalDiff = this.totalOriginalFieldCount - this.simDiffCount.simCount + this.simDiffCount.diffCount;
        if (this.simDiffCount.simCount == 0 && totalDiff != 0) {
            return 0x1FFFFF;
        }
        return totalDiff;
    }

    private static class SimilarityDifferenceCounter {
        private int simCount;
        private int diffCount;

        private SimilarityDifferenceCounter() {
        }

        public void reset() {
            this.simCount = 0;
            this.diffCount = 0;
        }
    }

    private class FieldDiffCount {
        private int originalCount;
        private int comparisonCount;
        private int lastComparisonUpdatedRunId;

        private FieldDiffCount() {
        }

        private void incrementOriginalCount() {
            ++this.originalCount;
        }

        private boolean incrementComparisonCount(int runId) {
            this.clearComparisonIfRunChanged(runId);
            return ++this.comparisonCount > this.originalCount;
        }

        private void clearComparisonIfRunChanged(int runId) {
            if (runId != this.lastComparisonUpdatedRunId) {
                this.comparisonCount = 0;
                this.lastComparisonUpdatedRunId = runId;
            }
        }
    }
}

