/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.model;

import com.netflix.hollow.history.ui.model.RecordDiff;
import com.netflix.hollow.history.ui.naming.HollowHistoryRecordNamer;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecordDiffTreeNode {
    private final String hierarchicalFieldName;
    private final HollowHistoricalState historicalState;
    private final HollowHistoryRecordNamer recordNamer;
    private final String groupName;
    private final Map<Object, RecordDiffTreeNode> childNodes;
    private final List<RecordDiff> recordDiffs;

    public RecordDiffTreeNode(String parentHierarchicalFieldName, Object groupIdentifier, String groupName, HollowHistoricalState historicalState, HollowHistoryRecordNamer recordNamer) {
        this.hierarchicalFieldName = parentHierarchicalFieldName + "." + String.valueOf(groupIdentifier);
        this.historicalState = historicalState;
        this.recordNamer = recordNamer;
        this.groupName = groupName;
        this.childNodes = new HashMap<Object, RecordDiffTreeNode>();
        this.recordDiffs = new ArrayList<RecordDiff>();
    }

    public String getHierarchicalFieldName() {
        return this.hierarchicalFieldName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean hasSubGroups() {
        return !this.childNodes.isEmpty();
    }

    public RecordDiffTreeNode getChildNode(Object value, int keyFieldIdx) {
        RecordDiffTreeNode child = this.childNodes.get(value);
        if (child == null) {
            child = new RecordDiffTreeNode(this.hierarchicalFieldName, value, this.recordNamer.getKeyFieldName(this.historicalState, value, keyFieldIdx), this.historicalState, this.recordNamer);
            this.childNodes.put(value, child);
        }
        return child;
    }

    public void addRecordDiff(RecordDiff diff) {
        this.recordDiffs.add(diff);
    }

    public List<RecordDiff> getRecordDiffs() {
        return this.recordDiffs;
    }

    public boolean isEmpty() {
        return this.recordDiffs.isEmpty() && this.childNodes.isEmpty();
    }

    public int getDiffCount() {
        int totalCount = 0;
        for (Map.Entry<Object, RecordDiffTreeNode> entry : this.childNodes.entrySet()) {
            totalCount += entry.getValue().getDiffCount();
        }
        return totalCount += this.recordDiffs.size();
    }

    public Collection<RecordDiffTreeNode> getSubGroups() {
        return this.childNodes.values();
    }
}

