/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.pages;

import com.netflix.hollow.diffview.HollowDiffHtmlKickstarter;
import com.netflix.hollow.diffview.HollowObjectView;
import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.history.ui.VersionTimestampConverter;
import com.netflix.hollow.history.ui.model.HistoricalObjectChangeVersion;
import com.netflix.hollow.history.ui.pages.HistoryPage;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.tools.history.HollowHistory;
import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateTypeKeyOrdinalMapping;
import com.netflix.hollow.ui.HollowUISession;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;

public class HistoricalObjectDiffPage
extends HistoryPage {
    public HistoricalObjectDiffPage(HollowHistoryUI ui) {
        super(ui, "history-object.vm");
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        long version = Long.parseLong(req.getParameter("version"));
        String type = req.getParameter("type");
        int keyOrdinal = Integer.parseInt(req.getParameter("keyOrdinal"));
        ctx.put("version", (Object)version);
        ctx.put("typeName", (Object)type);
        ctx.put("keyOrdinal", (Object)keyOrdinal);
        HollowObjectView objectView = this.ui.getViewProvider().getObjectView(req, session);
        HollowDiffHtmlKickstarter htmlKickstarter = new HollowDiffHtmlKickstarter(this.ui.getBaseURLPath());
        HollowHistory history = this.ui.getHistory();
        ctx.put("initialHtml", (Object)htmlKickstarter.initialHtmlRows(objectView));
        ctx.put("changeVersions", this.getChangeVersions(type, keyOrdinal, history));
        ctx.put("headerEntries", this.getHeaderEntries(history.getHistoricalState(version)));
    }

    private List<HistoricalObjectChangeVersion> getChangeVersions(String type, int keyOrdinal, HollowHistory history) {
        ArrayList<HistoricalObjectChangeVersion> changeVersions = new ArrayList<HistoricalObjectChangeVersion>();
        for (HollowHistoricalState historicalState : history.getHistoricalStates()) {
            HollowHistoricalStateTypeKeyOrdinalMapping typeMapping = historicalState.getKeyOrdinalMapping().getTypeMapping(type);
            if (typeMapping == null || typeMapping.findAddedOrdinal(keyOrdinal) == -1 && typeMapping.findRemovedOrdinal(keyOrdinal) == -1) continue;
            changeVersions.add(new HistoricalObjectChangeVersion(historicalState.getVersion(), VersionTimestampConverter.getTimestamp(historicalState.getVersion(), this.ui.getTimeZone())));
        }
        return changeVersions;
    }
}

