/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.diffview.HollowDiffView;
import com.netflix.hollow.diffview.HollowDiffViewRow;
import com.netflix.hollow.diffview.HollowObjectDiffViewGenerator;
import com.netflix.hollow.diffview.HollowObjectViewProvider;
import com.netflix.hollow.ui.HollowUISession;
import javax.servlet.http.HttpServletRequest;

public class HollowDiffViewProvider
implements HollowObjectViewProvider {
    private final HollowDiffUI diffUI;

    public HollowDiffViewProvider(HollowDiffUI diffUI) {
        this.diffUI = diffUI;
    }

    @Override
    public HollowDiffView getObjectView(HttpServletRequest req, HollowUISession session) {
        String type = req.getParameter("type");
        int fromOrdinal = Integer.parseInt(req.getParameter("fromOrdinal"));
        int toOrdinal = Integer.parseInt(req.getParameter("toOrdinal"));
        HollowDiffView objectView = this.getObjectView(session, type, fromOrdinal, toOrdinal);
        return objectView;
    }

    private HollowDiffView getObjectView(HollowUISession session, String type, int fromOrdinal, int toOrdinal) {
        HollowDiffView objectView = (HollowDiffView)session.getAttribute("hollow-diff-view");
        if (objectView != null && objectView.getType().equals(type) && objectView.getToOrdinal() == toOrdinal && objectView.getFromOrdinal() == fromOrdinal) {
            return objectView;
        }
        HollowDiffViewRow rootRow = new HollowObjectDiffViewGenerator((HollowDataAccess)this.diffUI.getDiff().getFromStateEngine(), (HollowDataAccess)this.diffUI.getDiff().getToStateEngine(), this.diffUI, type, fromOrdinal, toOrdinal).getHollowDiffViewRows();
        objectView = new HollowDiffView(type, fromOrdinal, toOrdinal, rootRow, this.diffUI.getExactRecordMatcher());
        objectView.resetView();
        session.setAttribute("hollow-diff-view", (Object)objectView);
        return objectView;
    }
}

