/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview.effigy;

import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.diffview.effigy.HollowEffigyFactory;
import java.util.ArrayList;
import java.util.List;

public class HollowEffigy {
    private final HollowEffigyFactory factory;
    private final String objectType;
    final HollowTypeDataAccess dataAccess;
    final int ordinal;
    private List<Field> fields;

    public HollowEffigy(String objectType) {
        this.factory = null;
        this.objectType = objectType;
        this.dataAccess = null;
        this.ordinal = -1;
        this.fields = new ArrayList<Field>();
    }

    public HollowEffigy(HollowEffigyFactory factory, HollowTypeDataAccess dataAccess, int ordinal) {
        this.factory = factory;
        this.objectType = null;
        this.dataAccess = dataAccess;
        this.ordinal = ordinal;
    }

    public void add(Field field) {
        this.fields.add(field);
    }

    public String getObjectType() {
        if (this.objectType != null) {
            return this.objectType;
        }
        return this.dataAccess.getSchema().getName();
    }

    public HollowTypeDataAccess getDataAccess() {
        return this.dataAccess;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public List<Field> getFields() {
        if (this.fields == null) {
            this.fields = this.factory.createFields(this);
        }
        return this.fields;
    }

    public static enum CollectionType {
        NONE,
        MAP,
        COLLECTION;

    }

    public static class Field {
        private final String fieldName;
        private final String typeName;
        private final Object value;
        private final int hashCode;

        public Field(String fieldName, HollowEffigy value) {
            this(fieldName, value.getObjectType(), value);
        }

        public Field(String fieldName, String typeName, Object value) {
            this.fieldName = fieldName;
            this.typeName = typeName;
            this.value = value;
            this.hashCode = 31 * (31 * (fieldName == null ? 0 : fieldName.hashCode()) + typeName.hashCode()) + (value == null ? 0 : value.hashCode());
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isLeafNode() {
            return !(this.value instanceof HollowEffigy);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Field && this.fieldName.equals(((Field)other).fieldName) && this.typeName.equals(((Field)other).typeName)) {
                if (this.value == null) {
                    return ((Field)other).value == null;
                }
                return this.value.equals(((Field)other).value);
            }
            return false;
        }
    }
}

