/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui.pages;

import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.diff.ui.model.HollowDiffUIBreadcrumbs;
import com.netflix.hollow.diff.ui.model.HollowObjectPairDiffScore;
import com.netflix.hollow.diff.ui.pages.DiffPage;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.tools.diff.count.HollowFieldDiff;
import com.netflix.hollow.ui.HollowUISession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;

public class DiffFieldPage
extends DiffPage {
    public DiffFieldPage(HollowDiffUI diffUI) {
        super(diffUI, "diff-field.vm");
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        String typeName = req.getParameter("type");
        HollowTypeDiff typeDiff = this.getTypeDiff(typeName);
        int fieldIdx = Integer.parseInt(req.getParameter("fieldIdx"));
        HollowFieldDiff fieldDiff = (HollowFieldDiff)typeDiff.getFieldDiffs().get(fieldIdx);
        String sessionPageCtx = typeName + ":" + fieldIdx;
        int diffPairBeginIdx = this.intParam(req, session, sessionPageCtx, "diffPairBeginIdx", 0);
        int diffPairPageSize = this.intParam(req, session, sessionPageCtx, "diffPairPageSize", 25);
        List<HollowObjectPairDiffScore> pairs = this.getObjectDiffScores(typeDiff, fieldDiff, diffPairBeginIdx, diffPairPageSize);
        ctx.put("objectScorePairs", pairs);
        ctx.put("typeDiff", (Object)typeDiff);
        ctx.put("fieldDiff", (Object)fieldDiff);
        ctx.put("fieldIdx", (Object)fieldIdx);
        if (diffPairBeginIdx > 0) {
            ctx.put("previousDiffPairPageBeginIdx", (Object)(diffPairBeginIdx - diffPairPageSize));
        }
        if (diffPairBeginIdx + diffPairPageSize < fieldDiff.getNumDiffs()) {
            ctx.put("nextDiffPairPageBeginIdx", (Object)(diffPairBeginIdx + diffPairPageSize));
        }
        ctx.put("breadcrumbs", this.getBreadcrumbs(typeDiff, fieldDiff));
    }

    private List<HollowObjectPairDiffScore> getObjectDiffScores(HollowTypeDiff typeDiff, HollowFieldDiff fieldDiff, int beginRecord, int pageSize) {
        ArrayList<HollowObjectPairDiffScore> list = new ArrayList<HollowObjectPairDiffScore>();
        for (int i = 0; i < fieldDiff.getNumDiffs(); ++i) {
            int fromOrdinal = fieldDiff.getFromOrdinal(i);
            int toOrdinal = fieldDiff.getToOrdinal(i);
            String displayKey = typeDiff.getMatcher().getKeyDisplayString(typeDiff.getFromTypeState(), fieldDiff.getFromOrdinal(i));
            list.add(new HollowObjectPairDiffScore(displayKey, fromOrdinal, toOrdinal, fieldDiff.getPairScore(i)));
        }
        Collections.sort(list);
        return list.subList(beginRecord, beginRecord + pageSize > list.size() ? list.size() : beginRecord + pageSize);
    }

    private List<HollowDiffUIBreadcrumbs> getBreadcrumbs(HollowTypeDiff typeDiff, HollowFieldDiff fieldDiff) {
        ArrayList<HollowDiffUIBreadcrumbs> breadcrumbs = new ArrayList<HollowDiffUIBreadcrumbs>();
        breadcrumbs.add(new HollowDiffUIBreadcrumbs(this.diffUI.getDiffUIPath(), "Overview"));
        breadcrumbs.add(new HollowDiffUIBreadcrumbs(this.diffUI.getDiffUIPath() + "/typediff?type=" + typeDiff.getTypeName(), typeDiff.getTypeName()));
        breadcrumbs.add(new HollowDiffUIBreadcrumbs(null, fieldDiff.getFieldIdentifier().toString()));
        return breadcrumbs;
    }
}

