/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.pages;

import com.netflix.hollow.diff.ui.model.HollowHeaderEntry;
import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.history.ui.pages.HistoryOverviewPage;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.ui.HollowUISession;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public abstract class HistoryPage {
    protected final HollowHistoryUI ui;
    protected final Template template;
    protected final Template headerTemplate;
    protected final Template footerTemplate;

    public HistoryPage(HollowHistoryUI ui, String templateName) {
        this.ui = ui;
        this.template = ui.getVelocityEngine().getTemplate(templateName);
        this.headerTemplate = ui.getVelocityEngine().getTemplate("history-header.vm");
        this.footerTemplate = ui.getVelocityEngine().getTemplate("history-footer.vm");
    }

    public void render(HttpServletRequest req, HollowUISession session, Writer writer) {
        VelocityContext ctx = new VelocityContext();
        ctx.put("showHomeLink", (Object)(!(this instanceof HistoryOverviewPage) ? 1 : 0));
        ctx.put("basePath", (Object)this.ui.getBaseURLPath());
        this.setUpContext(req, session, ctx);
        if (this.includeHeaderAndFooter()) {
            this.headerTemplate.merge((Context)ctx, writer);
        }
        this.template.merge((Context)ctx, writer);
        if (this.includeHeaderAndFooter()) {
            this.footerTemplate.merge((Context)ctx, writer);
        }
    }

    protected abstract void setUpContext(HttpServletRequest var1, HollowUISession var2, VelocityContext var3);

    protected List<HollowHeaderEntry> getHeaderEntries(HollowHistoricalState state) {
        Map fromTags = state.getHeaderEntries();
        Map toTags = this.ui.getHistory().getLatestState().getHeaderTags();
        if (state.getNextState() != null) {
            toTags = state.getNextState().getHeaderEntries();
        }
        HashSet allKeys = new HashSet();
        allKeys.addAll(fromTags.keySet());
        allKeys.addAll(toTags.keySet());
        ArrayList<HollowHeaderEntry> entries = new ArrayList<HollowHeaderEntry>();
        int i = 0;
        for (String key : allKeys) {
            entries.add(new HollowHeaderEntry(i++, key, (String)fromTags.get(key), (String)toTags.get(key)));
        }
        return entries;
    }

    protected boolean includeHeaderAndFooter() {
        return true;
    }
}

