/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.diffview.DiffViewOutputGenerator;
import com.netflix.hollow.diffview.HollowDiffViewRow;
import com.netflix.hollow.diffview.HollowObjectView;
import java.io.IOException;
import java.io.StringWriter;

public class HollowDiffHtmlKickstarter {
    private final String baseURL;

    public HollowDiffHtmlKickstarter(String baseURL) {
        this.baseURL = baseURL;
    }

    public String initialHtmlRows(HollowObjectView objectView) {
        String diffViewOutput = null;
        try {
            StringWriter writer = new StringWriter();
            DiffViewOutputGenerator.buildChildRowDisplayData(objectView.getRootRow(), writer);
            diffViewOutput = writer.toString();
        }
        catch (IOException unexpected) {
            throw new RuntimeException(unexpected);
        }
        StringBuilder initialHtml = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(diffViewOutput);
        while (tokenizer.hasMoreTokens()) {
            String rowPath = tokenizer.nextToken();
            HollowDiffViewRow.Action action = HollowDiffViewRow.Action.valueOf(tokenizer.nextToken());
            String origFromIndexValue = tokenizer.nextToken();
            String fromCellClassname = tokenizer.nextToken();
            String fromCellContent = tokenizer.nextToken();
            String origToIndexValue = tokenizer.nextToken();
            String toCellClassname = tokenizer.nextToken();
            String toCellContent = tokenizer.nextToken();
            initialHtml.append("<tr id=\"r").append(rowPath).append("\"");
            if (action == HollowDiffViewRow.Action.PARTIAL_UNCOLLAPSE || action == HollowDiffViewRow.Action.UNCOLLAPSE) {
                initialHtml.append(" onclick=\"uncollapseRow('" + rowPath + "')\"");
            } else if (action == HollowDiffViewRow.Action.COLLAPSE) {
                initialHtml.append(" onclick=\"collapseRow('" + rowPath + "')\"");
            }
            initialHtml.append(">");
            if (action == HollowDiffViewRow.Action.PARTIAL_UNCOLLAPSE) {
                initialHtml.append("<td class=\"margin\">").append("<img src=\"" + this.baseURL + "/resource/partial_expand.png\"/>").append("</td>");
            } else if (action == HollowDiffViewRow.Action.UNCOLLAPSE) {
                initialHtml.append("<td class=\"margin\">").append("<img src=\"" + this.baseURL + "/resource/expand.png\"/>").append("</td>");
            } else if (action == HollowDiffViewRow.Action.COLLAPSE) {
                initialHtml.append("<td class=\"margin\">").append("<img src=\"" + this.baseURL + "/resource/collapse.png\"/>").append("</td>");
            } else {
                initialHtml.append("<td class=\"margin\"/>");
            }
            if (!"".equals(origFromIndexValue)) {
                initialHtml.append("<td class=\"margin\">").append(origFromIndexValue).append("</td>");
            } else {
                initialHtml.append("<td class=\"margin\"/>");
            }
            initialHtml.append("<td class=\"").append(fromCellClassname).append("\">").append(fromCellContent).append("</td>");
            if (action == HollowDiffViewRow.Action.PARTIAL_UNCOLLAPSE) {
                initialHtml.append("<td class=\"margin\">").append("<img src=\"" + this.baseURL + "/resource/partial_expand.png\"/>").append("</td>");
            } else if (action == HollowDiffViewRow.Action.UNCOLLAPSE) {
                initialHtml.append("<td class=\"margin\">").append("<img src=\"" + this.baseURL + "/resource/expand.png\"/>").append("</td>");
            } else if (action == HollowDiffViewRow.Action.COLLAPSE) {
                initialHtml.append("<td class=\"margin\">").append("<img src=\"" + this.baseURL + "/resource/collapse.png\"/>").append("</td>");
            } else {
                initialHtml.append("<td class=\"margin\"/>");
            }
            if (!"".equals(origToIndexValue)) {
                initialHtml.append("<td class=\"margin\">").append(origToIndexValue).append("</td>");
            } else {
                initialHtml.append("<td class=\"margin\"/>");
            }
            initialHtml.append("<td class=\"").append(toCellClassname).append("\">").append(toCellContent).append("</td>");
        }
        return initialHtml.toString();
    }

    private static class StringTokenizer {
        private final String str;
        private int cursor;

        public StringTokenizer(String str) {
            this.str = str;
        }

        public String nextToken() {
            String token;
            int endIdx = this.str.indexOf(124, this.cursor);
            if (endIdx != -1) {
                token = this.str.substring(this.cursor, endIdx);
                this.cursor = endIdx + 1;
            } else {
                token = this.str.substring(this.cursor);
                this.cursor = -1;
            }
            return token;
        }

        public boolean hasMoreTokens() {
            return this.str.length() > 0 && this.cursor >= 0;
        }
    }
}

