/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.diffview.HollowDiffViewRow;
import com.netflix.hollow.diffview.HollowObjectView;
import com.netflix.hollow.diffview.HollowObjectViewProvider;
import com.netflix.hollow.ui.HollowUISession;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DiffViewOutputGenerator {
    private final HollowObjectViewProvider viewProvider;

    public DiffViewOutputGenerator(HollowObjectViewProvider viewProvider) {
        this.viewProvider = viewProvider;
    }

    public void collapseRow(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HollowDiffViewRow row = this.findRow(req, resp);
        for (HollowDiffViewRow child : row.getChildren()) {
            child.setVisibility(false);
        }
        resp.getWriter().write("ok");
    }

    public void uncollapseRow(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HollowDiffViewRow row = this.findRow(req, resp);
        for (HollowDiffViewRow child : row.getChildren()) {
            child.setVisibility(true);
        }
        DiffViewOutputGenerator.buildChildRowDisplayData(row, resp.getWriter());
    }

    private HollowDiffViewRow findRow(HttpServletRequest req, HttpServletResponse resp) {
        HollowUISession session = HollowUISession.getSession((HttpServletRequest)req, (HttpServletResponse)resp);
        HollowObjectView objectView = this.viewProvider.getObjectView(req, session);
        int[] rowPath = this.getRowPath(req.getParameter("row"));
        HollowDiffViewRow row = objectView.getRootRow();
        for (int i = 0; i < rowPath.length; ++i) {
            row = row.getChildren().get(rowPath[i]);
        }
        return row;
    }

    private int[] getRowPath(String rowPathStr) {
        String[] rowPathElementStrings = rowPathStr.split("\\.");
        int[] rowPath = new int[rowPathElementStrings.length];
        for (int i = 0; i < rowPathElementStrings.length; ++i) {
            rowPath[i] = Integer.parseInt(rowPathElementStrings[i]);
        }
        return rowPath;
    }

    public static void buildChildRowDisplayData(HollowDiffViewRow parentRow, Writer writer) throws IOException {
        DiffViewOutputGenerator.buildChildRowDisplayData(parentRow, writer, true);
    }

    private static void buildChildRowDisplayData(HollowDiffViewRow parentRow, Writer writer, boolean firstRow) throws IOException {
        for (HollowDiffViewRow row : parentRow.getChildren()) {
            if (!row.isVisible()) continue;
            if (firstRow) {
                firstRow = false;
            } else {
                writer.write("|");
            }
            DiffViewOutputGenerator.writeRowPathString(row, writer);
            writer.write("|");
            writer.write(row.getAvailableAction().toString());
            writer.write("|");
            writer.write(DiffViewOutputGenerator.marginIdx(row.getFieldPair().getFromIdx()));
            writer.write("|");
            writer.write(DiffViewOutputGenerator.fromCellClassname(row));
            writer.write("|");
            writer.write(DiffViewOutputGenerator.fromContent(row));
            writer.write("|");
            writer.write(DiffViewOutputGenerator.marginIdx(row.getFieldPair().getToIdx()));
            writer.write("|");
            writer.write(DiffViewOutputGenerator.toCellClassname(row));
            writer.write("|");
            writer.write(DiffViewOutputGenerator.toContent(row));
            DiffViewOutputGenerator.buildChildRowDisplayData(row, writer, false);
        }
    }

    private static void writeRowPathString(HollowDiffViewRow row, Writer writer) throws IOException {
        for (int i = 0; i < row.getRowPath().length; ++i) {
            if (i > 0) {
                writer.write(46);
            }
            writer.write(String.valueOf(row.getRowPath()[i]));
        }
    }

    private static String marginIdx(int idx) {
        if (idx == -1) {
            return "";
        }
        return String.valueOf(idx);
    }

    private static String fromCellClassname(HollowDiffViewRow currentRow) {
        if (currentRow.getFieldPair().getTo() == null) {
            return "delete";
        }
        if (currentRow.getFieldPair().getFrom() == null) {
            return "empty";
        }
        if (currentRow.getFieldPair().getFrom().getValue() == null && currentRow.getFieldPair().getTo().getValue() != null) {
            return "replace";
        }
        if (currentRow.getFieldPair().getFrom().getValue() != null && currentRow.getFieldPair().getTo().getValue() == null) {
            return "replace";
        }
        if (currentRow.getFieldPair().getFrom().getValue() == null && currentRow.getFieldPair().getTo().getValue() == null) {
            return "equal";
        }
        if (currentRow.getFieldPair().isLeafNode() && !currentRow.getFieldPair().getFrom().getValue().equals(currentRow.getFieldPair().getTo().getValue())) {
            return "replace";
        }
        return "equal";
    }

    private static String toCellClassname(HollowDiffViewRow currentRow) {
        if (currentRow.getFieldPair().getFrom() == null) {
            return "insert";
        }
        if (currentRow.getFieldPair().getTo() == null) {
            return "empty";
        }
        if (currentRow.getFieldPair().getFrom().getValue() == null && currentRow.getFieldPair().getTo().getValue() != null) {
            return "replace";
        }
        if (currentRow.getFieldPair().getFrom().getValue() != null && currentRow.getFieldPair().getTo().getValue() == null) {
            return "replace";
        }
        if (currentRow.getFieldPair().getFrom().getValue() == null && currentRow.getFieldPair().getTo().getValue() == null) {
            return "equal";
        }
        if (currentRow.getFieldPair().isLeafNode() && !currentRow.getFieldPair().getFrom().getValue().equals(currentRow.getFieldPair().getTo().getValue())) {
            return "replace";
        }
        return "equal";
    }

    private static String fromContent(HollowDiffViewRow row) {
        boolean[] moreRows = new boolean[row.getIndentation() + 1];
        for (int i = 0; i <= row.getIndentation(); ++i) {
            moreRows[i] = row.hasMoreFromRows(i);
        }
        if (row.getFieldPair().getFrom() == null) {
            return DiffViewOutputGenerator.unpopulatedContent(moreRows);
        }
        String fieldName = row.getFieldPair().getFrom().getFieldName();
        String fieldValue = row.getFieldPair().isLeafNode() ? (row.getFieldPair().getFrom().getValue() == null ? "null" : row.getFieldPair().getFrom().getValue().toString().replace("|", "&#x2502")) : "(" + row.getFieldPair().getFrom().getTypeName() + ")";
        return DiffViewOutputGenerator.populatedContent(moreRows, row.getIndentation(), row.getFieldPair().isLeafNode(), fieldName, fieldValue);
    }

    private static String toContent(HollowDiffViewRow row) {
        boolean[] moreRows = new boolean[row.getIndentation() + 1];
        for (int i = 0; i <= row.getIndentation(); ++i) {
            moreRows[i] = row.hasMoreToRows(i);
        }
        if (row.getFieldPair().getTo() == null) {
            return DiffViewOutputGenerator.unpopulatedContent(moreRows);
        }
        String fieldName = row.getFieldPair().getTo().getFieldName();
        String fieldValue = row.getFieldPair().isLeafNode() ? (row.getFieldPair().getTo().getValue() == null ? "null" : row.getFieldPair().getTo().getValue().toString().replace("|", "&#x2502")) : "(" + row.getFieldPair().getTo().getTypeName() + ")";
        return DiffViewOutputGenerator.populatedContent(moreRows, row.getIndentation(), row.getFieldPair().isLeafNode(), fieldName, fieldValue);
    }

    private static String unpopulatedContent(boolean[] moreRows) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < moreRows.length; ++i) {
            if (moreRows[i]) {
                builder.append(" &#x2502;");
                continue;
            }
            builder.append("  ");
        }
        return builder.toString();
    }

    private static String populatedContent(boolean[] moreRows, int indentation, boolean leafNode, String fieldName, String value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indentation; ++i) {
            if (moreRows[i]) {
                builder.append(".&#x2502;");
                continue;
            }
            builder.append("..");
        }
        if (!leafNode) {
            if (moreRows[indentation]) {
                builder.append(".&#x251D;&#x2501;&#x252F;&#x2501;&gt;");
            } else {
                builder.append(".&#x2515;&#x2501;&#x252F;&#x2501;&gt;");
            }
        } else if (moreRows[indentation]) {
            builder.append(".&#x251C;&#x2500;&#x2500;&#x2500;&gt;");
        } else {
            builder.append(".&#x2514;&#x2500;&#x2500;&#x2500;&gt;");
        }
        if (fieldName != null) {
            builder.append(fieldName).append(": ");
        }
        builder.append(value);
        return builder.toString();
    }
}

