/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview.effigy;

import com.netflix.hollow.core.read.dataaccess.HollowCollectionTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.diffview.effigy.HollowEffigy;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class HollowEffigyFactory {
    private final Base64 base64 = new Base64();
    private final Map<HollowEffigy.Field, HollowEffigy.Field> fieldMemoizer = new HashMap<HollowEffigy.Field, HollowEffigy.Field>();
    private final Map<HollowDiffNodeIdentifier, HollowDiffNodeIdentifier> diffNodeIdMemoizer = new HashMap<HollowDiffNodeIdentifier, HollowDiffNodeIdentifier>();

    public HollowEffigy effigy(HollowDataAccess dataAccess, String typeName, int ordinal) {
        return this.effigy(dataAccess, typeName, ordinal, this.memoize(new HollowDiffNodeIdentifier(typeName)));
    }

    private HollowEffigy effigy(HollowDataAccess dataAccess, String typeName, int ordinal, HollowDiffNodeIdentifier identifier) {
        if (ordinal == -1) {
            return null;
        }
        HollowTypeDataAccess typeState = dataAccess.getTypeDataAccess(typeName, ordinal);
        if (typeState == null) {
            return null;
        }
        if (typeState instanceof HollowObjectTypeDataAccess) {
            return this.objectEffigy((HollowObjectTypeDataAccess)typeState, ordinal, identifier);
        }
        if (typeState instanceof HollowCollectionTypeDataAccess) {
            return this.collectionEffigy((HollowCollectionTypeDataAccess)typeState, ordinal, identifier);
        }
        if (typeState instanceof HollowMapTypeDataAccess) {
            return this.mapEffigy((HollowMapTypeDataAccess)typeState, ordinal, identifier);
        }
        throw new IllegalArgumentException("I don't know how to effigize a " + typeState.getClass());
    }

    private HollowEffigy objectEffigy(HollowObjectTypeDataAccess typeDataAccess, int ordinal, HollowDiffNodeIdentifier identifier) {
        HollowObjectSchema schema = typeDataAccess.getSchema();
        HollowEffigy effigy = new HollowEffigy(schema.getName());
        for (int i = 0; i < schema.numFields(); ++i) {
            String fieldName = schema.getFieldName(i);
            String fieldType = schema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE ? schema.getReferencedType(i) : schema.getFieldType(i).toString();
            HollowDiffNodeIdentifier fieldIdentifier = this.memoize(new HollowDiffNodeIdentifier(identifier, fieldName, fieldType));
            Object fieldValue = null;
            switch (schema.getFieldType(i)) {
                case BOOLEAN: {
                    fieldValue = typeDataAccess.readBoolean(ordinal, i);
                    break;
                }
                case BYTES: {
                    fieldValue = this.base64.encodeToString(typeDataAccess.readBytes(ordinal, i));
                    break;
                }
                case DOUBLE: {
                    fieldValue = typeDataAccess.readDouble(ordinal, i);
                    break;
                }
                case FLOAT: {
                    fieldValue = Float.valueOf(typeDataAccess.readFloat(ordinal, i));
                    break;
                }
                case INT: {
                    fieldValue = typeDataAccess.readInt(ordinal, i);
                    break;
                }
                case LONG: {
                    long longVal = typeDataAccess.readLong(ordinal, i);
                    if (longVal != Long.MIN_VALUE && "Date".equals(typeDataAccess.getSchema().getName())) {
                        fieldValue = new Date(longVal).toString();
                        break;
                    }
                    fieldValue = typeDataAccess.readLong(ordinal, i);
                    break;
                }
                case STRING: {
                    fieldValue = typeDataAccess.readString(ordinal, i);
                    break;
                }
                case REFERENCE: {
                    fieldValue = this.effigy(typeDataAccess.getDataAccess(), schema.getReferencedType(i), typeDataAccess.readOrdinal(ordinal, i), fieldIdentifier);
                }
            }
            if (schema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE) {
                effigy.add(new HollowEffigy.Field(fieldIdentifier, fieldValue));
                continue;
            }
            effigy.add(this.memoize(new HollowEffigy.Field(fieldIdentifier, fieldValue)));
        }
        return effigy;
    }

    private HollowEffigy collectionEffigy(HollowCollectionTypeDataAccess typeDataAccess, int ordinal, HollowDiffNodeIdentifier identifier) {
        HollowCollectionSchema schema = typeDataAccess.getSchema();
        HollowDiffNodeIdentifier elementFieldIdentifier = this.memoize(new HollowDiffNodeIdentifier(identifier, "element", schema.getElementType()));
        HollowEffigy effigy = new HollowEffigy(schema.getName(), HollowEffigy.CollectionType.COLLECTION);
        HollowOrdinalIterator iter = typeDataAccess.ordinalIterator(ordinal);
        int elementOrdinal = iter.next();
        while (elementOrdinal != Integer.MAX_VALUE) {
            HollowEffigy elementEffigy = this.effigy(typeDataAccess.getDataAccess(), schema.getElementType(), elementOrdinal, elementFieldIdentifier);
            effigy.add(new HollowEffigy.Field(elementFieldIdentifier, elementEffigy));
            elementOrdinal = iter.next();
        }
        return effigy;
    }

    private HollowEffigy mapEffigy(HollowMapTypeDataAccess typeDataAccess, int ordinal, HollowDiffNodeIdentifier identifier) {
        HollowMapSchema schema = typeDataAccess.getSchema();
        HollowDiffNodeIdentifier entryFieldIdentifier = this.memoize(new HollowDiffNodeIdentifier(identifier, "entry", "Map.Entry"));
        HollowDiffNodeIdentifier keyFieldIdentifier = this.memoize(new HollowDiffNodeIdentifier(identifier, "key", schema.getKeyType()));
        HollowDiffNodeIdentifier valueFieldIdentifier = this.memoize(new HollowDiffNodeIdentifier(identifier, "value", schema.getValueType()));
        HollowEffigy effigy = new HollowEffigy(schema.getName(), HollowEffigy.CollectionType.MAP);
        HollowMapEntryOrdinalIterator iter = typeDataAccess.ordinalIterator(ordinal);
        while (iter.next()) {
            HollowEffigy entryEffigy = new HollowEffigy("Map.Entry");
            entryEffigy.add(new HollowEffigy.Field(keyFieldIdentifier, this.effigy(typeDataAccess.getDataAccess(), schema.getKeyType(), iter.getKey(), keyFieldIdentifier)));
            entryEffigy.add(new HollowEffigy.Field(valueFieldIdentifier, this.effigy(typeDataAccess.getDataAccess(), schema.getValueType(), iter.getValue(), valueFieldIdentifier)));
            effigy.add(new HollowEffigy.Field(entryFieldIdentifier, entryEffigy));
        }
        return effigy;
    }

    private HollowDiffNodeIdentifier memoize(HollowDiffNodeIdentifier fieldId) {
        HollowDiffNodeIdentifier canonical = this.diffNodeIdMemoizer.get(fieldId);
        if (canonical == null) {
            this.diffNodeIdMemoizer.put(fieldId, fieldId);
            canonical = fieldId;
        }
        return canonical;
    }

    private HollowEffigy.Field memoize(HollowEffigy.Field field) {
        HollowEffigy.Field canonical = this.fieldMemoizer.get(field);
        if (canonical == null) {
            this.fieldMemoizer.put(field, field);
            canonical = field;
        }
        return canonical;
    }
}

