/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.diffview.DiffViewOutputGenerator;
import com.netflix.hollow.diffview.HollowHistoryViewProvider;
import com.netflix.hollow.diffview.HollowObjectViewProvider;
import com.netflix.hollow.diffview.effigy.CustomHollowEffigyFactory;
import com.netflix.hollow.diffview.effigy.HollowRecordDiffUI;
import com.netflix.hollow.diffview.effigy.pairer.exact.ExactRecordMatcher;
import com.netflix.hollow.diffview.effigy.pairer.exact.HistoryExactRecordMatcher;
import com.netflix.hollow.history.ui.HollowHistoryRefreshListener;
import com.netflix.hollow.history.ui.naming.HollowHistoryRecordNamer;
import com.netflix.hollow.history.ui.pages.HistoricalObjectDiffPage;
import com.netflix.hollow.history.ui.pages.HistoryOverviewPage;
import com.netflix.hollow.history.ui.pages.HistoryQueryPage;
import com.netflix.hollow.history.ui.pages.HistoryStatePage;
import com.netflix.hollow.history.ui.pages.HistoryStateTypeExpandGroupPage;
import com.netflix.hollow.history.ui.pages.HistoryStateTypePage;
import com.netflix.hollow.tools.history.HollowHistory;
import com.netflix.hollow.ui.HollowUIRouter;
import com.netflix.hollow.ui.HollowUISession;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HollowHistoryUI
extends HollowUIRouter
implements HollowRecordDiffUI {
    private final HollowHistory history;
    private final HistoryOverviewPage overviewPage;
    private final HistoryStatePage statePage;
    private final HistoryStateTypePage stateTypePage;
    private final HistoryStateTypeExpandGroupPage stateTypeExpandPage;
    private final HistoryQueryPage queryPage;
    private final HistoricalObjectDiffPage objectDiffPage;
    private final HollowObjectViewProvider viewProvider;
    private final DiffViewOutputGenerator diffViewOutputGenerator;
    private final Map<String, CustomHollowEffigyFactory> customHollowEffigyFactories;
    private final Map<String, HollowHistoryRecordNamer> customHollowRecordNamers;
    private final Map<String, PrimaryKey> matchHints;
    private String[] overviewDisplayHeaders;

    public HollowHistoryUI(String baseUrlPath, HollowConsumer consumer) {
        this(baseUrlPath, consumer, 1024);
    }

    public HollowHistoryUI(String baseUrlPath, HollowConsumer consumer, int numStatesToTrack) {
        this(baseUrlPath, HollowHistoryUI.createHistory(consumer, numStatesToTrack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HollowHistory createHistory(HollowConsumer consumer, int numStatesToTrack) {
        consumer.getRefreshLock().lock();
        try {
            HollowHistory history = new HollowHistory(consumer.getStateEngine(), consumer.getCurrentVersionId(), numStatesToTrack);
            consumer.addRefreshListener((HollowConsumer.RefreshListener)new HollowHistoryRefreshListener(history));
            HollowHistory hollowHistory = history;
            return hollowHistory;
        }
        finally {
            consumer.getRefreshLock().unlock();
        }
    }

    public HollowHistoryUI(String baseUrlPath, HollowHistory history) {
        super(baseUrlPath);
        this.history = history;
        this.overviewPage = new HistoryOverviewPage(this);
        this.statePage = new HistoryStatePage(this);
        this.queryPage = new HistoryQueryPage(this);
        this.objectDiffPage = new HistoricalObjectDiffPage(this);
        this.stateTypePage = new HistoryStateTypePage(this);
        this.stateTypeExpandPage = new HistoryStateTypeExpandGroupPage(this);
        this.viewProvider = new HollowHistoryViewProvider(this);
        this.diffViewOutputGenerator = new DiffViewOutputGenerator(this.viewProvider);
        this.customHollowEffigyFactories = new HashMap<String, CustomHollowEffigyFactory>();
        this.customHollowRecordNamers = new HashMap<String, HollowHistoryRecordNamer>();
        this.matchHints = new HashMap<String, PrimaryKey>();
        this.overviewDisplayHeaders = new String[0];
    }

    public HollowHistory getHistory() {
        return this.history;
    }

    public boolean handle(String target, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pageName = this.getTargetRootPath(target);
        if ("diffrowdata".equals(pageName)) {
            this.diffViewOutputGenerator.uncollapseRow(req, resp);
            return true;
        }
        if ("collapsediffrow".equals(pageName)) {
            this.diffViewOutputGenerator.collapseRow(req, resp);
            return true;
        }
        resp.setContentType("text/html");
        if ("resource".equals(pageName)) {
            if (this.serveResource(req, resp, this.getResourceName(target))) {
                return true;
            }
        } else {
            if ("".equals(pageName) || "overview".equals(pageName)) {
                if (req.getParameter("format") != null && req.getParameter("format").equals("json")) {
                    this.overviewPage.sendJson(req, resp);
                    return true;
                }
                this.overviewPage.render(req, HollowUISession.getSession((HttpServletRequest)req, (HttpServletResponse)resp), resp.getWriter());
                return true;
            }
            if ("state".equals(pageName)) {
                if (req.getParameter("format") != null && req.getParameter("format").equals("json")) {
                    this.statePage.sendJson(req, resp);
                    return true;
                }
                this.statePage.render(req, HollowUISession.getSession((HttpServletRequest)req, (HttpServletResponse)resp), resp.getWriter());
                return true;
            }
            if ("statetype".equals(pageName)) {
                if (req.getParameter("format") != null && req.getParameter("format").equals("json")) {
                    this.stateTypePage.sendJson(req, HollowUISession.getSession((HttpServletRequest)req, (HttpServletResponse)resp), resp);
                    return true;
                }
                this.stateTypePage.render(req, HollowUISession.getSession((HttpServletRequest)req, (HttpServletResponse)resp), resp.getWriter());
                return true;
            }
            if ("statetypeexpand".equals(pageName)) {
                this.stateTypeExpandPage.render(req, HollowUISession.getSession((HttpServletRequest)req, (HttpServletResponse)resp), resp.getWriter());
                return true;
            }
            if ("query".equals(pageName)) {
                this.queryPage.render(req, HollowUISession.getSession((HttpServletRequest)req, (HttpServletResponse)resp), resp.getWriter());
                return true;
            }
            if ("historicalObject".equals(pageName)) {
                this.objectDiffPage.render(req, HollowUISession.getSession((HttpServletRequest)req, (HttpServletResponse)resp), resp.getWriter());
                return true;
            }
        }
        return false;
    }

    public void addCustomHollowRecordNamer(String typeName, HollowHistoryRecordNamer recordNamer) {
        this.customHollowRecordNamers.put(typeName, recordNamer);
    }

    public void addCustomHollowEffigyFactory(String typeName, CustomHollowEffigyFactory factory) {
        this.customHollowEffigyFactories.put(typeName, factory);
    }

    @Override
    public CustomHollowEffigyFactory getCustomHollowEffigyFactory(String typeName) {
        return this.customHollowEffigyFactories.get(typeName);
    }

    public void addMatchHint(PrimaryKey matchHint) {
        this.matchHints.put(matchHint.getType(), matchHint);
    }

    @Override
    public Map<String, PrimaryKey> getMatchHints() {
        return this.matchHints;
    }

    @Override
    public ExactRecordMatcher getExactRecordMatcher() {
        return HistoryExactRecordMatcher.INSTANCE;
    }

    public void setOverviewDisplayHeaders(String ... displayHeaders) {
        this.overviewDisplayHeaders = displayHeaders;
    }

    public HollowHistoryRecordNamer getHistoryRecordNamer(String typeName) {
        HollowHistoryRecordNamer recordNamer = this.customHollowRecordNamers.get(typeName);
        if (recordNamer == null) {
            return HollowHistoryRecordNamer.DEFAULT_RECORD_NAMER;
        }
        return recordNamer;
    }

    public String[] getOverviewDisplayHeaders() {
        return this.overviewDisplayHeaders;
    }

    public HollowObjectViewProvider getViewProvider() {
        return this.viewProvider;
    }
}

