/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.pages;

import com.google.gson.Gson;
import com.netflix.hollow.diff.ui.model.HollowHeaderEntry;
import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.history.ui.model.HistoryStateTypeChangeSummary;
import com.netflix.hollow.history.ui.pages.HistoryPage;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateTypeKeyOrdinalMapping;
import com.netflix.hollow.ui.HollowUISession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;

public class HistoryStatePage
extends HistoryPage {
    public HistoryStatePage(HollowHistoryUI ui) {
        super(ui, "history-state.vm");
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        HollowHistoricalState historicalState = this.ui.getHistory().getHistoricalState(Long.parseLong(req.getParameter("version")));
        long nextStateVersion = this.getNextStateVersion(historicalState);
        long prevStateVersion = this.getPreviousStateVersion(historicalState);
        ArrayList<HistoryStateTypeChangeSummary> typeChanges = new ArrayList<HistoryStateTypeChangeSummary>();
        for (Map.Entry entry : historicalState.getKeyOrdinalMapping().getTypeMappings().entrySet()) {
            HistoryStateTypeChangeSummary typeChange = new HistoryStateTypeChangeSummary(historicalState.getVersion(), (String)entry.getKey(), (HollowHistoricalStateTypeKeyOrdinalMapping)entry.getValue());
            if (typeChange.isEmpty()) continue;
            typeChanges.add(typeChange);
        }
        ctx.put("typeChanges", typeChanges);
        ctx.put("headerEntries", this.getHeaderEntries(historicalState));
        ctx.put("currentStateVersion", (Object)historicalState.getVersion());
        ctx.put("nextStateVersion", (Object)nextStateVersion);
        ctx.put("prevStateVersion", (Object)prevStateVersion);
    }

    public void sendJson(HttpServletRequest req, HttpServletResponse resp) {
        HollowHistoricalState historicalState = this.ui.getHistory().getHistoricalState(Long.parseLong(req.getParameter("version")));
        ArrayList<HistoryStateTypeChangeSummary> typeChanges = new ArrayList<HistoryStateTypeChangeSummary>();
        for (Map.Entry entry : historicalState.getKeyOrdinalMapping().getTypeMappings().entrySet()) {
            HistoryStateTypeChangeSummary typeChange = new HistoryStateTypeChangeSummary(historicalState.getVersion(), (String)entry.getKey(), (HollowHistoricalStateTypeKeyOrdinalMapping)entry.getValue());
            if (typeChange.isEmpty()) continue;
            typeChanges.add(typeChange);
        }
        List<HollowHeaderEntry> headerEntries = this.getHeaderEntries(historicalState);
        HashMap<String, String> params = new HashMap<String, String>();
        for (HollowHeaderEntry headerEntry : headerEntries) {
            String key = headerEntry.getKey();
            if (key.equals("VIP")) {
                params.put("fromVip", headerEntry.getFromValue());
                params.put("toVip", headerEntry.getToValue());
            }
            if (!key.equals("dataVersion")) continue;
            params.put("fromVersion", headerEntry.getFromValue());
            params.put("toVersion", headerEntry.getToValue());
        }
        HashMap<String, Cloneable> data = new HashMap<String, Cloneable>();
        data.put("params", params);
        data.put("objectTypes", typeChanges);
        try {
            PrintWriter out = resp.getWriter();
            Gson gson = new Gson();
            String json = gson.toJson(data);
            out.println(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private long getNextStateVersion(HollowHistoricalState currentHistoricalState) {
        if (currentHistoricalState.getNextState() != null) {
            return currentHistoricalState.getNextState().getVersion();
        }
        return -1L;
    }

    private long getPreviousStateVersion(HollowHistoricalState currentHistoricalState) {
        for (HollowHistoricalState state : this.ui.getHistory().getHistoricalStates()) {
            if (state.getNextState() != currentHistoricalState) continue;
            return state.getVersion();
        }
        return -1L;
    }

    @Override
    protected boolean includeHeaderAndFooter() {
        return false;
    }
}

