/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.pages;

import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.history.ui.VersionTimestampConverter;
import com.netflix.hollow.history.ui.model.HistoryStateQueryMatches;
import com.netflix.hollow.history.ui.pages.HistoryPage;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.tools.history.HollowHistory;
import com.netflix.hollow.tools.history.keyindex.HollowHistoryTypeKeyIndex;
import com.netflix.hollow.ui.HollowUISession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;

public class HistoryQueryPage
extends HistoryPage {
    public HistoryQueryPage(HollowHistoryUI ui) {
        super(ui, "history-query.vm");
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        HollowHistory history = this.ui.getHistory();
        String query = req.getParameter("query");
        Map<String, IntList> typeQueryKeyMatches = this.typeQueryKeyMatches(history, query);
        ArrayList<HistoryStateQueryMatches> list = new ArrayList<HistoryStateQueryMatches>();
        for (HollowHistoricalState state : history.getHistoricalStates()) {
            HistoryStateQueryMatches matches = new HistoryStateQueryMatches(state, this.ui, VersionTimestampConverter.getTimestamp(state.getVersion()), typeQueryKeyMatches);
            if (!matches.hasMatches()) continue;
            list.add(matches);
        }
        ctx.put("stateQueryMatchesList", list);
        ctx.put("query", (Object)query);
    }

    private Map<String, IntList> typeQueryKeyMatches(HollowHistory history, String query) {
        HashMap<String, IntList> typeQueryKeyMatches = new HashMap<String, IntList>();
        for (Map.Entry entry : history.getKeyIndex().getTypeKeyIndexes().entrySet()) {
            IntList typeQueryResult = ((HollowHistoryTypeKeyIndex)entry.getValue()).queryIndexedFields(query);
            if (typeQueryResult.size() == 0) continue;
            typeQueryKeyMatches.put((String)entry.getKey(), typeQueryResult);
        }
        return typeQueryKeyMatches;
    }
}

