/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.model;

import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.history.ui.model.RecordDiff;
import com.netflix.hollow.history.ui.naming.HollowHistoryRecordNamer;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateTypeKeyOrdinalMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HistoryStateQueryMatches {
    private final long stateVersion;
    private final String dateDisplayString;
    private final List<TypeMatches> typeMatches;

    public HistoryStateQueryMatches(HollowHistoricalState historicalState, HollowHistoryUI ui, String dateDisplayString, Map<String, IntList> perTypeQueryMatchingKeys) {
        this.stateVersion = historicalState.getVersion();
        this.dateDisplayString = dateDisplayString;
        this.typeMatches = new ArrayList<TypeMatches>(historicalState.getKeyOrdinalMapping().getTypeMappings().size());
        for (Map.Entry<String, IntList> entry : perTypeQueryMatchingKeys.entrySet()) {
            HollowHistoryRecordNamer recordNamer = ui.getHistoryRecordNamer(entry.getKey());
            TypeMatches typeMatches = new TypeMatches(historicalState, recordNamer, entry.getKey(), entry.getValue());
            if (!typeMatches.hasMatches()) continue;
            this.typeMatches.add(typeMatches);
        }
    }

    public boolean hasMatches() {
        return !this.typeMatches.isEmpty();
    }

    public long getStateVersion() {
        return this.stateVersion;
    }

    public String getDateDisplayString() {
        return this.dateDisplayString;
    }

    public List<TypeMatches> getTypeMatches() {
        return this.typeMatches;
    }

    public static class TypeMatches {
        private final String type;
        private final List<RecordDiff> modifiedRecords;
        private final List<RecordDiff> removedRecords;
        private final List<RecordDiff> addedRecords;

        public TypeMatches(HollowHistoricalState historicalState, HollowHistoryRecordNamer recordNamer, String type, IntList queryMatchingKeys) {
            this.type = type;
            this.modifiedRecords = new ArrayList<RecordDiff>();
            this.removedRecords = new ArrayList<RecordDiff>();
            this.addedRecords = new ArrayList<RecordDiff>();
            HollowHistoricalStateTypeKeyOrdinalMapping typeKeyMapping = historicalState.getKeyOrdinalMapping().getTypeMapping(type);
            HollowObjectTypeDataAccess typeDataAccess = (HollowObjectTypeDataAccess)historicalState.getDataAccess().getTypeDataAccess(type);
            for (int i = 0; i < queryMatchingKeys.size(); ++i) {
                int matchingKey = queryMatchingKeys.get(i);
                int removedOrdinal = typeKeyMapping.findRemovedOrdinal(matchingKey);
                int addedOrdinal = typeKeyMapping.findAddedOrdinal(matchingKey);
                if (removedOrdinal != -1 && addedOrdinal != -1) {
                    this.modifiedRecords.add(new RecordDiff(historicalState, recordNamer, typeKeyMapping, typeDataAccess, matchingKey, removedOrdinal, addedOrdinal));
                    continue;
                }
                if (removedOrdinal != -1) {
                    this.removedRecords.add(new RecordDiff(historicalState, recordNamer, typeKeyMapping, typeDataAccess, matchingKey, removedOrdinal, addedOrdinal));
                    continue;
                }
                if (addedOrdinal == -1) continue;
                this.addedRecords.add(new RecordDiff(historicalState, recordNamer, typeKeyMapping, typeDataAccess, matchingKey, removedOrdinal, addedOrdinal));
            }
        }

        public boolean hasMatches() {
            return !this.modifiedRecords.isEmpty() || !this.addedRecords.isEmpty() || !this.removedRecords.isEmpty();
        }

        public String getType() {
            return this.type;
        }

        public List<RecordDiff> getModifiedRecords() {
            return this.modifiedRecords;
        }

        public List<RecordDiff> getAddedRecords() {
            return this.addedRecords;
        }

        public List<RecordDiff> getRemovedRecords() {
            return this.removedRecords;
        }
    }
}

