/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview.effigy.pairer;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.diffview.effigy.HollowEffigy;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyDiffRecord;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyFieldPairer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class HollowEffigyCollectionPairer
extends HollowEffigyFieldPairer {
    static final int MAX_MATRIX_ELEMENT_FIELD_VALUE = 0x1FFFFF;
    private final PrimaryKey matchHint;

    public HollowEffigyCollectionPairer(HollowEffigy fromCollection, HollowEffigy toCollection, PrimaryKey matchHint) {
        super(fromCollection, toCollection);
        this.matchHint = matchHint;
    }

    @Override
    public List<HollowEffigyFieldPairer.EffigyFieldPair> pair() {
        if (this.matchHint != null) {
            return this.pairByMatchHint();
        }
        return this.pairByMinDifference();
    }

    private List<HollowEffigyFieldPairer.EffigyFieldPair> pairByMatchHint() {
        ArrayList<HollowEffigyFieldPairer.EffigyFieldPair> fieldPairs = new ArrayList<HollowEffigyFieldPairer.EffigyFieldPair>();
        if (this.from.getFields().size() == 0) {
            for (int i = 0; i < this.to.getFields().size(); ++i) {
                fieldPairs.add(new HollowEffigyFieldPairer.EffigyFieldPair(null, this.to.getFields().get(i), -1, i));
            }
            return fieldPairs;
        }
        if (this.to.getFields().size() == 0) {
            for (int i = 0; i < this.from.getFields().size(); ++i) {
                fieldPairs.add(new HollowEffigyFieldPairer.EffigyFieldPair(this.from.getFields().get(i), null, i, -1));
            }
        }
        int[][] toFieldPathIndexes = new int[this.matchHint.numFields()][];
        int[][] fromFieldPathIndexes = new int[this.matchHint.numFields()][];
        for (int i = 0; i < this.matchHint.numFields(); ++i) {
            toFieldPathIndexes[i] = this.matchHint.getFieldPathIndex((HollowDataset)this.to.getDataAccess().getDataAccess(), i);
            fromFieldPathIndexes[i] = this.matchHint.getFieldPathIndex((HollowDataset)this.from.getDataAccess().getDataAccess(), i);
        }
        int[] hashedToFieldIndexes = new int[HashCodes.hashTableSize((int)this.to.getFields().size())];
        Arrays.fill(hashedToFieldIndexes, -1);
        int i = 0;
        while (i < this.to.getFields().size()) {
            HollowEffigy comparisonEffigy = this.getComparisonEffigy((HollowEffigy)this.to.getFields().get(i).getValue());
            int hash = this.hashCode(comparisonEffigy, toFieldPathIndexes);
            hash &= hashedToFieldIndexes.length - 1;
            while (hashedToFieldIndexes[hash] != -1) {
                ++hash;
                hash &= hashedToFieldIndexes.length - 1;
            }
            hashedToFieldIndexes[hash] = i++;
        }
        BitSet matchedToElements = new BitSet(this.to.getFields().size());
        BitSet matchedFromElements = new BitSet(this.from.getFields().size());
        for (int i2 = 0; i2 < this.from.getFields().size(); ++i2) {
            HollowEffigy fromEffigy = this.getComparisonEffigy((HollowEffigy)this.from.getFields().get(i2).getValue());
            int hash = this.hashCode(fromEffigy, fromFieldPathIndexes);
            hash &= hashedToFieldIndexes.length - 1;
            while (hashedToFieldIndexes[hash] != -1) {
                HollowEffigy toEffigy;
                int toIdx = hashedToFieldIndexes[hash];
                if (!matchedToElements.get(toIdx) && this.recordsMatch(fromEffigy, toEffigy = this.getComparisonEffigy((HollowEffigy)this.to.getFields().get(toIdx).getValue()), fromFieldPathIndexes, toFieldPathIndexes)) {
                    fieldPairs.add(new HollowEffigyFieldPairer.EffigyFieldPair(this.from.getFields().get(i2), this.to.getFields().get(toIdx), i2, toIdx));
                    matchedFromElements.set(i2);
                    matchedToElements.set(toIdx);
                }
                ++hash;
                hash &= hashedToFieldIndexes.length - 1;
            }
        }
        this.addUnmatchedElements(fieldPairs, matchedFromElements, matchedToElements);
        return fieldPairs;
    }

    private boolean recordsMatch(HollowEffigy fromElement, HollowEffigy toElement, int[][] fromFieldPathIndexes, int[][] toFieldPathIndexes) {
        for (int i = 0; i < fromFieldPathIndexes.length; ++i) {
            if (this.fieldsAreEqual(fromElement, toElement, fromFieldPathIndexes[i], toFieldPathIndexes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean fieldsAreEqual(HollowEffigy fromElement, HollowEffigy toElement, int[] fromFieldPath, int[] toFieldPath) {
        HollowObjectTypeDataAccess fromDataAccess = (HollowObjectTypeDataAccess)fromElement.getDataAccess();
        int fromOrdinal = fromElement.getOrdinal();
        HollowObjectTypeDataAccess toDataAccess = (HollowObjectTypeDataAccess)toElement.getDataAccess();
        int toOrdinal = toElement.getOrdinal();
        HollowObjectSchema fromSchema = fromDataAccess.getSchema();
        HollowObjectSchema toSchema = toDataAccess.getSchema();
        for (int i = 0; i < fromFieldPath.length - 1; ++i) {
            int fromFieldPosition = fromFieldPath[i];
            int toFieldPosition = toFieldPath[i];
            fromOrdinal = fromDataAccess.readOrdinal(fromOrdinal, fromFieldPosition);
            toOrdinal = toDataAccess.readOrdinal(toOrdinal, toFieldPosition);
            fromDataAccess = (HollowObjectTypeDataAccess)fromDataAccess.getDataAccess().getTypeDataAccess(fromSchema.getReferencedType(fromFieldPosition));
            toDataAccess = (HollowObjectTypeDataAccess)toDataAccess.getDataAccess().getTypeDataAccess(toSchema.getReferencedType(toFieldPosition));
            fromSchema = fromDataAccess.getSchema();
            toSchema = toDataAccess.getSchema();
        }
        return HollowReadFieldUtils.fieldsAreEqual((HollowObjectTypeDataAccess)fromDataAccess, (int)fromOrdinal, (int)fromFieldPath[fromFieldPath.length - 1], (HollowObjectTypeDataAccess)toDataAccess, (int)toOrdinal, (int)toFieldPath[toFieldPath.length - 1]);
    }

    private int hashCode(HollowEffigy element, int[][] fieldPathIndexes) {
        int hash = 0;
        for (int i = 0; i < fieldPathIndexes.length; ++i) {
            hash *= 31;
            hash ^= this.fieldHashCode(element, fieldPathIndexes[i]);
        }
        return hash;
    }

    private int fieldHashCode(HollowEffigy element, int[] fieldPath) {
        HollowObjectTypeDataAccess dataAccess = (HollowObjectTypeDataAccess)element.getDataAccess();
        HollowObjectSchema schema = dataAccess.getSchema();
        int ordinal = element.getOrdinal();
        for (int i = 0; i < fieldPath.length - 1; ++i) {
            int fieldPosition = fieldPath[i];
            ordinal = dataAccess.readOrdinal(ordinal, fieldPosition);
            dataAccess = (HollowObjectTypeDataAccess)dataAccess.getDataAccess().getTypeDataAccess(schema.getReferencedType(fieldPosition));
            schema = dataAccess.getSchema();
        }
        int fieldHash = HollowReadFieldUtils.fieldHashCode((HollowObjectTypeDataAccess)dataAccess, (int)ordinal, (int)fieldPath[fieldPath.length - 1]);
        return HashCodes.hashInt((int)fieldHash);
    }

    private List<HollowEffigyFieldPairer.EffigyFieldPair> pairByMinDifference() {
        ArrayList<HollowEffigyFieldPairer.EffigyFieldPair> fieldPairs = new ArrayList<HollowEffigyFieldPairer.EffigyFieldPair>();
        BitSet pairedFromIndices = new BitSet(this.from.getFields().size());
        BitSet pairedToIndices = new BitSet(this.to.getFields().size());
        int[] maxDiffBackoff = new int[]{1, 2, 4, 8, Integer.MAX_VALUE};
        int maxPairs = Math.min(this.from.getFields().size(), this.to.getFields().size());
        block0: for (int i = 0; i < maxDiffBackoff.length && fieldPairs.size() < maxPairs; ++i) {
            long[] diffMatrixElements = this.pair(pairedFromIndices, pairedToIndices, maxDiffBackoff[i]);
            Arrays.sort(diffMatrixElements);
            for (long matrixElement : diffMatrixElements) {
                int diffScore;
                if (fieldPairs.size() == maxPairs || (diffScore = this.getDiffScore(matrixElement)) == 0x1FFFFF) continue block0;
                int fromIndex = this.getFromIndex(matrixElement);
                int toIndex = this.getToIndex(matrixElement);
                if (pairedFromIndices.get(fromIndex) || pairedToIndices.get(toIndex)) continue;
                fieldPairs.add(new HollowEffigyFieldPairer.EffigyFieldPair(this.from.getFields().get(fromIndex), this.to.getFields().get(toIndex), fromIndex, toIndex));
                pairedFromIndices.set(fromIndex);
                pairedToIndices.set(toIndex);
            }
        }
        this.addUnmatchedElements(fieldPairs, pairedFromIndices, pairedToIndices);
        return fieldPairs;
    }

    private void addUnmatchedElements(List<HollowEffigyFieldPairer.EffigyFieldPair> fieldPairs, BitSet pairedFromIndices, BitSet pairedToIndices) {
        int i;
        for (i = 0; i < this.from.getFields().size(); ++i) {
            if (pairedFromIndices.get(i)) continue;
            fieldPairs.add(new HollowEffigyFieldPairer.EffigyFieldPair(this.from.getFields().get(i), null, i, -1));
        }
        for (i = 0; i < this.to.getFields().size(); ++i) {
            if (pairedToIndices.get(i)) continue;
            fieldPairs.add(new HollowEffigyFieldPairer.EffigyFieldPair(null, this.to.getFields().get(i), -1, i));
        }
    }

    public long[] pair(BitSet pairedFromIndices, BitSet pairedToIndices, int maxDiff) {
        long[] diffMatrixElements = new long[this.from.getFields().size() * this.to.getFields().size()];
        int matrixElementIdx = 0;
        for (int i = 0; i < this.from.getFields().size(); ++i) {
            int fromIdx = i;
            if (pairedFromIndices.get(fromIdx)) {
                for (int j = 0; j < this.to.getFields().size(); ++j) {
                    diffMatrixElements[matrixElementIdx++] = this.getDiffMatrixElement(fromIdx, j, 0x1FFFFF);
                }
                continue;
            }
            HollowEffigy fromElement = this.getComparisonEffigy((HollowEffigy)this.from.getFields().get(fromIdx).getValue());
            HollowEffigyDiffRecord diffRecord = new HollowEffigyDiffRecord(fromElement);
            for (int j = 0; j < this.to.getFields().size(); ++j) {
                if (pairedToIndices.get(j)) {
                    diffMatrixElements[matrixElementIdx++] = this.getDiffMatrixElement(fromIdx, j, 0x1FFFFF);
                    continue;
                }
                HollowEffigy toElement = this.getComparisonEffigy((HollowEffigy)this.to.getFields().get(j).getValue());
                int diffScore = diffRecord.calculateDiff(toElement, maxDiff);
                diffMatrixElements[matrixElementIdx++] = this.getDiffMatrixElement(fromIdx, j, diffScore);
            }
        }
        return diffMatrixElements;
    }

    protected HollowEffigy getComparisonEffigy(HollowEffigy effigy) {
        return effigy;
    }

    private long getDiffMatrixElement(int fromIndex, int toIndex, int diffScore) {
        return (long)diffScore << 42 | (long)fromIndex << 21 | (long)toIndex;
    }

    private int getDiffScore(long diffMatrixElement) {
        return (int)(diffMatrixElement >> 42 & 0x1FFFFFL);
    }

    private int getFromIndex(long diffMatrixElement) {
        return (int)(diffMatrixElement >> 21 & 0x1FFFFFL);
    }

    private int getToIndex(long diffMatrixElement) {
        return (int)(diffMatrixElement & 0x1FFFFFL);
    }
}

