/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.jetty;

import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.history.ui.jetty.HollowHistoryHandler;
import com.netflix.hollow.tools.history.HollowHistory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;

public class HollowHistoryUIServer {
    private final Server server;
    private final HollowHistoryHandler handler;
    private final HollowHistoryUI ui;

    public HollowHistoryUIServer(HollowHistory history, int port) {
        this(new HollowHistoryUI("", history), port);
    }

    public HollowHistoryUIServer(HollowHistoryUI ui, int port) {
        this.server = new Server(port);
        this.handler = new HollowHistoryHandler(ui);
        this.ui = ui;
    }

    public void start() throws Exception {
        this.server.setHandler((Handler)this.handler);
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public HollowHistoryUI getUI() {
        return this.ui;
    }
}

