/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui.pages;

import com.netflix.hollow.diff.ui.HollowDiffSession;
import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.diff.ui.model.HollowDiffOverviewTypeEntry;
import com.netflix.hollow.diff.ui.pages.DiffPage;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;

public class DiffOverviewPage
extends DiffPage {
    public DiffOverviewPage(HollowDiffUI diffUI) {
        super(diffUI, "diff-overview.vm");
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowDiffSession session, VelocityContext ctx) {
        String sortBy = this.param(req, session, "overview", "sortBy", "diffs");
        ctx.put("typeOverviewEntries", this.getTypeEntries(sortBy));
    }

    private List<HollowDiffOverviewTypeEntry> getTypeEntries(String sortBy) {
        ArrayList<HollowDiffOverviewTypeEntry> overviewEntries = new ArrayList<HollowDiffOverviewTypeEntry>();
        for (HollowTypeDiff diff : this.getDiff().getTypeDiffs()) {
            long totalDiffScore = diff.getTotalDiffScore();
            int unmatchedInFrom = diff.getUnmatchedOrdinalsInFrom().size();
            int unmatchedInTo = diff.getUnmatchedOrdinalsInTo().size();
            int fromCount = 0;
            try {
                fromCount = diff.getTotalItemsInFromState();
            }
            catch (Exception ex) {
                System.out.println("DIFF_ERROR: Unable to getTotalItemsInFromState for type=" + diff.getTypeName());
                ex.printStackTrace();
            }
            int toCount = 0;
            try {
                toCount = diff.getTotalItemsInToState();
            }
            catch (Exception ex) {
                System.out.println("DIFF_ERROR: Unable to getTotalItemsInToState for type=" + diff.getTypeName());
                ex.printStackTrace();
            }
            overviewEntries.add(new HollowDiffOverviewTypeEntry(diff.getTypeName(), totalDiffScore, unmatchedInFrom, unmatchedInTo, fromCount, toCount));
        }
        if (sortBy == null || "diffs".equals(sortBy)) {
            Collections.sort(overviewEntries, new Comparator<HollowDiffOverviewTypeEntry>(){

                @Override
                public int compare(HollowDiffOverviewTypeEntry o1, HollowDiffOverviewTypeEntry o2) {
                    long o1Diff = o1.getTotalDiffScore();
                    long o2Diff = o2.getTotalDiffScore();
                    if (o2Diff < o1Diff) {
                        return -1;
                    }
                    if (o2Diff == o1Diff) {
                        return 0;
                    }
                    return 1;
                }
            });
        } else if ("unmatchedFrom".equals(sortBy)) {
            Collections.sort(overviewEntries, new Comparator<HollowDiffOverviewTypeEntry>(){

                @Override
                public int compare(HollowDiffOverviewTypeEntry o1, HollowDiffOverviewTypeEntry o2) {
                    return o2.getUnmatchedInFrom() - o1.getUnmatchedInFrom();
                }
            });
        } else if ("unmatchedTo".equals(sortBy)) {
            Collections.sort(overviewEntries, new Comparator<HollowDiffOverviewTypeEntry>(){

                @Override
                public int compare(HollowDiffOverviewTypeEntry o1, HollowDiffOverviewTypeEntry o2) {
                    return o2.getUnmatchedInTo() - o1.getUnmatchedInTo();
                }
            });
        } else if ("fromCount".equals(sortBy)) {
            Collections.sort(overviewEntries, new Comparator<HollowDiffOverviewTypeEntry>(){

                @Override
                public int compare(HollowDiffOverviewTypeEntry o1, HollowDiffOverviewTypeEntry o2) {
                    return o2.getTotalInFrom() - o1.getTotalInFrom();
                }
            });
        } else if ("toCount".equals(sortBy)) {
            Collections.sort(overviewEntries, new Comparator<HollowDiffOverviewTypeEntry>(){

                @Override
                public int compare(HollowDiffOverviewTypeEntry o1, HollowDiffOverviewTypeEntry o2) {
                    return o2.getTotalInTo() - o1.getTotalInTo();
                }
            });
        }
        return overviewEntries;
    }
}

