/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.codegen.gradle;

import com.netflix.graphql.dgs.codegen.gradle.ClientUtilsConventions;
import com.netflix.graphql.dgs.codegen.gradle.CodegenPlugin;
import com.netflix.graphql.dgs.codegen.gradle.CodegenPluginExtension;
import com.netflix.graphql.dgs.codegen.gradle.GenerateJavaTask;
import java.io.File;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/netflix/graphql/dgs/codegen/gradle/CodegenPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "addDependencyLock", "codegenExtension", "Lcom/netflix/graphql/dgs/codegen/gradle/CodegenPluginExtension;", "Companion", "graphql-dgs-codegen-gradle"})
public final class CodegenPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String GRADLE_GROUP = "DGS GraphQL Codegen";
    private static final Logger logger = Logging.getLogger(CodegenPlugin.class);

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CodegenPluginExtension codegenExtension = (CodegenPluginExtension)project.getExtensions().create("codegen", CodegenPluginExtension.class, new Object[0]);
        project.getPlugins().apply(JavaPlugin.class);
        TaskProvider generateJavaTaskProvider = project.getTasks().register("generateJava", GenerateJavaTask.class);
        generateJavaTaskProvider.configure(arg_0 -> CodegenPlugin.apply$lambda$1(CodegenPlugin::apply$lambda$0, arg_0));
        JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.1")) < 0) {
            throw new RuntimeException("Gradle versions < 7.1 are no longer supported by DGS Codegen. Please upgrade your Gradle version.");
        }
        SourceSetContainer sourceSets = javaExtension.getSourceSets();
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        Provider outputDir2 = generateJavaTaskProvider.map(arg_0 -> CodegenPlugin.apply$lambda$2(apply.outputDir.1.INSTANCE, arg_0));
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[]{outputDir2};
        ConfigurableFileCollection configurableFileCollection = project.files(objectArray2);
        objectArray2 = new Object[]{generateJavaTaskProvider};
        objectArray[0] = configurableFileCollection.builtBy(objectArray2);
        mainSourceSet.getJava().srcDirs(objectArray);
        project.getConfigurations().create("dgsCodegen");
        Configuration configuration = (Configuration)project.getConfigurations().findByName("dgsCodegen");
        if (configuration != null) {
            configuration.setCanBeResolved(true);
        }
        Intrinsics.checkNotNull((Object)codegenExtension);
        this.addDependencyLock(project, codegenExtension);
        project.afterEvaluate(arg_0 -> CodegenPlugin.apply$lambda$4(arg_0 -> CodegenPlugin.apply$lambda$3(codegenExtension, arg_0), arg_0));
    }

    private final void addDependencyLock(Project project, CodegenPluginExtension codegenExtension) {
        String dependencyLockString = ClientUtilsConventions.getDependencyString$default(ClientUtilsConventions.INSTANCE, null, 1, null);
        try {
            if (((Boolean)codegenExtension.getClientCoreConventionsEnabled().getOrElse((Object)true)).booleanValue()) {
                project.getDependencyLocking().getIgnoredDependencies().add((Object)dependencyLockString);
                logger.info("DGS CodeGen added ignored dependency [{}].", (Object)dependencyLockString);
            }
        }
        catch (Exception e) {
            logger.info("Failed to add DGS CodeGen to ignoredDependencies because: {}", (Object)dependencyLockString, (Object)e);
        }
    }

    private static final Unit apply$lambda$0(GenerateJavaTask it) {
        it.setGroup(GRADLE_GROUP);
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final File apply$lambda$2(Function1 $tmp0, Object in) {
        return (File)$tmp0.invoke(in);
    }

    private static final Unit apply$lambda$3(CodegenPluginExtension $codegenExtension, Project p) {
        if (((Boolean)$codegenExtension.getClientCoreConventionsEnabled().getOrElse((Object)true)).booleanValue()) {
            logger.info("Applying CodegenPlugin Client Utils conventions.");
            Intrinsics.checkNotNull((Object)p);
            Optional<Object> optional = Optional.ofNullable($codegenExtension.getClientCoreVersion().getOrNull());
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
            Optional<Object> optional2 = Optional.ofNullable($codegenExtension.getClientCoreScope().getOrNull());
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"ofNullable(...)");
            ClientUtilsConventions.INSTANCE.apply(p, optional, optional2);
        }
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/codegen/gradle/CodegenPlugin$Companion;", "", "<init>", "()V", "GRADLE_GROUP", "", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "Lorg/gradle/api/logging/Logger;", "graphql-dgs-codegen-gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

