/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.EVCacheOperationImpl;
import net.spy.memcached.protocol.ascii.MetaSetOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSetOperationImpl
extends EVCacheOperationImpl
implements MetaSetOperation {
    private static final Logger log = LoggerFactory.getLogger(MetaSetOperationImpl.class);
    private static final OperationStatus STORED = new OperationStatus(true, "HD", StatusCode.SUCCESS);
    private static final OperationStatus NOT_STORED = new OperationStatus(false, "NS", StatusCode.SUCCESS);
    private static final OperationStatus EXISTS = new OperationStatus(false, "EX", StatusCode.SUCCESS);
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NF", StatusCode.SUCCESS);
    private final MetaSetOperation.Callback cb;
    private final MetaSetOperation.Builder builder;
    private boolean stored = false;
    private long returnedCas = 0L;

    public MetaSetOperationImpl(MetaSetOperation.Builder builder, MetaSetOperation.Callback cb) {
        super(cb);
        this.builder = builder;
        this.cb = cb;
    }

    @Override
    public void handleLine(String line) {
        if (log.isDebugEnabled()) {
            log.debug("meta set of {} returned {}", (Object)this.builder.getKey(), (Object)line);
        }
        if (line.equals("HD")) {
            this.stored = true;
            this.getCallback().receivedStatus(STORED);
            this.cb.setComplete(this.builder.getKey(), this.returnedCas, true);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.equals("NS")) {
            this.getCallback().receivedStatus(NOT_STORED);
            this.cb.setComplete(this.builder.getKey(), this.returnedCas, false);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.equals("EX")) {
            this.getCallback().receivedStatus(EXISTS);
            this.cb.setComplete(this.builder.getKey(), this.returnedCas, false);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.equals("NF")) {
            this.getCallback().receivedStatus(NOT_FOUND);
            this.cb.setComplete(this.builder.getKey(), this.returnedCas, false);
            this.transitionState(OperationState.COMPLETE);
        } else if (line.startsWith("HD ") || line.startsWith("NS ") || line.startsWith("EX ") || line.startsWith("NF ")) {
            String[] parts = line.split(" ");
            this.stored = parts[0].equals("HD");
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i].length() <= 0) continue;
                char flag = parts[i].charAt(0);
                String value = parts[i].substring(1);
                if (flag == 'c') {
                    this.returnedCas = Long.parseLong(value);
                }
                this.cb.gotMetaData(this.builder.getKey(), flag, value);
            }
            this.cb.setComplete(this.builder.getKey(), this.returnedCas, this.stored);
            this.getCallback().receivedStatus(this.stored ? STORED : NOT_STORED);
            this.transitionState(OperationState.COMPLETE);
        }
    }

    @Override
    public void initialize() {
        long recasidToUse;
        ArrayList<String> flags = new ArrayList<String>();
        flags.add(this.builder.getMode().getFlag());
        if (this.builder.getCas() > 0L) {
            flags.add("C" + this.builder.getCas());
        }
        if ((recasidToUse = this.builder.getRecasid()) > 0L) {
            flags.add("E" + recasidToUse);
            if (log.isDebugEnabled()) {
                log.debug("Using explicit recasid (E flag) for key {}: {}", (Object)this.builder.getKey(), (Object)recasidToUse);
            }
        }
        if (this.builder.getFlags() != 0) {
            flags.add("F" + this.builder.getFlags());
        }
        if (this.builder.getExpiration() > 0) {
            flags.add("T" + this.builder.getExpiration());
        }
        if (this.builder.isMarkStale()) {
            flags.add("I");
        }
        byte[] keyBytes = KeyUtil.getKeyBytes((String)this.builder.getKey());
        byte[] valueBytes = this.builder.getValue();
        StringBuilder cmdBuilder = new StringBuilder();
        cmdBuilder.append("ms ").append(this.builder.getKey()).append(" ").append(valueBytes.length);
        for (String flag : flags) {
            cmdBuilder.append(" ").append(flag);
        }
        cmdBuilder.append("\r\n");
        byte[] cmdBytes = cmdBuilder.toString().getBytes();
        int totalSize = cmdBytes.length + valueBytes.length + 2;
        ByteBuffer b = ByteBuffer.allocate(totalSize);
        b.put(cmdBytes);
        b.put(valueBytes);
        b.put((byte)13);
        b.put((byte)10);
        b.flip();
        this.setBuffer(b);
    }

    public String toString() {
        return "Cmd: ms Key: " + this.builder.getKey() + " Mode: " + (Object)((Object)this.builder.getMode());
    }
}

