/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;

public interface MetaSetOperation
extends Operation {

    public static class Builder {
        private String key;
        private byte[] value;
        private int flags = 0;
        private int expiration = 0;
        private long cas = 0L;
        private long recasid = 0L;
        private SetMode mode = SetMode.SET;
        private boolean returnCas = false;
        private boolean returnTtl = false;
        private boolean markStale = false;

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(byte[] value) {
            this.value = value;
            return this;
        }

        public Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder expiration(int expiration) {
            this.expiration = expiration;
            return this;
        }

        public Builder cas(long cas) {
            this.cas = cas;
            return this;
        }

        public Builder recasid(long recasid) {
            this.recasid = recasid;
            return this;
        }

        public Builder mode(SetMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder returnCas(boolean returnCas) {
            this.returnCas = returnCas;
            return this;
        }

        public Builder returnTtl(boolean returnTtl) {
            this.returnTtl = returnTtl;
            return this;
        }

        public Builder markStale(boolean markStale) {
            this.markStale = markStale;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public int getFlags() {
            return this.flags;
        }

        public int getExpiration() {
            return this.expiration;
        }

        public long getCas() {
            return this.cas;
        }

        public long getRecasid() {
            return this.recasid;
        }

        public SetMode getMode() {
            return this.mode;
        }

        public boolean isReturnCas() {
            return this.returnCas;
        }

        public boolean isReturnTtl() {
            return this.returnTtl;
        }

        public boolean isMarkStale() {
            return this.markStale;
        }

        public Builder build() {
            return this;
        }
    }

    public static enum SetMode {
        SET("MS"),
        ADD("ME"),
        REPLACE("MR"),
        APPEND("MA"),
        PREPEND("MP");

        private final String flag;

        private SetMode(String flag) {
            this.flag = flag;
        }

        public String getFlag() {
            return this.flag;
        }
    }

    public static interface Callback
    extends OperationCallback {
        public void setComplete(String var1, long var2, boolean var4);

        public void gotMetaData(String var1, char var2, String var3);
    }
}

