/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import com.netflix.evcache.operation.EVCacheItem;
import com.netflix.evcache.operation.EVCacheItemMetaData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.spy.memcached.CachedData;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.EVCacheOperationImpl;
import net.spy.memcached.protocol.ascii.MetaGetBulkOperation;
import net.spy.memcached.protocol.ascii.OperationReadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaGetBulkOperationImpl
extends EVCacheOperationImpl
implements MetaGetBulkOperation {
    private static final Logger log = LoggerFactory.getLogger(MetaGetBulkOperationImpl.class);
    private static final OperationStatus END = new OperationStatus(true, "EN", StatusCode.SUCCESS);
    private final MetaGetBulkOperation.Callback cb;
    private final MetaGetBulkOperation.Config config;
    private String currentKey = null;
    private int currentFlags = 0;
    private long currentCas = 0L;
    private byte[] currentData = null;
    private int readOffset = 0;
    private byte lookingFor = 0;
    private EVCacheItemMetaData currentMetaData = null;
    private AtomicInteger totalKeys = new AtomicInteger(0);
    private AtomicInteger foundKeys = new AtomicInteger(0);
    private AtomicInteger notFoundKeys = new AtomicInteger(0);
    private AtomicInteger responsesReceived = new AtomicInteger(0);

    public MetaGetBulkOperationImpl(MetaGetBulkOperation.Config config, MetaGetBulkOperation.Callback cb) {
        super(cb);
        this.config = config;
        this.cb = cb;
        this.totalKeys.set(config.getKeys().size());
    }

    @Override
    public void handleLine(String line) {
        if (log.isDebugEnabled()) {
            log.debug("meta get bulk returned: {}", (Object)line);
        }
        if (line.startsWith("VA ")) {
            this.parseBulkValue(line);
            this.setReadType(OperationReadType.DATA);
        } else if (line.startsWith("HD")) {
            this.parseBulkHit(line);
            this.checkAndCompleteIfDone();
        } else if (line.startsWith("EN")) {
            this.parseBulkMiss(line);
            this.checkAndCompleteIfDone();
        } else if (line.length() == 0) {
            // empty if block
        }
    }

    private void checkAndCompleteIfDone() {
        int total;
        int received = this.responsesReceived.get();
        if (received >= (total = this.totalKeys.get())) {
            this.cb.bulkComplete(this.totalKeys.get(), this.foundKeys.get(), this.notFoundKeys.get());
            this.getCallback().receivedStatus(END);
            this.transitionState(OperationState.COMPLETE);
        }
    }

    private void parseBulkValue(String line) {
        String[] parts = line.split(" ");
        if (parts.length < 2) {
            return;
        }
        int size = Integer.parseInt(parts[1]);
        this.currentData = new byte[size];
        this.readOffset = 0;
        this.lookingFor = 0;
        this.currentMetaData = new EVCacheItemMetaData();
        this.currentKey = null;
        this.parseMetadata(null, parts, 2);
        this.foundKeys.incrementAndGet();
    }

    private void parseBulkHit(String line) {
        String[] parts = line.split(" ");
        if (parts.length < 1) {
            return;
        }
        this.currentKey = null;
        this.currentMetaData = new EVCacheItemMetaData();
        this.parseMetadata(null, parts, 1);
        EVCacheItem<Object> item = new EVCacheItem<Object>();
        item.setData(null);
        item.setFlag(this.currentFlags);
        this.copyMetadata(item.getItemMetaData(), this.currentMetaData);
        if (this.currentKey != null) {
            this.cb.gotData(this.currentKey, item);
        }
        this.foundKeys.incrementAndGet();
        this.responsesReceived.incrementAndGet();
    }

    private void parseBulkMiss(String line) {
        String[] parts = line.split(" ");
        String key = null;
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].length() <= 0 || parts[i].charAt(0) != 'k') continue;
            key = parts[i].substring(1);
            break;
        }
        if (key != null) {
            this.cb.keyNotFound(key);
        }
        this.notFoundKeys.incrementAndGet();
        this.responsesReceived.incrementAndGet();
    }

    private void parseMetadata(String key, String[] parts, int startIndex) {
        this.currentFlags = 0;
        this.currentCas = 0L;
        block8: for (int i = startIndex; i < parts.length; ++i) {
            if (parts[i].length() <= 0) continue;
            char flag = parts[i].charAt(0);
            String value = parts[i].substring(1);
            switch (flag) {
                case 'k': {
                    this.currentKey = value;
                    continue block8;
                }
                case 'f': {
                    this.currentFlags = Integer.parseInt(value);
                    continue block8;
                }
                case 'c': {
                    this.currentCas = Long.parseLong(value);
                    if (this.currentMetaData == null) continue block8;
                    this.currentMetaData.setCas(this.currentCas);
                    continue block8;
                }
                case 't': {
                    if (this.currentMetaData == null) continue block8;
                    this.currentMetaData.setSecondsLeftToExpire(Integer.parseInt(value));
                    continue block8;
                }
                case 's': {
                    if (this.currentMetaData == null) continue block8;
                    this.currentMetaData.setSizeInBytes(Integer.parseInt(value));
                    continue block8;
                }
                case 'l': {
                    if (this.currentMetaData == null) continue block8;
                    this.currentMetaData.setSecondsSinceLastAccess(Long.parseLong(value));
                }
            }
        }
    }

    public void handleRead(ByteBuffer b) {
        if (this.currentData == null) {
            return;
        }
        if (this.lookingFor == 0) {
            int toRead = this.currentData.length - this.readOffset;
            int available = b.remaining();
            toRead = Math.min(toRead, available);
            if (log.isDebugEnabled()) {
                log.debug("Reading {} bytes for key {}", (Object)toRead, (Object)this.currentKey);
            }
            b.get(this.currentData, this.readOffset, toRead);
            this.readOffset += toRead;
        }
        if (this.readOffset == this.currentData.length && this.lookingFor == 0) {
            EVCacheItem<Object> item = new EVCacheItem<Object>();
            CachedData cachedData = new CachedData(this.currentFlags, this.currentData, Integer.MAX_VALUE);
            item.setData(cachedData);
            item.setFlag(this.currentFlags);
            this.copyMetadata(item.getItemMetaData(), this.currentMetaData);
            this.cb.gotData(this.currentKey, item);
            this.responsesReceived.incrementAndGet();
            this.lookingFor = (byte)13;
        }
        if (this.lookingFor != 0 && b.hasRemaining()) {
            do {
                byte tmp = b.get();
                assert (tmp == this.lookingFor) : "Expecting " + this.lookingFor + ", got " + (char)tmp;
                switch (this.lookingFor) {
                    case 13: {
                        this.lookingFor = (byte)10;
                        break;
                    }
                    case 10: {
                        this.lookingFor = 0;
                        break;
                    }
                    default: {
                        assert (false) : "Looking for unexpected char: " + (char)this.lookingFor;
                        {
                            break;
                        }
                    }
                }
            } while (this.lookingFor != 0 && b.hasRemaining());
            if (this.lookingFor == 0) {
                this.currentData = null;
                this.currentKey = null;
                this.currentMetaData = null;
                this.readOffset = 0;
                this.setReadType(OperationReadType.LINE);
                this.checkAndCompleteIfDone();
            }
        }
    }

    private void copyMetadata(EVCacheItemMetaData dest, EVCacheItemMetaData src) {
        if (dest != null && src != null) {
            dest.setCas(src.getCas());
            dest.setSecondsLeftToExpire(src.getSecondsLeftToExpire());
            dest.setSecondsSinceLastAccess(src.getSecondsSinceLastAccess());
            dest.setSizeInBytes(src.getSizeInBytes());
            dest.setSlabClass(src.getSlabClass());
            dest.setHasBeenFetchedAfterWrite(src.isHasBeenFetchedAfterWrite());
        }
    }

    @Override
    public void initialize() {
        ArrayList<String> flags = new ArrayList<String>();
        flags.add("k");
        if (this.config.isIncludeCas()) {
            flags.add("c");
        }
        if (this.config.isIncludeTtl()) {
            flags.add("t");
        }
        if (this.config.isIncludeSize()) {
            flags.add("s");
        }
        if (this.config.isIncludeLastAccess()) {
            flags.add("l");
        }
        if (this.config.isServeStale()) {
            flags.add("R" + this.config.getMaxStaleTime());
        }
        flags.add("f");
        flags.add("v");
        StringBuilder cmdBuilder = new StringBuilder();
        for (String key : this.config.getKeys()) {
            cmdBuilder.append("mg ").append(key);
            for (String flag : flags) {
                cmdBuilder.append(" ").append(flag);
            }
            cmdBuilder.append("\r\n");
        }
        String fullCommand = cmdBuilder.toString();
        byte[] cmdBytes = fullCommand.getBytes();
        ByteBuffer b = ByteBuffer.allocate(cmdBytes.length);
        b.put(cmdBytes);
        b.flip();
        this.setBuffer(b);
    }

    public String toString() {
        return "Cmd: mg Keys: " + this.config.getKeys().size();
    }
}

