/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import com.netflix.evcache.operation.EVCacheItem;
import java.util.Collection;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;

public interface MetaGetBulkOperation
extends Operation {

    public static class Config {
        private final Collection<String> keys;
        private boolean includeTtl = true;
        private boolean includeCas = true;
        private boolean includeSize = false;
        private boolean includeLastAccess = false;
        private boolean serveStale = false;
        private int maxStaleTime = 60;

        public Config(Collection<String> keys) {
            this.keys = keys;
        }

        public Collection<String> getKeys() {
            return this.keys;
        }

        public boolean isIncludeTtl() {
            return this.includeTtl;
        }

        public boolean isIncludeCas() {
            return this.includeCas;
        }

        public boolean isIncludeSize() {
            return this.includeSize;
        }

        public boolean isIncludeLastAccess() {
            return this.includeLastAccess;
        }

        public boolean isServeStale() {
            return this.serveStale;
        }

        public int getMaxStaleTime() {
            return this.maxStaleTime;
        }

        public Config includeTtl(boolean include) {
            this.includeTtl = include;
            return this;
        }

        public Config includeCas(boolean include) {
            this.includeCas = include;
            return this;
        }

        public Config includeSize(boolean include) {
            this.includeSize = include;
            return this;
        }

        public Config includeLastAccess(boolean include) {
            this.includeLastAccess = include;
            return this;
        }

        public Config serveStale(boolean serve) {
            this.serveStale = serve;
            return this;
        }

        public Config maxStaleTime(int seconds) {
            this.maxStaleTime = seconds;
            return this;
        }
    }

    public static interface Callback
    extends OperationCallback {
        public void gotData(String var1, EVCacheItem<Object> var2);

        public void keyNotFound(String var1);

        public void bulkComplete(int var1, int var2, int var3);
    }
}

