/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.archaius.api.Property;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheExecutorMBean;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.ThreadPoolMonitor;
import java.lang.management.ManagementFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheExecutor
extends ThreadPoolExecutor
implements EVCacheExecutorMBean {
    private static final Logger log = LoggerFactory.getLogger(EVCacheExecutor.class);
    private final Property<Integer> maxAsyncPoolSize;
    private final Property<Integer> coreAsyncPoolSize;
    private final String name;

    public EVCacheExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler, String name) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("EVCacheExecutor-" + name + "-%d").build());
        this.name = name;
        this.maxAsyncPoolSize = EVCacheConfig.getInstance().getPropertyRepository().get("EVCacheExecutor." + name + ".max.size", Integer.class).orElse((Object)maximumPoolSize);
        this.setMaximumPoolSize((Integer)this.maxAsyncPoolSize.get());
        this.coreAsyncPoolSize = EVCacheConfig.getInstance().getPropertyRepository().get("EVCacheExecutor." + name + ".core.size", Integer.class).orElse((Object)corePoolSize);
        this.setCorePoolSize((Integer)this.coreAsyncPoolSize.get());
        this.setKeepAliveTime(keepAliveTime, unit);
        this.maxAsyncPoolSize.subscribe(this::setMaximumPoolSize);
        this.coreAsyncPoolSize.subscribe(i -> {
            this.setCorePoolSize((int)i);
            this.prestartAllCoreThreads();
        });
        this.setupMonitoring(name);
        ThreadPoolMonitor.attach((Registry)EVCacheMetricsFactory.getInstance().getRegistry(), (ThreadPoolExecutor)this, (String)("internal.evc.client.executor-" + name));
    }

    private void setupMonitoring(String name) {
        block4: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=ThreadPool,SubGroup=" + name);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                mbeanServer.registerMBean(this, mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception", (Throwable)e);
            }
        }
    }

    @Override
    public void shutdown() {
        block2: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=ThreadPool,SubGroup=" + this.name);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                mbeanServer.unregisterMBean(mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Exception", (Throwable)e);
            }
        }
        super.shutdown();
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }
}

